package cn.com.duiba.millionaire.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2018/2/12.
 */
public enum CreditsConsumeStatusTypeEnum {
    PROCESSING(0, "处理中"),
    FAILED(1, "失败"),
    SUCCESS(2, "成功");

    private static final Map<Integer, CreditsConsumeStatusTypeEnum> statusMap = new HashMap<>();
    static{
        for(CreditsConsumeStatusTypeEnum statusEnum : values()){
            statusMap.put(statusEnum.code, statusEnum);
        }
    }

    private Integer code;
    private String desc;

    CreditsConsumeStatusTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static CreditsConsumeStatusTypeEnum getByCode(Integer code){
        return statusMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
