package cn.com.duiba.millionaire.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.millionaire.center.api.dto.MillionaireGameSkinDto;
import cn.com.duiba.millionaire.center.api.dto.PagenationDto;
import cn.com.duiba.millionaire.center.api.requestParam.MillGameSkinQry;

import java.util.List;

/**
 * Created by sunchangji on 2018/3/8.
 */
@AdvancedFeignClient
public interface RemoteMillionaireGameSkinService {

    /**
     * 新增游戏皮肤配置
     *
     * @param gameSkinDto
     * @return
     */
    boolean gameSkinInsert(MillionaireGameSkinDto gameSkinDto);

    /**
     * 更新
     *
     * @param gameSkinDto
     * @return
     */
    boolean updateById(MillionaireGameSkinDto gameSkinDto);

    /**
     * 根据主键id查询
     *
     * @param id
     * @return
     */
    MillionaireGameSkinDto findById(Long id);

    /**
     * 分页查询
     *
     * @param millGameSkinQry
     * @return
     */
    PagenationDto<MillionaireGameSkinDto> findByPage(MillGameSkinQry millGameSkinQry);

    /**
     * 查询全部,数据只包含id和名称
     *
     * @return
     */
    List<MillionaireGameSkinDto> findIdAndNameAll();
}
