package cn.com.duiba.millionaire.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.millionaire.center.api.dto.MillionaireMainMeetingDto;
import cn.com.duiba.millionaire.center.api.requestParam.MillionaireMainMeetingRequestParam;

import java.util.List;
import java.util.Map;

/**
 * Created by sty on 2018/1/18.
 * 冲顶大会 主会场配置
 */
@AdvancedFeignClient
public interface RemoteMillionaireMainMeetingService {

    /**
     *
     * countMillionaireMainMeetingList:(这里用一句话描述这个方法的作用). <br/>
     * 统计冲顶主会场条数
     * @param param
     * @return
     * @since JDK 1.8
     */
    Integer countMillionaireMainMeetingList(MillionaireMainMeetingRequestParam param);

    /**
     *
     * getmillionaireMainMeetingList:(这里用一句话描述这个方法的作用). <br/>
     * 统计冲顶主会场数据
     * pageNum  当前页码  pageSize 条数
     * @param param
     * @return
     * @since JDK 1.8
     */
     List<MillionaireMainMeetingDto> getMillionaireMainMeetingList(MillionaireMainMeetingRequestParam param);

    /**
     *
     * findMillionaireMeetingById:(这里用一句话描述这个方法的作用). <br/>
     * 根据id 查询主会场信息
     *  MillionaireMainMeetingDto 中  加一个 list<MillionaireActivityDto> 变量  来存放 分会场信息 一个接口把 所有信息 返回出来
     * @param id
     * @return
     * @since JDK 1.8
     */
     MillionaireMainMeetingDto findMillionaireMeetingById(Long id);

    /**
     *
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 根据id 删除 主会场
     * @param id
     * @return
     * @since JDK 1.8
     */
     Boolean delete(Long id);

    /**
     *
     * saveOrUPdateMillionaireMainMeeting:(这里用一句话描述这个方法的作用). <br/>
     * dto 中id为null 时  为新增  有值 为更新
     * activityIds 是分会场id
     *
     * 保存成功  true  失败false
     * @param dto
     * @param activityIds
     * @return
     * @since JDK 1.8
     */
     Boolean saveOrUpdateMillionaireMainMeeting(MillionaireMainMeetingDto dto ,List<Long> activityIds);
}
