package cn.com.duiba.millionaire.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.millionaire.center.api.dto.MillionaireWithdrawDto;
import cn.com.duiba.millionaire.center.api.param.WithdrawApplyParam;
import cn.com.duiba.millionaire.center.api.result.WithdrawApplyResult;

import java.util.List;

/**
 * Created by xiaoxuda on 2018/2/1.
 */
@AdvancedFeignClient
public interface RemoteMillionaireWithdrawService {
    /**
     * 申请提现
     * @param param
     * @return true:申请成功（用户及开发者余额扣除成功，待发起转账），false:申请失败，具体原因见failMsg
     */
    WithdrawApplyResult applyWithdraw(WithdrawApplyParam param);

    WithdrawApplyResult applyWithdrawAllBalance(WithdrawApplyParam param);

    WithdrawApplyResult applyWithdrawAllBalanceWithShareCode(Long consumerId, Long appId, String shareCode);

    /**
     * 查询单笔提现记录
     * @param id
     * @return
     */
    MillionaireWithdrawDto findById(Long id);

    /**
     * 查询用户所有提现记录
     * @param consumerId
     * @return
     */
    List<MillionaireWithdrawDto> batchFindByConsumerId(Long consumerId);

    /**
     * 统计已申请的提现金额，不包含失败记录
     * @param consumerId
     * @return
     */
    Long countWithdrawAmount(Long consumerId);
}
