package cn.com.duiba.millionaire.center.api.cache;

import cn.com.duiba.millionaire.center.api.constant.RedisKeyFactory;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by zzy on 2018/1/22.
 */
public class UserAnswerList implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 用户未提交答案提供的默认答案
     */
    public static final String UNSUBMIT_ANSWER = "X";
    /**
     * 用户id
     */
    private Long consumerId;
    /**
     * 分会场活动id
     */
    private Long activityId;
    /**
     * 用户答案map
     */
    private Map<Integer, String> userAnswerMap = new HashMap<>();


    /**
     * 生成key
     *
     * @param activityId
     * @param consumerId
     * @return
     */
    public static String generateCacheKey(Long activityId, Long consumerId) {
        return RedisKeyFactory.K005.toString() + activityId + "_" + consumerId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Map<Integer, String> getUserAnswerMap() {
        return userAnswerMap;
    }

    public void setUserAnswerMap(Map<Integer, String> userAnswerMap) {
        this.userAnswerMap = userAnswerMap;
    }
}
