package cn.com.duiba.millionaire.center.api.cache;

import cn.com.duiba.millionaire.center.api.constant.RedisKeyFactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by zzy on 2018/1/22.
 */
public class UserStatus implements Serializable {

    private static final long serialVersionUID = -4950782205762956126L;

    /**
     * 用户id
     */
    private Long consumerId;
    /**
     * 分会场活动id
     */
    private Long activityId;
    /**
     * 是否为观战模式
     */
    private boolean showMode = false;
    /**
     * 已经使用复活卡次数
     */
    private int renascenceCount = 0;

    /**
     * 使用复活卡的题目index
     */
    private List<Integer> reliveQuestionIndexList = new ArrayList<>();

    /**
     * 生成key
     *
     * @param activityId
     * @param consumerId
     * @return
     */
    public static String generateCacheKey(Long activityId, Long consumerId) {
        return RedisKeyFactory.K004.toString() + activityId + "_" + consumerId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public boolean isShowMode() {
        return showMode;
    }

    public void setShowMode(boolean showMode) {
        this.showMode = showMode;
    }

    public int getRenascenceCount() {
        return renascenceCount;
    }

    public void setRenascenceCount(int renascenceCount) {
        this.renascenceCount = renascenceCount;
    }

    public List<Integer> getReliveQuestionIndexList() {
        return reliveQuestionIndexList;
    }

    public void setReliveQuestionIndexList(List<Integer> reliveQuestionIndexList) {
        this.reliveQuestionIndexList = reliveQuestionIndexList;
    }
}
