package cn.com.duiba.millionaire.center.api.constant;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br>
 * 用法：枚举_业务参数
 * 生成的key前缀为：MILLC_K001_
 * <p>
 * Created by zzy on 2017/2/9.
 */
public enum RedisKeyFactory {
    K001("选项计数"),
    K002("复活卡计数"),
    K003("中奖列表"),
    /**
     * 包含：1.是否为观战模式；2.已经使用复活卡次数
     */
    K004("用户状态"),
    /**
     * 包含：用户本场活动选择的答案情况
     */
    K005("用户答题选择"),
    K006("分会场活动参与人数"),
    K007("分会场信息"),
    K008("用户信息"),
    K009("分会场题目"),
    K010("主会场信息"),
    /**
     * 每题使用复活卡的人list
     */
    K011("复活卡人数记录"),
    K012("用户复活卡数量"),
    ;

    private String description;

    private RedisKeyFactory(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    /**
     * millionaire-center
     */
    private static final String SPACE = "MILLC";

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }


}
