package cn.com.duiba.millionaire.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动分会场
 */
public class MillionaireActivityDto implements Serializable{

    private static final long serialVersionUID = -4925331540405976016L;

    public static final int STATUS_OPEN = 1;

    public static final int STATUS_CLOSE = 0;

    /**
     * 主键
     */
    private Long id;
    /**
     *  分会场标题，仅用于管理端展示
     */
    private String title;
    /**
     *  分会场活动皮肤id
     */
    private Long brickId;
    /**
     * 题目数
     */
    private Long questionNum;
    /**
     * 暖场开始时间(绝对时间)
     */
    private Date nuanchangStartTime;
    /**
     * 暖场持续时间，秒
     */
    private Long nuanchangDuringTime;
    /**
     * 暖场mp3
     */
    private String nuanchangMp3Url;
    /**
     * 答题时间 秒
     */
    private Long answerDuring;
    /**
     * 实际奖金总数，元
     */
    private Long totalMoney;
    /**
     * 展示金额，元
     */
    private Long showMoney;
    /**
     * 金额倍率，展示金额/实际金额
     */
    private Long moneyRate;
    /**
     * 题库ID
     */
    private Long questionBagId;
    /**
     * 是否需要积分，boolean
     */
    private Boolean needCredits;
    /**
     * 积分价值，人民币单位分
     */
    private Long credits;

    /**
     * 最多复活次数
     */
    private Long maxRevive;

    /**
     * 开启状态  0未开启 1开启
     */
    private Integer openStatus;
    /**
     * 删除的标识
     */
    private Integer deleted;

    /**
     * 结束loading文案
     */
    private String endLoadingText;
    /**
     * 结束loading  mp3
     */
    private String endLoadingMp3;
    /**
     * 结束loading 时长
     */
    private Long endLoadingDuring;
    /**
     * 暖场文案
     */
    private String nuanchangText;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title ;
    }

    public Long getBrickId() {
        return brickId;
    }

    public void setBrickId(Long brickId) {
        this.brickId = brickId;
    }

    public Long getQuestionNum() {
        return questionNum;
    }

    public void setQuestionNum(Long questionNum) {
        this.questionNum = questionNum;
    }

    public Date getNuanchangStartTime() {
        return nuanchangStartTime;
    }

    public void setNuanchangStartTime(Date nuanchangStartTime) {
        this.nuanchangStartTime = nuanchangStartTime;
    }

    public Long getNuanchangDuringTime() {
        return nuanchangDuringTime;
    }

    public void setNuanchangDuringTime(Long nuanchangDuringTime) {
        this.nuanchangDuringTime = nuanchangDuringTime;
    }

    public String getNuanchangMp3Url() {
        return nuanchangMp3Url;
    }

    public void setNuanchangMp3Url(String nuanchangMp3Url) {
        this.nuanchangMp3Url = nuanchangMp3Url ;
    }

    public Long getAnswerDuring() {
        return answerDuring;
    }

    public void setAnswerDuring(Long answerDuring) {
        this.answerDuring = answerDuring;
    }

    public Long getTotalMoney() {
        return totalMoney;
    }

    public void setTotalMoney(Long totalMoney) {
        this.totalMoney = totalMoney;
    }

    public Long getShowMoney() {
        return showMoney;
    }

    public void setShowMoney(Long showMoney) {
        this.showMoney = showMoney;
    }

    public Long getMoneyRate() {
        return moneyRate;
    }

    public void setMoneyRate(Long moneyRate) {
        this.moneyRate = moneyRate;
    }

    public Long getQuestionBagId() {
        return questionBagId;
    }

    public void setQuestionBagId(Long questionBagId) {
        this.questionBagId = questionBagId;
    }

    public Boolean getNeedCredits() {
        return needCredits;
    }

    public void setNeedCredits(Boolean needCredits) {
        this.needCredits = needCredits;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Long getMaxRevive() {
        return maxRevive;
    }
    public void setMaxRevive(Long maxRevive) {
        this.maxRevive = maxRevive;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public String getEndLoadingText() {
        return endLoadingText;
    }

    public void setEndLoadingText(String endLoadingText) {
        this.endLoadingText = endLoadingText;
    }

    public String getEndLoadingMp3() {
        return endLoadingMp3;
    }

    public void setEndLoadingMp3(String endLoadingMp3) {
        this.endLoadingMp3 = endLoadingMp3;
    }

    public Long getEndLoadingDuring() {
        return endLoadingDuring;
    }

    public void setEndLoadingDuring(Long endLoadingDuring) {
        this.endLoadingDuring = endLoadingDuring;
    }

    public String getNuanchangText() {
        return nuanchangText;
    }

    public void setNuanchangText(String nuanchangText) {
        this.nuanchangText = nuanchangText;
    }
}