package cn.com.duiba.millionaire.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by sty on 1/20/18.
 */
public enum AccountTypeEnum {
    WIN_INCOME(1, "中奖获得"),
    WITHDRAW_ONLINE(2, "线上提现"),
    WITHDRAW_OFFLINE(3, "线下提现");

    private static Map<Integer, AccountTypeEnum> typeEnumMap = Maps.newHashMap();

    static {
        for (AccountTypeEnum typeEnum : AccountTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     * 通过code获取签到类型
     *
     * @param code
     * @return
     */
    public static AccountTypeEnum getByCode(int code) {
        AccountTypeEnum type = typeEnumMap.get(code);
        if(type == null){
            return null;
        }
        return type;
    }

    private Integer code;
    private String desc;

    AccountTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
