package cn.com.duiba.millionaire.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.millionaire.center.api.dto.MillionaireActivityDto;
import cn.com.duiba.millionaire.center.api.dto.MillionaireQuestionBagDto;
import cn.com.duiba.millionaire.center.api.dto.MillionaireQuestionDto;
import cn.com.duiba.millionaire.center.api.requestParam.MillionaireQuestionBagRequestParam;

import java.util.List;

/**
 * Created by sty on 2018/1/18.
 * 冲顶大会  题库后台配置接口
 */
@AdvancedFeignClient
public interface RemoteMillionaireQuesionBagService {

    /**
     * countMillionaireQuesionBagBackendList:(这里用一句话描述这个方法的作用). <br/>
     * 查询题库总数据
     *
     * @param param
     * @return
     * @since JDK 1.8
     */
    Integer countMillionaireQuestionBagBackendList(MillionaireQuestionBagRequestParam param);

    /**
     * getMillionaireQuesionBagList:(这里用一句话描述这个方法的作用). <br/>
     * 查询题库总数据
     * pageNum  当前页码  pageSize大小
     *
     * @param param
     * @return
     * @since JDK 1.8
     */
    List<MillionaireQuestionBagDto> getMillionaireQuestionBagList(MillionaireQuestionBagRequestParam param);

    /**
     * saveOrUPdateMillionaireQuesionBag:(这里用一句话描述这个方法的作用). <br/>
     * 更新或者保存题库
     *
     * @param dto
     * @return
     * @since JDK 1.8
     */
    Boolean saveOrUpdateMillionaireQuestionBag(MillionaireQuestionBagDto dto);

    /**
     * findAllMillionaireQuesionByBagId:(这里用一句话描述这个方法的作用). <br/>
     * 查询题库 下所有题目信息
     *
     * @param id
     * @return
     * @since JDK 1.8
     */
    List<MillionaireQuestionDto> findAllMillionaireQuestionByBagId(Long id);

    /**
     * saveOrUPdateMillionaireQuesionBag:(这里用一句话描述这个方法的作用). <br/>
     * 更新或者保存 题目信息
     *
     * @param dto
     * @return
     * @since JDK 1.8
     */
    Boolean saveOrUpdateMillionaireQuestion(MillionaireQuestionDto dto);

    /**
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 1:题库 删除，2：题目删除
     *
     * @param id
     * @return
     * @since JDK 1.8
     */
    Boolean delete(Long id, Integer type);

    /**
     * findQuesionById:(这里用一句话描述这个方法的作用). <br/>
     * 题目信息查询
     *
     * @param id
     * @return
     * @since JDK 1.8
     */
    MillionaireQuestionDto findQuesiontById(Long id);

    /**
     * @param activityId
     * @param index
     * @return
     */
    MillionaireQuestionDto findQuestionByActivityIdAndIndex(Long activityId, Integer index);

}
