package cn.com.duiba.miria.common.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_alert_collect_rule")
public class AlertCollectRule {
    /**
     * id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 告警采集的应用id
     */
    @Column(name = "app_id")
    private Long appId;

    /**
     * 采集指标, 目前只有cpu和memory
     */
    private String metric;

    /**
     * 条件> = <
     */
    private String judgment;

    /**
     * 阈值，具体的数值
     */
    private String threshold;

    /**
     * 告警分组ID,目前只有默认分组
     */
    @Column(name = "alert_group_id")
    private Long alertGroupId;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 是否是默认配置，默认值是0，表示不是
     */
    @Column(name = "is_default")
    private Boolean isDefault;

    /**
     * 0 代表绝对值, 1代表百分比
     */
    @Column(name = "threshold_type")
    private Boolean thresholdType;

    /**
     * 获取id
     *
     * @return id - id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置id
     *
     * @param id id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取告警采集的应用id
     *
     * @return app_id - 告警采集的应用id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * 设置告警采集的应用id
     *
     * @param appId 告警采集的应用id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * 获取采集指标, 目前只有cpu和memory
     *
     * @return metric - 采集指标, 目前只有cpu和memory
     */
    public String getMetric() {
        return metric;
    }

    /**
     * 设置采集指标, 目前只有cpu和memory
     *
     * @param metric 采集指标, 目前只有cpu和memory
     */
    public void setMetric(String metric) {
        this.metric = metric == null ? null : metric.trim();
    }

    /**
     * 获取条件> = <
     *
     * @return judgment - 条件> = <
     */
    public String getJudgment() {
        return judgment;
    }

    /**
     * 设置条件> = <
     *
     * @param judgment 条件> = <
     */
    public void setJudgment(String judgment) {
        this.judgment = judgment == null ? null : judgment.trim();
    }

    /**
     * 获取阈值，具体的数值
     *
     * @return threshold - 阈值，具体的数值
     */
    public String getThreshold() {
        return threshold;
    }

    /**
     * 设置阈值，具体的数值
     *
     * @param threshold 阈值，具体的数值
     */
    public void setThreshold(String threshold) {
        this.threshold = threshold == null ? null : threshold.trim();
    }

    /**
     * 获取告警分组ID,目前只有默认分组
     *
     * @return alert_group_id - 告警分组ID,目前只有默认分组
     */
    public Long getAlertGroupId() {
        return alertGroupId;
    }

    /**
     * 设置告警分组ID,目前只有默认分组
     *
     * @param alertGroupId 告警分组ID,目前只有默认分组
     */
    public void setAlertGroupId(Long alertGroupId) {
        this.alertGroupId = alertGroupId;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * 获取是否是默认配置，默认值是0，表示不是
     *
     * @return is_default - 是否是默认配置，默认值是0，表示不是
     */
    public Boolean getIsDefault() {
        return isDefault;
    }

    /**
     * 设置是否是默认配置，默认值是0，表示不是
     *
     * @param isDefault 是否是默认配置，默认值是0，表示不是
     */
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    /**
     * 获取0 代表绝对值, 1代表百分比
     *
     * @return threshold_type - 0 代表绝对值, 1代表百分比
     */
    public Boolean getThresholdType() {
        return thresholdType;
    }

    /**
     * 设置0 代表绝对值, 1代表百分比
     *
     * @param thresholdType 0 代表绝对值, 1代表百分比
     */
    public void setThresholdType(Boolean thresholdType) {
        this.thresholdType = thresholdType;
    }
}