package cn.com.duiba.miria.common.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_project_dingtalk")
public class ProjectDingtalk {
    /**
     * 自增id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 消息类型 0:监控 1:日志
     */
    @Column(name = "alarm_type")
    private Integer alarmType;

    /**
     * 管理叮叮机器人主键id,来源：dingtalk.id
     */
    @Column(name = "dingtalk_id")
    private Long dingtalkId;

    /**
     * 应用id
     */
    @Column(name = "app_id")
    private Long appId;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取自增id
     *
     * @return id - 自增id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置自增id
     *
     * @param id 自增id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取消息类型 0:监控 1:日志
     *
     * @return alarm_type - 消息类型 0:监控 1:日志
     */
    public Integer getAlarmType() {
        return alarmType;
    }

    /**
     * 设置消息类型 0:监控 1:日志
     *
     * @param alarmType 消息类型 0:监控 1:日志
     */
    public void setAlarmType(Integer alarmType) {
        this.alarmType = alarmType;
    }

    /**
     * 获取管理叮叮机器人主键id,来源：dingtalk.id
     *
     * @return dingtalk_id - 管理叮叮机器人主键id,来源：dingtalk.id
     */
    public Long getDingtalkId() {
        return dingtalkId;
    }

    /**
     * 设置管理叮叮机器人主键id,来源：dingtalk.id
     *
     * @param dingtalkId 管理叮叮机器人主键id,来源：dingtalk.id
     */
    public void setDingtalkId(Long dingtalkId) {
        this.dingtalkId = dingtalkId;
    }

    /**
     * 获取应用id
     *
     * @return app_id - 应用id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * 设置应用id
     *
     * @param appId 应用id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}