package cn.com.duiba.miria.common.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_publish_audit")
public class PublishAudit {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private Long publisher;

    private Long auditor;

    private Integer state;

    @Column(name = "audit_time")
    private Date auditTime;

    @Column(name = "gmt_create")
    private Date gmtCreate;

    @Column(name = "gmt_modified")
    private Date gmtModified;

    @Column(name = "audit_comment")
    private String auditComment;

    @Column(name = "publish_id")
    private Long publishId;

    @Column(name = "deploy_id")
    private Long deployId;

    @Column(name = "app_name")
    private String appName;

    /**
     * git提交id
     */
    @Column(name = "commit_id")
    private String commitId;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return publisher
     */
    public Long getPublisher() {
        return publisher;
    }

    /**
     * @param publisher
     */
    public void setPublisher(Long publisher) {
        this.publisher = publisher;
    }

    /**
     * @return auditor
     */
    public Long getAuditor() {
        return auditor;
    }

    /**
     * @param auditor
     */
    public void setAuditor(Long auditor) {
        this.auditor = auditor;
    }

    /**
     * @return state
     */
    public Integer getState() {
        return state;
    }

    /**
     * @param state
     */
    public void setState(Integer state) {
        this.state = state;
    }

    /**
     * @return audit_time
     */
    public Date getAuditTime() {
        return auditTime;
    }

    /**
     * @param auditTime
     */
    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    /**
     * @return gmt_create
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * @param gmtCreate
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * @return gmt_modified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * @param gmtModified
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * @return audit_comment
     */
    public String getAuditComment() {
        return auditComment;
    }

    /**
     * @param auditComment
     */
    public void setAuditComment(String auditComment) {
        this.auditComment = auditComment == null ? null : auditComment.trim();
    }

    /**
     * @return publish_id
     */
    public Long getPublishId() {
        return publishId;
    }

    /**
     * @param publishId
     */
    public void setPublishId(Long publishId) {
        this.publishId = publishId;
    }

    /**
     * @return deploy_id
     */
    public Long getDeployId() {
        return deployId;
    }

    /**
     * @param deployId
     */
    public void setDeployId(Long deployId) {
        this.deployId = deployId;
    }

    /**
     * @return app_name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * @param appName
     */
    public void setAppName(String appName) {
        this.appName = appName == null ? null : appName.trim();
    }

    /**
     * 获取git提交id
     *
     * @return commit_id - git提交id
     */
    public String getCommitId() {
        return commitId;
    }

    /**
     * 设置git提交id
     *
     * @param commitId git提交id
     */
    public void setCommitId(String commitId) {
        this.commitId = commitId == null ? null : commitId.trim();
    }
}