package cn.com.duiba.miria.common.api.entity;

import java.util.Date;
import javax.persistence.*;

public class Zone {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 可用区的名称
     */
    private String name;

    private String description;

    /**
     * 可用区存在的云环境
     */
    @Column(name = "cloud_id")
    private Long cloudId;

    @Column(name = "created_time")
    private Date createdTime;

    @Column(name = "modified_time")
    private Date modifiedTime;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取可用区的名称
     *
     * @return name - 可用区的名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置可用区的名称
     *
     * @param name 可用区的名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * @return description
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    /**
     * 获取可用区存在的云环境
     *
     * @return cloud_id - 可用区存在的云环境
     */
    public Long getCloudId() {
        return cloudId;
    }

    /**
     * 设置可用区存在的云环境
     *
     * @param cloudId 可用区存在的云环境
     */
    public void setCloudId(Long cloudId) {
        this.cloudId = cloudId;
    }

    /**
     * @return created_time
     */
    public Date getCreatedTime() {
        return createdTime;
    }

    /**
     * @param createdTime
     */
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * @return modified_time
     */
    public Date getModifiedTime() {
        return modifiedTime;
    }

    /**
     * @param modifiedTime
     */
    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }
}