/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2018/6/27.
 **/
package cn.com.duiba.miria.common.api.enums;

import com.google.common.collect.Maps;

import lombok.Getter;

import java.util.Map;

@Getter
public enum Environment {
    TEST(1L,"测试环境", "test", "test"),
    PRE(2L,"预发环境", "pre", "pre"),
    PRD(3L,"生产环境", "prd", "prod");

    private static Map<Long,Environment> MAP = Maps.newHashMap();
    static {
        for (Environment environment:Environment.values()){
            MAP.put(environment.getCode(),environment);
        }
    }

    private Long code;
    private String name;
    private String label;
    private String namespace;

    Environment(Long code, String name, String label, String namespace) {
        this.code = code;
        this.name = name;
        this.label = label;
        this.namespace = namespace;
    }

    public static Environment findByCode(Long code){
        if(!MAP.containsKey(code)){
            throw new RuntimeException("无效的环境Code");
        }
        return MAP.get(code);
    }
}
