package cn.com.duiba.miria.common.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import cn.com.duiba.miria.common.api.data.DeployInfo;
import io.fabric8.kubernetes.api.model.extensions.Deployment;

/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2018/6/27.
 **/
@AdvancedFeignClient
public interface DeployK8sService {

    public DeployInfo checkFromK8s(Long clusterId, Long deployId);

    public void publishToK8s(Long k8sId, Deployment deployment);

    public void destroyFromK8s(Long deployId);

    public String getDeploymentName(Long deployId);
}
