/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.miria.common.api.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum PodStatusEnum {
    RUNNING("Running", "\u8fd0\u884c\u4e2d"),
    PENDING("Pending", "\u8c03\u5ea6\u4e2d"),
    SUCCESSED("Succeeded", "\u6b63\u5e38\u9000\u51fa"),
    FAILED("Failed", "\u5f02\u5e38\u9000\u51fa"),
    UNKNOWN("Unknown", "\u672a\u77e5");

    private static Map<String, PodStatusEnum> STATE_MAP;
    private String code;
    private String name;

    private PodStatusEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static PodStatusEnum findByCode(String code) {
        return STATE_MAP.getOrDefault(code, UNKNOWN);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    static {
        STATE_MAP = Maps.newHashMap();
        for (PodStatusEnum status : PodStatusEnum.values()) {
            STATE_MAP.put(status.getCode(), status);
        }
    }
}

