/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2017/12/15.
 **/
package cn.com.duiba.miria.common.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.data.AppListPageParams;
import cn.com.duiba.miria.common.api.entity.App;
import cn.com.duiba.miria.common.api.entity.AppInfo;
import cn.com.duiba.miria.common.api.vo.PaginationVO;
import org.apache.ibatis.annotations.Param;


import java.util.List;
import java.util.Map;
import java.util.Set;

@AdvancedFeignClient
public interface AppService {

    /**
     * 获取App分页列表
     *
     * @param params
     * @return
     */
    PaginationVO<App> findApplicationPage(AppListPageParams params);

    Map<Long, App> appMap(Set<Long> ids);

    List<App> findByIds(Set<Long> ids);

    /**
     * 根据ming
     *
     * @param name
     * @return
     */
    App findByName(String name);


    Integer createApp(App app) throws BizException;

    Integer updateApp(App app) throws BizException;

    App getAppById(Long AppId);

    List<App> findAllApps();

    List<App> findAppByAppName(String appName);

    List<App> queryAppByGroupId(Long groupId);

    App findByDeployId(Long deployId);

    List<AppInfo> findAppNamesByEnvId(@Param("envId") long envId);

}
