package cn.com.duiba.miria.common.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.data.GroupUser;
import cn.com.duiba.miria.common.api.entity.GroupEntity;
import cn.com.duiba.miria.common.api.vo.UserGroupAppPowerVO;
import cn.com.duiba.miria.common.api.vo.UserVO;


import java.util.List;
import java.util.Map;


@AdvancedFeignClient
public interface PowerMgrService {

    void addGroup(String name);

    /**
     * 查询所有的业务线，业务线的负责人和业务线下app数量
     */
    List<GroupUser> queryGroupLeader();

    void deleteGroupById(String id);

    /**
     * 查询当前业务线下所有app，并且当前业务线负责人对应app的权限和对应app的owner
     */
    List<UserGroupAppPowerVO> loadUserGroupApp(Long adminId, Long groupId);

    List<GroupEntity> loadGroup();

    List<Map> loadRole();

    /**
     * 根据当前登陆id分权限查出其可分配的app（1.管理员分配所有的app 2.业务线负责人分配其业务线加有权限的app）
     */
    List<UserGroupAppPowerVO> loadAppListByAdminId(Long adminId);

    List<UserVO> loadOwnerList(Long appId);

    /**
     * 从sso模糊查询出用户，然后匹配本地用户库，查出关联业务线和角色
     */
    List<UserVO> searchByName(String userName);

    void addOwner(Long appId, List<UserVO> userVOs);

    void updateOwner(Long appId, List<UserVO> userVOs);

    void deleteOwner(Long adminId, Long appId);
}
