package cn.com.duiba.miria.monitor.api.entity;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

@Getter
@Setter
@Builder
public class AlarmConfig implements Serializable {

    private int checkIsMeetPeriod;

    private int alertThresholdValue;

    private int silentTime; // 告警沉默时间，单位60分钟

    private List<String> alarmPushTypeList; // 推送方式

    public AlarmConfig(int checkIsMeetPeriod, int alertThresholdValue, int silentTime, List<String> alarmPushTypeEnumList) {
        this.checkIsMeetPeriod = checkIsMeetPeriod;
        this.alertThresholdValue = alertThresholdValue;
        this.silentTime = silentTime;
        this.alarmPushTypeList = alarmPushTypeEnumList;
    }

    public AlarmConfig() {

    }
}
