package cn.com.duiba.miria.monitor.api.entity;

import javax.persistence.*;
import java.util.Date;

@Table(name = "tb_metric")
public class Metric {
    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 类别，cpu、memory等
     */
    private String type;

    /**
     * 表达式
     */
    private String metric;

    /**
     * 表达式涵义，是增长率还是绝对值，或是其他类型，0代表增长率，1代表绝对值
     */
    @Column(name = "metric_meaning")
    private Byte metricMeaning;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取主键id
     *
     * @return id - 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键id
     *
     * @param id 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取名称
     *
     * @return name - 名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置名称
     *
     * @param name 名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取类别，cpu、memory等
     *
     * @return type - 类别，cpu、memory等
     */
    public String getType() {
        return type;
    }

    /**
     * 设置类别，cpu、memory等
     *
     * @param type 类别，cpu、memory等
     */
    public void setType(String type) {
        this.type = type == null ? null : type.trim();
    }

    /**
     * 获取表达式
     *
     * @return metric - 表达式
     */
    public String getMetric() {
        return metric;
    }

    /**
     * 设置表达式
     *
     * @param metric 表达式
     */
    public void setMetric(String metric) {
        this.metric = metric == null ? null : metric.trim();
    }

    /**
     * 获取表达式涵义，是增长率还是绝对值，或是其他类型，0代表增长率，1代表绝对值
     *
     * @return metric_meaning - 表达式涵义，是增长率还是绝对值，或是其他类型，0代表增长率，1代表绝对值
     */
    public Byte getMetricMeaning() {
        return metricMeaning;
    }

    /**
     * 设置表达式涵义，是增长率还是绝对值，或是其他类型，0代表增长率，1代表绝对值
     *
     * @param metricMeaning 表达式涵义，是增长率还是绝对值，或是其他类型，0代表增长率，1代表绝对值
     */
    public void setMetricMeaning(Byte metricMeaning) {
        this.metricMeaning = metricMeaning;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}