package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.param.AlertCollectParam;
import cn.com.duiba.miria.monitor.api.param.MonitorAlarmRuleParam;
import cn.com.duiba.miria.monitor.api.vo.AlarmPushTypeVO;
import cn.com.duiba.miria.monitor.api.vo.AlertCollectRuleVO;
import cn.com.duiba.miria.monitor.api.vo.PageVO;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface MonitorAlarmService {

    /**
     * 新增监控报警规则
     *
     * @param monitorAlarmRuleParam 监控报警规则参数
     */
    void addRule(MonitorAlarmRuleParam monitorAlarmRuleParam);

    /**
     * 更新监控报警规则
     * @param monitorAlarmRuleParam 监控报警规则参数
     */
    void updateCollect(MonitorAlarmRuleParam monitorAlarmRuleParam);

    /**
     * 根据id删除监控报警规则
     * @param id 监控报警规则的id
     */
    void deleteCollect(Long id);

    /**
     * 根据查询条件查询默认的监控报警规则列表
     * @param alertCollectParam 查询监控报警规则的参数
     * @return
     */
    List<AlertCollectRuleVO> listDefaultAlertCollectRules(AlertCollectParam alertCollectParam);

    /**
     * 根据查询条件查询监控报警规则列表
     * @param alertCollectParam 查询监控报警规则的参数
     * @return
     */
    PageVO listAlertCollectRules(AlertCollectParam alertCollectParam);

    /**
     * 查询告警方式
     * @return 告警方式（钉钉、手机等）
     */
    List<AlarmPushTypeVO> getAlertTypes();

}
