package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface ExpireTimeService {

    /**
     * 根据应用名更新Prometheus报警的沉默时长
     *
     * @param appName 应用名
     */
    void updatePrometheusExpireTimeStamp(String appName);

    /**
     * 根据应用名和时间间隔更新阿里云日志报警的沉默时长
     * @param appName 应用名
     * @param timeGap 时间间隔
     */
    void updateALiYunExpireTimeStamp(String appName, Long timeGap);

}
