package cn.com.duiba.miria.monitor.api.entity;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

@Table(name = "tb_metric_graph")
public class MetricGraphRelation {
    /**
     * 主键id
     */
    @Id
    private Long id;

    /**
     * 指标id主键,来源：tb_metric.id
     */
    @Column(name = "metric_id")
    private Long metricId;

    /**
     * 窗口id主键,graph_id.id
     */
    @Column(name = "graph_id")
    private Long graphId;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取主键id
     *
     * @return id - 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键id
     *
     * @param id 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取指标id主键,来源：tb_metric.id
     *
     * @return metric_id - 指标id主键,来源：tb_metric.id
     */
    public Long getMetricId() {
        return metricId;
    }

    /**
     * 设置指标id主键,来源：tb_metric.id
     *
     * @param metricId 指标id主键,来源：tb_metric.id
     */
    public void setMetricId(Long metricId) {
        this.metricId = metricId;
    }

    /**
     * 获取窗口id主键,graph_id.id
     *
     * @return graph_id - 窗口id主键,graph_id.id
     */
    public Long getGraphId() {
        return graphId;
    }

    /**
     * 设置窗口id主键,graph_id.id
     *
     * @param graphId 窗口id主键,graph_id.id
     */
    public void setGraphId(Long graphId) {
        this.graphId = graphId;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}