package cn.com.duiba.miria.monitor.api.entity;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

@Table(name = "tb_trigger")
public class Trigger {
    /**
     * 主键id
     */
    @Id
    private Long id;

    /**
     * 触发器名称
     */
    @Column(name = "trigger_name")
    private String triggerName;

    /**
     * 指标id,来源tb_metric.id
     */
    @Column(name = "metric_id")
    private Long metricId;

    /**
     * 比较条件，>或者<
     */
    private String compare;

    /**
     * 阈值
     */
    private String threshold;

    /**
     * 0代表绝对值, 1代表百分比
     */
    @Column(name = "threshold_type")
    private Byte thresholdType;

    /**
     * 报警描述文字
     */
    private String note;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取主键id
     *
     * @return id - 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键id
     *
     * @param id 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取触发器名称
     *
     * @return trigger_name - 触发器名称
     */
    public String getTriggerName() {
        return triggerName;
    }

    /**
     * 设置触发器名称
     *
     * @param triggerName 触发器名称
     */
    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName == null ? null : triggerName.trim();
    }

    /**
     * 获取指标id,来源tb_metric.id
     *
     * @return metric_id - 指标id,来源tb_metric.id
     */
    public Long getMetricId() {
        return metricId;
    }

    /**
     * 设置指标id,来源tb_metric.id
     *
     * @param metricId 指标id,来源tb_metric.id
     */
    public void setMetricId(Long metricId) {
        this.metricId = metricId;
    }

    /**
     * 获取比较条件，>或者<
     *
     * @return compare - 比较条件，>或者<
     */
    public String getCompare() {
        return compare;
    }

    /**
     * 设置比较条件，>或者<
     *
     * @param compare 比较条件，>或者<
     */
    public void setCompare(String compare) {
        this.compare = compare == null ? null : compare.trim();
    }

    /**
     * 获取阈值
     *
     * @return threshold - 阈值
     */
    public String getThreshold() {
        return threshold;
    }

    /**
     * 设置阈值
     *
     * @param threshold 阈值
     */
    public void setThreshold(String threshold) {
        this.threshold = threshold == null ? null : threshold.trim();
    }

    /**
     * 获取0代表绝对值, 1代表百分比
     *
     * @return threshold_type - 0代表绝对值, 1代表百分比
     */
    public Byte getThresholdType() {
        return thresholdType;
    }

    /**
     * 设置0代表绝对值, 1代表百分比
     *
     * @param thresholdType 0代表绝对值, 1代表百分比
     */
    public void setThresholdType(Byte thresholdType) {
        this.thresholdType = thresholdType;
    }

    /**
     * 获取报警描述文字
     *
     * @return note - 报警描述文字
     */
    public String getNote() {
        return note;
    }

    /**
     * 设置报警描述文字
     *
     * @param note 报警描述文字
     */
    public void setNote(String note) {
        this.note = note == null ? null : note.trim();
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}