package cn.com.duiba.miria.monitor.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author wrj
 */

@Getter
public enum AlarmTypeEnum {
    /*
     * MONITOR 监控报警
     * LOG 日志报警
     * */
    MONITOR(1, "monitor", "监控报警"),
    LOG(2, "log", "日志报警");

    private Integer code;
    private String type;
    private String typeName;

    AlarmTypeEnum(Integer code, String type, String typeName) {
        this.code = code;
        this.type = type;
        this.typeName = typeName;
    }

    private static final Map<Integer, String> MAP = new HashMap<>();

    static {
        for (AlarmTypeEnum alarmTypeEnum : AlarmTypeEnum.values()) {
            MAP.put(alarmTypeEnum.getCode(), alarmTypeEnum.getTypeName());
        }
    }

    public static String findNameById(int code) {
        return MAP.get(code);
    }

}
