package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.entity.prometheus.MonitorChart;
import cn.com.duiba.miria.monitor.api.entity.prometheus.QueryResult;
import cn.com.duiba.miria.monitor.api.param.MonitorChartParam;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface MonitorChartService {

    /**
     * 根据查询条件返回图表数据
     *
     * @param monitorChartParam 查询参数
     * @return
     * @throws BizException 自定义异常
     */
    QueryResult queryRange(MonitorChartParam monitorChartParam) throws BizException;

    /**
     * 查询所有查询模板
     * @return 监控图表查询模板
     */
    List<MonitorChart> loadChartMetadata();

    String getHostName();

}
