package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.param.ProjectDingTalkParam;
import cn.com.duiba.miria.monitor.api.vo.AlarmTypeVO;
import cn.com.duiba.miria.monitor.api.vo.PageVO;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface ProjectDingTalkService {

    /**
     * 查询关系
     *
     * @param projectDingTalkParam 项目钉钉机器人关系参数
     * @return 查询到的关系列表
     */
    PageVO listProjectRobot(ProjectDingTalkParam projectDingTalkParam);

    /**
     * 新增关系
     * @param projectDingTalkParam 项目钉钉机器人关系参数
     * @throws BizException 自定义异常
     */
    void addProjectDingTalk(ProjectDingTalkParam projectDingTalkParam) throws BizException;

    /**
     * 根据di更新关系
     * @param projectDingTalkParam 项目钉钉机器人关系参数
     */
    void updateProjectDingTalk(ProjectDingTalkParam projectDingTalkParam);

    /**
     * 根据id删除关系
     * @param id id
     */
    void deleteProjectDingTalk(Long id);

    /**
     * 查询报警类别
     * @return 报警类别（监控报警还是日志报警）
     */
    List<AlarmTypeVO> getAlarmTypes();

}
