package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.param.TriggerParam;
import cn.com.duiba.miria.monitor.api.vo.TriggerVO;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface TriggerService {

    /**
     * 查询所有报警规则
     * @return 所有报警规则
     */
    List<TriggerVO> listAll();

    /**
     * 新增报警规则
     * @param triggerParam 规则参数
     * @throws BizException 业务异常
     */
    void insert(TriggerParam triggerParam) throws BizException;

    /**
     * 更新报警规则
     * @param triggerParam 规则参数
     */
    void update(TriggerParam triggerParam) ;

    /**
     * 删除报警规则
     * @param id 根据id删除报警规则
     */
    void delete(Long id);

}
