package cn.com.duiba.miria.monitor.api.util;

import cn.com.duiba.miria.monitor.api.entity.PrometheusAlarm;
import cn.com.duiba.miria.monitor.api.entity.PrometheusAlertResult;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Map;

/**
 * @author wrj
 */
public class PrometheusAlertUtil {

    public static List<PrometheusAlarm> parse(JSONArray jsonArray) {
        List<PrometheusAlarm> list = Lists.newArrayList();
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONObject label = jsonObject.getJSONObject("labels");

            PrometheusAlarm prometheusAlarm = new PrometheusAlarm();
            prometheusAlarm.setAlertName(label.getString("alertname"));
            prometheusAlarm.setMetricName(label.getString("metricName"));
            prometheusAlarm.setPodName(label.getString("pod_name"));
            prometheusAlarm.setAppName(label.getString("appName"));
            prometheusAlarm.setTriggerNote(label.getString("triggerNote"));
            prometheusAlarm.setValue(jsonObject.getString("value"));
            prometheusAlarm.setDateStr(jsonObject.getString("startsAt"));

            list.add(prometheusAlarm);
        }
        return list;
    }

    public static PrometheusAlarm parse(PrometheusAlertResult prometheusAlert) {
        PrometheusAlarm prometheusAlarm = new PrometheusAlarm();
        Map<String, String> labels = prometheusAlert.getLabels();
        prometheusAlarm.setAlertName(labels.get("alertname"));
        prometheusAlarm.setMetricName(labels.get("metricName"));
        prometheusAlarm.setMetricType(labels.get("metricType"));
        prometheusAlarm.setPodName(labels.get("pod_name"));
        prometheusAlarm.setAppName(labels.get("appName"));
        prometheusAlarm.setTriggerNote(labels.get("triggerNote"));
        prometheusAlarm.setValue(prometheusAlert.getValue());
        prometheusAlarm.setDateStr(prometheusAlert.getStartsAt());

        return prometheusAlarm;
    }

}
