/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.cost;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.BackendAdvertStatDo;
import cn.com.duiba.nezha.alg.alg.vo.StatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.HashMap;
import java.util.Map;

public class BackendCostOptimizer {
    public static Map<String, Double> backendTypePriorityMap = new HashMap<String, Double>();

    public static Map<Long, BackendAdvertStatDo> getBackendAdvertStatInfo(Map<Long, StatDo> appAdvertStatMap, Map<Long, StatDo> globalAdvertStatMap) {
        HashMap<Long, BackendAdvertStatDo> ret = new HashMap<Long, BackendAdvertStatDo>();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{globalAdvertStatMap})) {
            if (appAdvertStatMap == null) {
                appAdvertStatMap = new HashMap<Long, StatDo>();
            }
            for (Map.Entry<Long, StatDo> entry : globalAdvertStatMap.entrySet()) {
                Long advertId = entry.getKey();
                StatDo globalStatDo = entry.getValue();
                StatDo appStatDo = appAdvertStatMap.get(advertId);
                String type = BackendCostOptimizer.getTaskBackendType(globalStatDo);
                if (type == null) continue;
                BackendAdvertStatDo backendAdvertStatDo = new BackendAdvertStatDo();
                backendAdvertStatDo.setAdvertId(advertId);
                backendAdvertStatDo.setBackendType(type);
                backendAdvertStatDo.setAvgBackendCvr(BackendCostOptimizer.getTaskBackendCvr(globalStatDo, type));
                Double currentBCvr = BackendCostOptimizer.getTaskBackendCvr(appStatDo, type);
                if (currentBCvr == null) {
                    currentBCvr = BackendCostOptimizer.getTaskBackendCvr(globalStatDo, type);
                }
                backendAdvertStatDo.setCBackendCvr(currentBCvr);
                ret.put(advertId, backendAdvertStatDo);
            }
        }
        return ret;
    }

    public static Map<Long, Double> getBackendAdvertInfo(Map<Long, Double> advertPreInfo, Map<Long, BackendAdvertStatDo> advertStatInfo, Map<Long, Double> advertBudgetInfo) {
        HashMap<Long, Double> ret = new HashMap<Long, Double>();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{advertPreInfo, advertStatInfo})) {
            for (Map.Entry<Long, BackendAdvertStatDo> entry : advertStatInfo.entrySet()) {
                Double mergeCvr;
                Double optFactor;
                Long advertId = entry.getKey();
                BackendAdvertStatDo backendAdvertStatDo = entry.getValue();
                Double preBackendCvr = advertPreInfo.get(advertId);
                if (backendAdvertStatDo == null || preBackendCvr == null || (optFactor = BackendCostOptimizer.getBackendOptFactor(mergeCvr = BackendCostOptimizer.getMergeBackendCvr(backendAdvertStatDo.getCBackendCvr(), preBackendCvr), backendAdvertStatDo.getAvgBackendCvr())) == null) continue;
                ret.put(advertId, optFactor);
            }
        }
        return ret;
    }

    public static Double getBackendOptFactor(Double mergeCvr, Double avgCvr) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{mergeCvr, avgCvr})) {
            Double absoluteFactor = 1.0;
            Double relativeFactor = 1.0;
            Double ratio = (mergeCvr + 0.001) / (avgCvr + 0.001);
            if (mergeCvr <= 0.05 && ratio <= 0.5) {
                absoluteFactor = MathBase.sigmoidWithZoomAndIntervalMap(mergeCvr / 0.05 - 0.5, 0.9, 1.0, 8.0);
            } else if (mergeCvr > 0.5) {
                absoluteFactor = 1.05;
            }
            if (ratio <= 1.0) {
                Double relativeFactor1 = MathBase.sigmoidWithZoomAndIntervalMap(ratio - 0.3, 0.4, 1.0, 8.0);
                Double relativeFactor2 = MathBase.sigmoidWithZoomAndIntervalMap(ratio - 0.5, 0.4, 1.01, 8.0);
                relativeFactor = mergeCvr <= 0.1 ? relativeFactor1 : (mergeCvr < 0.2 ? Double.valueOf(((0.2 - mergeCvr) * relativeFactor1 + (mergeCvr - 0.1) * relativeFactor2) / 0.1) : relativeFactor2);
            } else if (ratio > 1.5) {
                relativeFactor = 1.05;
            }
            ret = absoluteFactor * relativeFactor;
        }
        return ret;
    }

    public static Double getMergeBackendCvr(Double statCvr, Double preCvr) {
        Double ret = null;
        if (statCvr != null && preCvr != null) {
            ret = 0.4 * statCvr + 0.6 * preCvr;
        }
        return ret;
    }

    public static Double getTaskBackendCvr(StatDo statDo, String backendType) {
        Double ret = null;
        if (statDo != null && backendType != null) {
            Long cnt;
            Long actClickCnt = statDo.getActClickCnt();
            Map<String, Long> backendCntMap = statDo.getBackendCntMap();
            if (actClickCnt != null && actClickCnt >= 30L && AssertUtil.isNotEmpty(backendCntMap) && (cnt = backendCntMap.get(backendType)) != null) {
                ret = DataUtil.division((Long)cnt, (Long)actClickCnt, (int)4);
            }
        }
        return ret;
    }

    public static String getTaskBackendType(StatDo statDo) {
        String ret = null;
        if (statDo != null) {
            Long actClickCnt = statDo.getActClickCnt();
            Map<String, Long> backendCntMap = statDo.getBackendCntMap();
            if (actClickCnt != null && actClickCnt >= 50L && AssertUtil.isNotEmpty(backendCntMap)) {
                HashMap<String, Double> filterMap = new HashMap<String, Double>();
                for (Map.Entry<String, Long> entry : backendCntMap.entrySet()) {
                    String type = entry.getKey();
                    Long cnt = entry.getValue();
                    Double weight = backendTypePriorityMap.get(type);
                    if (cnt == null || cnt < 10L || weight == null) continue;
                    filterMap.put(type, (double)cnt.longValue() * weight);
                }
                ret = BackendCostOptimizer.getValueTopOneFromMap(filterMap);
            }
        }
        return ret;
    }

    public static String getValueTopOneFromMap(Map<String, Double> map) {
        String ret = null;
        if (AssertUtil.isNotEmpty(map)) {
            Double maxValue = 1.0;
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                Double val = entry.getValue();
                if (val == null || !(val > maxValue)) continue;
                maxValue = val;
                ret = entry.getKey();
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        StatDo statDo = new StatDo();
        statDo.setAdvertId(1L);
        statDo.setActClickCnt(40L);
        HashMap<String, Long> bcMap = new HashMap<String, Long>();
        bcMap.put("1", 6L);
        bcMap.put("3", 4L);
        statDo.setBackendCntMap(bcMap);
        HashMap<Long, StatDo> appAdvertStatMap = new HashMap<Long, StatDo>();
        appAdvertStatMap.put(1L, statDo);
        StatDo statDo2 = new StatDo();
        statDo2.setAdvertId(1L);
        statDo2.setActClickCnt(300L);
        HashMap<String, Long> bcMap2 = new HashMap<String, Long>();
        bcMap2.put("2", 40L);
        bcMap2.put("1", 50L);
        statDo2.setBackendCntMap(bcMap2);
        HashMap<Long, StatDo> globalAdvertStatMap = new HashMap<Long, StatDo>();
        globalAdvertStatMap.put(1L, statDo2);
        Map<Long, BackendAdvertStatDo> ret1 = BackendCostOptimizer.getBackendAdvertStatInfo(appAdvertStatMap, globalAdvertStatMap);
        HashMap<Long, Double> advertPreInfo = new HashMap<Long, Double>();
        advertPreInfo.put(1L, 0.1);
        Map<Long, Double> ret2 = BackendCostOptimizer.getBackendAdvertInfo(advertPreInfo, ret1, null);
    }

    static {
        backendTypePriorityMap.put("1", 1.0);
        backendTypePriorityMap.put("2", 1.0);
        backendTypePriorityMap.put("3", 1.0);
        backendTypePriorityMap.put("4", 1.0);
        backendTypePriorityMap.put("5", 0.9);
        backendTypePriorityMap.put("6", 0.7);
        backendTypePriorityMap.put("7", 0.5);
        backendTypePriorityMap.put("8", 0.3);
    }
}

