/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.budget;

import cn.com.duiba.nezha.alg.alg.alg.BudgetSmoothAlg;
import cn.com.duiba.nezha.alg.alg.vo.BudgetDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SmoothResultDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import java.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudgetSmoothNew {
    private static final Logger logger = LoggerFactory.getLogger(BudgetSmoothNew.class);
    public static double[] reqDist = new double[]{110.0, 60.0, 40.0, 30.0, 40.0, 70.0, 140.0, 165.0, 175.0, 155.0, 170.0, 185.0, 205.0, 175.0, 155.0, 150.0, 165.0, 190.0, 200.0, 230.0, 230.0, 200.0, 155.0, 100.0};
    public static Double retDistWeightSum = null;
    public static long DELAY_VALID_SECOND = 600L;

    public static BudgetSmoothDo getRatio(BudgetDo budgetDo, BudgetSmoothDo lastBudgetSmoothDo) {
        BudgetSmoothDo ret = new BudgetSmoothDo();
        if (budgetDo != null && !BudgetSmoothNew.isValid(budgetDo).booleanValue()) {
            logger.warn("BudgetSmoothNew.getRatio(BudgetDo budgetDo, BudgetSmoothDo lastBudgetSmoothDo)  input invalid ,budgetDo=" + JSON.toJSONString((Object)budgetDo));
            budgetDo = null;
        }
        BudgetDo lastBudgetDo = null;
        if (lastBudgetSmoothDo != null) {
            lastBudgetDo = BudgetSmoothNew.getLastBudgetDo(budgetDo, lastBudgetSmoothDo.getBudgetDo());
        }
        try {
            ret = BudgetSmoothNew.getBudgetSmooth(budgetDo, lastBudgetDo);
        }
        catch (Exception e) {
            logger.warn("BudgetSmoothNew.getRatio  getBudgetSmooth happend error,lastBudgetSmoothDo={}", (Object)JSON.toJSONString((Object)lastBudgetSmoothDo), (Object)e);
        }
        if (lastBudgetSmoothDo != null) {
            ret.setSmoothFactor(lastBudgetSmoothDo.getSmoothFactor());
            ret.setTimes(lastBudgetSmoothDo.getTimes());
        }
        BudgetSmoothNew.updateSmoothFactor(ret);
        return ret;
    }

    public static BudgetDo getLastBudgetDo(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        BudgetDo ret = null;
        if (BudgetSmoothNew.lastResultValid(budgetDo, lastBudgetDo).booleanValue()) {
            ret = lastBudgetDo;
        }
        return ret;
    }

    public static Boolean lastResultValid(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        Boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{budgetDo, lastBudgetDo})) {
            return false;
        }
        if (!BudgetSmoothNew.isValid(lastBudgetDo).booleanValue()) {
            return false;
        }
        if (!budgetDo.getTimeType().equals(lastBudgetDo.getTimeType())) {
            return false;
        }
        if (!budgetDo.getBudgetType().equals(lastBudgetDo.getBudgetType())) {
            return false;
        }
        if (!budgetDo.getBudget().equals(lastBudgetDo.getBudget())) {
            return false;
        }
        if (!budgetDo.getTimeType().equals(3L)) {
            if (!budgetDo.getStartTime().equals(lastBudgetDo.getStartTime())) {
                return false;
            }
            if (!budgetDo.getEndTime().equals(lastBudgetDo.getEndTime())) {
                return false;
            }
        }
        return ret;
    }

    public static Boolean isValid(BudgetDo advertDo) {
        Boolean ret = true;
        if (advertDo == null || AssertUtil.isAnyEmpty((Object[])new Object[]{advertDo.getBudgetType(), advertDo.getBudget(), advertDo.getTimeType()})) {
            return false;
        }
        if (advertDo.getBudget() == null || advertDo.getBudget() < 2000L) {
            return false;
        }
        if (advertDo.getBudgetType().equals(4L) || advertDo.getBudgetType().equals(5L)) {
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertDo.getStartTime(), advertDo.getEndTime()})) {
                return false;
            }
            if (advertDo.getTimeType().equals(3L)) {
                return false;
            }
        }
        if (advertDo.getTimeType().equals(1L) || advertDo.getTimeType().equals(2L)) {
            LocalTime updateTimeLocal;
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertDo.getStartTime(), advertDo.getEndTime()})) {
                return false;
            }
            if (advertDo.getEndTime().equals("24:00") || advertDo.getEndTime().equals("24:00:00")) {
                advertDo.setEndTime("23:59:59");
            }
            if ((updateTimeLocal = BudgetSmoothNew.getLocalTime(advertDo.getNowTime())) == null) {
                updateTimeLocal = BudgetSmoothNew.getLocalTime(advertDo.getTime());
            }
            LocalTime startTimeLocal = BudgetSmoothNew.getLocalTime(advertDo.getStartTime());
            LocalTime endTimeLocal = BudgetSmoothNew.getLocalTime(advertDo.getEndTime());
            LocalTime currentTimeLocal = LocalTime.now();
            if (updateTimeLocal.isAfter(endTimeLocal) || updateTimeLocal.isBefore(startTimeLocal)) {
                return false;
            }
            if (currentTimeLocal.isAfter(endTimeLocal) || currentTimeLocal.isBefore(startTimeLocal)) {
                return false;
            }
            if (updateTimeLocal.isAfter(currentTimeLocal)) {
                return false;
            }
        }
        return ret;
    }

    public static BudgetSmoothDo getBudgetSmooth(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        BudgetSmoothDo ret = new BudgetSmoothDo();
        Long budgetType = null;
        Long timeType = null;
        Double ratio = null;
        Double timeRatio = null;
        Double budgetRatio = null;
        Double currentRatio = null;
        Double currentTimeRatio = null;
        Double currentBudgetRatio = null;
        Boolean currentValid = false;
        Boolean isSmooth = false;
        Boolean valid = false;
        if (budgetDo != null) {
            budgetType = budgetDo.getBudgetType();
            timeType = budgetDo.getTimeType();
            valid = true;
            String updateTime = budgetDo.getNowTime();
            if (updateTime == null) {
                updateTime = budgetDo.getTime();
            }
            timeRatio = timeType.equals(3L) ? BudgetSmoothNew.getTimeRatio(updateTime) : BudgetSmoothNew.getTimeRatio(updateTime, budgetDo.getStartTime(), budgetDo.getEndTime());
            budgetRatio = BudgetSmoothNew.getBudgetRatio(budgetDo.getBudget(), budgetDo.getConsumeTotal());
            ratio = BudgetSmoothNew.getRatio(budgetRatio, timeRatio);
            if (lastBudgetDo != null) {
                Double lastTimeRatio = null;
                String lastUpdateTime = lastBudgetDo.getNowTime();
                if (lastUpdateTime == null) {
                    lastUpdateTime = lastBudgetDo.getTime();
                }
                lastTimeRatio = timeType.equals(3L) ? BudgetSmoothNew.getTimeRatio(lastUpdateTime) : BudgetSmoothNew.getTimeRatio(lastUpdateTime, lastBudgetDo.getStartTime(), lastBudgetDo.getEndTime());
                Double lastBudgetRatio = BudgetSmoothNew.getBudgetRatio(lastBudgetDo.getBudget(), lastBudgetDo.getConsumeTotal());
                currentTimeRatio = DataUtil.addDouble((Double)timeRatio, (Double)(-1.0 * lastTimeRatio), (int)7);
                currentBudgetRatio = DataUtil.addDouble((Double)budgetRatio, (Double)(-1.0 * lastBudgetRatio), (int)7);
                currentRatio = BudgetSmoothNew.getRatio(currentBudgetRatio, currentTimeRatio);
                if (currentTimeRatio > 0.0) {
                    currentValid = true;
                }
            }
            if (!BudgetSmoothNew.isTimeValid(updateTime, timeRatio, timeType)) {
                ratio = null;
                currentRatio = null;
                isSmooth = false;
            } else {
                isSmooth = true;
            }
        }
        ret.setBudgetDo(budgetDo);
        ret.setBudgetRatio(budgetRatio);
        ret.setTimeRatio(timeRatio);
        ret.setCurrentBudgetRatio(currentBudgetRatio);
        ret.setCurrentTimeRatio(currentTimeRatio);
        ret.setTimeType(timeType);
        ret.setBudgetType(budgetType);
        ret.setRatio(ratio);
        ret.setCurrentValid(currentValid);
        ret.setCurrentRatio(currentRatio);
        ret.setNeedSmooth(isSmooth);
        ret.setValid(valid);
        return ret;
    }

    public static Double getRatio(Double budgetRatio, Double timeRatio) {
        Double ret = null;
        if (budgetRatio != null && timeRatio != null && timeRatio > 0.0 && budgetRatio >= 0.0) {
            ret = DataUtil.division((Double)budgetRatio, (Double)timeRatio, (int)5);
        }
        return ret;
    }

    public static Double getBudgetRatio(Long budget, Long consumeTotal) {
        Double ret = null;
        if (budget != null && consumeTotal != null && budget > 10L) {
            Long consume = Math.max(1L, consumeTotal);
            ret = DataUtil.division((Long)consume, (Long)budget, (int)5);
            ret = Math.min(ret, 1.0);
        }
        return ret;
    }

    public static Double getTimeRatio(String updateTime) {
        return BudgetSmoothNew.getTimeRatio(updateTime, "00:00", "23:59:59");
    }

    public static Double getTimeRatio(String updateTime, String startTime, String endTime) {
        Double ret = 0.0;
        if (endTime != null && (endTime.equals("24:00") || endTime.equals("24:00:00"))) {
            endTime = "23:59:59";
        }
        Double timeRatioS2E = BudgetSmoothNew.getTimeRatio(startTime, endTime);
        Double timeRatioS2U = BudgetSmoothNew.getTimeRatio(startTime, updateTime);
        if (timeRatioS2E != null && timeRatioS2U != null && timeRatioS2E >= timeRatioS2U) {
            ret = DataUtil.division((Double)timeRatioS2U, (Double)timeRatioS2E, (int)5);
        }
        return ret;
    }

    public static Double getTimeRatio(String startTime, String endTime) {
        Double ret = 0.0;
        LocalTime startTimeLT = BudgetSmoothNew.getLocalTime(startTime);
        LocalTime endTimeLT = BudgetSmoothNew.getLocalTime(endTime);
        if (startTimeLT != null && endTimeLT != null) {
            Double startRatio = BudgetSmoothNew.getTimeRatio(startTimeLT.getHour(), startTimeLT.getMinute(), startTimeLT.getSecond());
            Double endRatio = BudgetSmoothNew.getTimeRatio(endTimeLT.getHour(), endTimeLT.getMinute(), endTimeLT.getSecond());
            if (endTimeLT.equals(startTimeLT)) {
                endRatio = BudgetSmoothNew.getTimeRatio(endTimeLT.getHour(), endTimeLT.getMinute() + 1, endTimeLT.getSecond());
            }
            ret = DataUtil.addDouble((Double)endRatio, (Double)(-1.0 * startRatio), (int)5);
        }
        return ret;
    }

    public static LocalTime getLocalTime(String time) {
        LocalTime ret = null;
        String pattern = DateStyle.HH_MM.getValue();
        if (time.length() > 5) {
            pattern = DateStyle.HH_MM_SS.getValue();
        }
        ret = LocalDateUtil.getLocalTime((String)time, (String)pattern);
        return ret;
    }

    public static Double getTimeRatio(int hour, int minute) {
        return BudgetSmoothNew.getTimeRatio(hour, (double)minute + 0.0);
    }

    public static Double getTimeRatio(int hour, int minute, int second) {
        return BudgetSmoothNew.getTimeRatio(hour, (double)minute + ((double)second + 0.0) / 60.0);
    }

    public static Double getTimeRatio(int hour, double minute) {
        Double ret = null;
        double hourWeight = 0.0;
        double minuteWeight = 0.0;
        for (int i = 0; i < hour; ++i) {
            hourWeight += reqDist[i];
        }
        if (hour < 24) {
            minuteWeight = reqDist[hour] * (minute + 0.0) / 60.0;
        }
        ret = DataUtil.division((Double)(hourWeight + minuteWeight), (Double)retDistWeightSum, (int)5);
        return ret;
    }

    public static boolean isTimeValid(String updateTime, Double timeRatio, Long timeType) {
        boolean ret = true;
        LocalTime updateTimeLocal = BudgetSmoothNew.getLocalTime(updateTime);
        LocalTime currentTimeLocal = LocalTime.now();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{timeType, timeRatio})) {
            return false;
        }
        if (timeType.equals(3L) && timeRatio > 0.95) {
            return false;
        }
        if (timeType.equals(2L) && timeRatio > 0.9) {
            return false;
        }
        if (timeType.equals(1L) && timeRatio > 0.9) {
            return false;
        }
        Long secondDiff = LocalDateUtil.getBetweenSeconds((LocalTime)updateTimeLocal, (LocalTime)currentTimeLocal);
        if (secondDiff != null && secondDiff > DELAY_VALID_SECOND) {
            return false;
        }
        return ret;
    }

    public static Boolean equals(Long a, Long b) {
        Boolean ret = false;
        if (AssertUtil.isAllEmpty((Object[])new Object[]{a, b})) {
            ret = true;
        } else if (AssertUtil.isAnyEmpty((Object[])new Object[]{a, b})) {
            ret = false;
        } else if (a.equals(b)) {
            ret = true;
        }
        return ret;
    }

    public static void updateSmoothFactor(BudgetSmoothDo budgetSmoothDo) {
        Double ret = 1.0;
        Double totalLearnRatio = 0.4;
        Double currentLearnRatio = 0.3;
        Double smoothLowerLimit = 0.025;
        Double smoothUpperLimit = 1.0;
        if (budgetSmoothDo == null) {
            return;
        }
        Double smoothFactor = budgetSmoothDo.getSmoothFactor();
        if (smoothFactor == null) {
            smoothFactor = 1.0;
        }
        if (budgetSmoothDo.getNeedSmooth().booleanValue() && budgetSmoothDo.getRatio() != null && budgetSmoothDo.getRatio() > 1.0 && budgetSmoothDo.getTimeType() != null) {
            if (budgetSmoothDo.getTimes() <= 3L) {
                totalLearnRatio = 1.0 - (double)budgetSmoothDo.getTimes() * 0.1;
                currentLearnRatio = 1.0 - (double)budgetSmoothDo.getTimes() * 0.1;
            }
            if (smoothFactor <= 0.0252) {
                smoothLowerLimit = Math.max(smoothLowerLimit / budgetSmoothDo.getRatio(), 0.01);
            }
            Double totalFactor = 1.0 - totalLearnRatio + totalLearnRatio * (1.0 / BudgetSmoothNew.noiseSmoother(budgetSmoothDo.getRatio(), 0.5, 10.0));
            Double currentFactor = 1.0;
            if (budgetSmoothDo.getCurrentValid().booleanValue() && budgetSmoothDo.getCurrentRatio() != null) {
                currentFactor = 1.0 - currentLearnRatio + currentLearnRatio * (1.0 / BudgetSmoothNew.noiseSmoother(budgetSmoothDo.getCurrentRatio(), 0.4, 10.0));
            }
            ret = smoothFactor * currentFactor * Math.pow(totalFactor, 1.05);
            budgetSmoothDo.setTimes(budgetSmoothDo.getTimes() + 1L);
        } else {
            budgetSmoothDo.setTimes(0L);
        }
        ret = BudgetSmoothNew.noiseSmoother(ret, smoothLowerLimit, smoothUpperLimit);
        ret = DataUtil.formatDouble((Double)ret, (int)3);
        budgetSmoothDo.setSmoothFactor(ret);
    }

    public static Double noiseSmoother(Double point, Double lowerLimit, Double upperLimit) {
        Double ret = point;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{upperLimit, lowerLimit})) {
            return ret;
        }
        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }
        return ret;
    }

    public static SmoothResultDo getSmooth(BudgetSmoothDo budgetSmoothDo) {
        SmoothResultDo ret = new SmoothResultDo();
        ret.setGiveUp(false);
        if (AssertUtil.isNotEmpty((Object)budgetSmoothDo)) {
            Double smoothFactor = budgetSmoothDo.getSmoothFactor();
            if (smoothFactor != null && smoothFactor < 1.0 && budgetSmoothDo.getNeedSmooth() != null && budgetSmoothDo.getNeedSmooth().booleanValue() && Math.random() > smoothFactor) {
                ret.setGiveUp(true);
            }
            if (budgetSmoothDo.getBudgetDo() != null) {
                ret.setAdvertId(budgetSmoothDo.getBudgetDo().getAdvertId());
                ret.setPlanId(budgetSmoothDo.getBudgetDo().getPlanId());
            }
            ret.setNeedSmooth(budgetSmoothDo.getNeedSmooth());
            ret.setSmoothFactor(smoothFactor);
            ret.setBudgetType(budgetSmoothDo.getBudgetType());
            ret.setTimeType(budgetSmoothDo.getTimeType());
            ret.setRatio(budgetSmoothDo.getRatio());
            ret.setBudgetRatio(budgetSmoothDo.getBudgetRatio());
            ret.setTimeRatio(budgetSmoothDo.getTimeRatio());
            ret.setValid(budgetSmoothDo.getValid());
        }
        return ret;
    }

    public static void main(String[] args) {
        String[] adTimeList = new String[]{"09:40:30", "09:41:30", "09:42:30", "09:43:30", "09:44:30"};
        Long[] ctList = new Long[]{300000L, 404900L, 504900L, 604900L, 704900L};
        String adStr = "{\"advertId\":42650,\"budget\":1000000,\"budgetType\":5,\"consumeTotal\":120000,\"endTime\":\"17:59\",\"nowTime\":\"17:09:19\",\"periodId\":253250,\"planId\":88955,\"startTime\":\"17:00\",\"time\":\"17:09\",\"timeType\":2}";
        BudgetSmoothDo lastBudgetSmoothDo = null;
        for (int i = 0; i < 5; ++i) {
            BudgetSmoothDo budgetSmoothDo;
            BudgetDo ad = (BudgetDo)JSON.parseObject((String)adStr, BudgetDo.class);
            ad.setStartTime("09:00");
            ad.setEndTime("11:59");
            ad.setNowTime(adTimeList[i]);
            ad.setConsumeTotal(ctList[i]);
            lastBudgetSmoothDo = budgetSmoothDo = BudgetSmoothAlg.getBudgetRatio(ad, lastBudgetSmoothDo);
            System.out.println(i + "=" + JSON.toJSONString((Object)budgetSmoothDo));
        }
    }

    static {
        Double hourWeightSum = 0.0;
        for (int i = 0; i < reqDist.length; ++i) {
            hourWeightSum = hourWeightSum + reqDist[i];
        }
        retDistWeightSum = hourWeightSum;
    }
}

