package cn.com.duiba.nezha.alg.alg.budget;

import cn.com.duiba.nezha.alg.alg.alg.BudgetSmoothAlg;
import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.BudgetDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SmoothResultDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.LoggerFactory;

import java.time.LocalTime;
import java.util.Calendar;


public class BudgetSmoothNew {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(BudgetSmoothNew.class);

    /**
     * 【0，23】0~23小时
     */
    public static double[] reqDist = {
            110, 60, 40, 30, 40, 70,
            140, 165, 175, 155, 170, 185,
            205, 175, 155, 150, 165, 190,
            200, 230, 230, 200, 155, 100};


    public static Double retDistWeightSum = null;

    /**
     * 数据有效 10分钟
     */
    public static long DELAY_VALID_SECOND = 60 * 10 ;

    static {
        Double hourWeightSum = 0.0;
        for (int i = 0; i < reqDist.length; i++) {
            hourWeightSum += reqDist[i];
        }
        retDistWeightSum = hourWeightSum;
    }

    /**
     * @param advertBudgetInfo     历史累计
     * @param lastAdvertBudgetInfo 上次历史类型
     * @return
     */

    /**
     * @param budgetDo           历史累计数据
     * @param lastBudgetSmoothDo 上一次计算结果
     * @return
     */
    public static BudgetSmoothDo getRatio(BudgetDo budgetDo, BudgetSmoothDo lastBudgetSmoothDo) {
        BudgetSmoothDo ret = new BudgetSmoothDo();


        /**
         * 选择 当次预算类型、平滑时段类型
         *
         * 条件：a)合法性校验
         * 条件：b)优先级：预算类型5、4、3、2、1
         * 条件：c)优先级：
         *
         * 步骤：
         * 步骤1、当前数据是否合法
         * 步骤2、上次数据是否一致
         * 步骤3、消耗速度计算（历史累计、实时）
         * 步骤4、计算平滑因子
         *
         */


        // 步骤1 当前数据是否合法

        if (budgetDo != null && !isValid(budgetDo)) {
            logger.warn("BudgetSmoothNew.getRatio(BudgetDo budgetDo, BudgetSmoothDo lastBudgetSmoothDo)  input invalid ,budgetDo=" + JSON.toJSONString(budgetDo));
            budgetDo = null;
        }
        // 步骤2 上次数据是否一致
        BudgetDo lastBudgetDo = null;
        if (lastBudgetSmoothDo != null) {
            lastBudgetDo = getLastBudgetDo(budgetDo, lastBudgetSmoothDo.getBudgetDo());
        }


        // 3 消耗速度计算

        try {
            ret = getBudgetSmooth(budgetDo, lastBudgetDo);

        } catch (Exception e) {
            logger.warn("BudgetSmoothNew.getRatio  getBudgetSmooth happend error,lastBudgetSmoothDo={}", JSON.toJSONString(lastBudgetSmoothDo), e);
        }


        // 4 平滑因子更新
        if (lastBudgetSmoothDo != null) {
            ret.setSmoothFactor(lastBudgetSmoothDo.getSmoothFactor());
            ret.setTimes(lastBudgetSmoothDo.getTimes());
        }

        updateSmoothFactor(ret);
//        Double smoothFactor = updateSmoothFactor(ret);
//        ret.setSmoothFactor(smoothFactor);

        return ret;
    }


    public static BudgetDo getLastBudgetDo(BudgetDo budgetDo, BudgetDo lastBudgetDo) {

        BudgetDo ret = null;
        if (lastResultValid(budgetDo, lastBudgetDo)) {

            ret = lastBudgetDo;
        }

        return ret;
    }


    /**
     * 判断上次数据与本次数据是否一致
     *
     * @param budgetDo
     * @param lastBudgetDo
     * @return
     */
    public static Boolean lastResultValid(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        Boolean ret = true;

        /**
         * 1、空值，不合法
         * 2、数据对象是否合法
         * 3、类型是否一致
         */

        if (AssertUtil.isAnyEmpty(budgetDo, lastBudgetDo)) {
            return false;
        }


        if (!isValid(lastBudgetDo)) {
            return false;
        }


        if (!budgetDo.getTimeType().equals(lastBudgetDo.getTimeType())) {
            return false;
        }

        if (!budgetDo.getBudgetType().equals(lastBudgetDo.getBudgetType())) {
            return false;
        }

        if (!budgetDo.getBudget().equals(lastBudgetDo.getBudget())) {
            return false;
        }

        if (!budgetDo.getTimeType().equals(3L)) {

            if (!budgetDo.getStartTime().equals(lastBudgetDo.getStartTime())) {
                return false;
            }
            if (!budgetDo.getEndTime().equals(lastBudgetDo.getEndTime())) {
                return false;
            }
        }


        return ret;
    }

    public static Boolean isValid(BudgetDo advertDo) {
        Boolean ret = true;

        /**
         * 1、基础信息判断：对象不为空、对象（预算类型、预算、时间、平滑类型）不为空
         * 不合法，返回false
         */
        if (advertDo == null || AssertUtil.isAnyEmpty(
                advertDo.getBudgetType(),
                advertDo.getBudget(),
                advertDo.getTimeType()
        )) {
            return false;
        }

        /**
         * 2、预算：是否不限
         * 预算<20元，不合法，返回false
         */

        if (advertDo.getBudget() == null || advertDo.getBudget() < 2000L) {
            return false;
        }

        /**
         * 3、如果类型为4 or 5：时段信息不为空
         * 不合法，返回false
         */
        if (advertDo.getBudgetType().equals(4L) || advertDo.getBudgetType().equals(5L)) {
            if (AssertUtil.isAnyEmpty(advertDo.getStartTime(), advertDo.getEndTime())) {
                return false;
            }

            if (advertDo.getTimeType().equals(3L)) {
                return false;
            }
        }

        /**
         * 4、如果时段类型为1，2，时段信息不为空
         * 时段信息不为空 不合法，返回 false
         * 时间超出时段范围，不合法
         */

        if (advertDo.getTimeType().equals(1L) || advertDo.getTimeType().equals(2L)) {
            if (AssertUtil.isAnyEmpty(advertDo.getStartTime(), advertDo.getEndTime())) {
                return false;
            }

            if (advertDo.getEndTime().equals("24:00") || advertDo.getEndTime().equals("24:00:00")) {
                advertDo.setEndTime("23:59:59");
            }

            LocalTime updateTimeLocal = getLocalTime(advertDo.getNowTime());
            if (updateTimeLocal == null) {
                updateTimeLocal = getLocalTime(advertDo.getTime());
            }


            LocalTime startTimeLocal = getLocalTime(advertDo.getStartTime());
            LocalTime endTimeLocal = getLocalTime(advertDo.getEndTime());

            LocalTime currentTimeLocal = LocalTime.now();

            if (updateTimeLocal.isAfter(endTimeLocal) || updateTimeLocal.isBefore(startTimeLocal)) {
                return false;
            }

            if (currentTimeLocal.isAfter(endTimeLocal) || currentTimeLocal.isBefore(startTimeLocal)) {
                return false;
            }

            if (updateTimeLocal.isAfter(currentTimeLocal)) {
                return false;
            }

        }


        return ret;
    }


    /**
     * 预算平滑消耗速度对象
     *
     * @param budgetDo
     * @param lastBudgetDo
     * @return
     */
    public static BudgetSmoothDo getBudgetSmooth(BudgetDo budgetDo, BudgetDo lastBudgetDo) {
        BudgetSmoothDo ret = new BudgetSmoothDo();

        Long budgetType = null;

        Long timeType = null;

        Double ratio = null;

        Double timeRatio = null;

        Double budgetRatio = null;


        Double currentRatio = null;

        Double currentTimeRatio = null;

        Double currentBudgetRatio = null;

        Boolean currentValid = false;

        Boolean isSmooth = false;

        Boolean valid = false;


        if (budgetDo != null) {

            budgetType = budgetDo.getBudgetType();
            timeType = budgetDo.getTimeType();
            valid = true;

            String updateTime = budgetDo.getNowTime();
            if (updateTime == null) {
                updateTime = budgetDo.getTime();
            }

            // 时间（流量）消耗
            if (timeType.equals(3L)) {
                // 全日
                timeRatio = getTimeRatio(updateTime);

            } else {
                // 时段/小时
                timeRatio = getTimeRatio(updateTime, budgetDo.getStartTime(), budgetDo.getEndTime());
            }


            // 预算消耗
            budgetRatio = getBudgetRatio(budgetDo.getBudget(), budgetDo.getConsumeTotal());


            ratio = getRatio(budgetRatio, timeRatio);


            if (lastBudgetDo != null) {

                Double lastTimeRatio = null;

                String lastUpdateTime = lastBudgetDo.getNowTime();
                if (lastUpdateTime == null) {
                    lastUpdateTime = lastBudgetDo.getTime();
                }

                if (timeType.equals(3L)) {
                    // 全日
                    lastTimeRatio = getTimeRatio(lastUpdateTime);
                } else {
                    // 时段/小时
                    lastTimeRatio = getTimeRatio(lastUpdateTime, lastBudgetDo.getStartTime(), lastBudgetDo.getEndTime());
                }

                // 预算消耗
                Double lastBudgetRatio = getBudgetRatio(lastBudgetDo.getBudget(), lastBudgetDo.getConsumeTotal());

                currentTimeRatio = DataUtil.addDouble(timeRatio, -1 * lastTimeRatio, 7);

                currentBudgetRatio = DataUtil.addDouble(budgetRatio, -1 * lastBudgetRatio, 7);

                currentRatio = getRatio(currentBudgetRatio, currentTimeRatio);
                if (currentTimeRatio > 0.0) {
                    currentValid = true;
                }
            }


            if (!isTimeValid(updateTime, timeRatio, timeType)) {
                ratio = null;
                currentRatio = null;
                isSmooth = false;
            } else {
                isSmooth = true;
            }


        }

        ret.setBudgetDo(budgetDo);
        ret.setBudgetRatio(budgetRatio);
        ret.setTimeRatio(timeRatio);

        ret.setCurrentBudgetRatio(currentBudgetRatio);
        ret.setCurrentTimeRatio(currentTimeRatio);


        ret.setTimeType(timeType);
        ret.setBudgetType(budgetType);
        ret.setRatio(ratio);
        ret.setCurrentValid(currentValid);
        ret.setCurrentRatio(currentRatio);
        ret.setNeedSmooth(isSmooth);
        ret.setValid(valid);
        return ret;
    }


    /**
     * 消耗速度
     */
    public static Double getRatio(Double budgetRatio, Double timeRatio) {
        Double ret = null;

        if (budgetRatio != null && timeRatio != null && timeRatio > 0 && budgetRatio >= 0) {
            ret = DataUtil.division(budgetRatio, timeRatio, 5);
        }
        return ret;
    }

    /**
     * @return 预算速度
     */
    public static Double getBudgetRatio(Long budget, Long consumeTotal) {
        Double ret = null;
        if (budget != null && consumeTotal != null && budget > 10) {

            Long consume = Math.max(1, consumeTotal);
            ret = DataUtil.division(consume, budget, 5);
            ret = Math.min(ret, 1.0);
        }
        return ret;
    }

    /**
     * @param updateTime
     * @return 时间速度
     */
    public static Double getTimeRatio(String updateTime) {

        return getTimeRatio(updateTime, "00:00", "23:59:59");
    }


    /**
     * 时间消耗速度
     *
     * @param updateTime
     * @param startTime
     * @param endTime
     * @return
     */
    public static Double getTimeRatio(String updateTime, String startTime, String endTime) {
        Double ret = 0.0;


        if (endTime != null && (endTime.equals("24:00") || endTime.equals("24:00:00"))) {
            endTime = "23:59:59";
        }

        Double timeRatioS2E = getTimeRatio(startTime, endTime);

        Double timeRatioS2U = getTimeRatio(startTime, updateTime);

        if (timeRatioS2E != null && timeRatioS2U != null && timeRatioS2E >= timeRatioS2U) {
            ret = DataUtil.division(timeRatioS2U, timeRatioS2E, 5);
        }

        return ret;
    }

    /**
     * 时间（流量）消耗速度
     *
     * @param startTime
     * @param endTime
     * @return
     */
    public static Double getTimeRatio(String startTime, String endTime) {
        Double ret = 0.0;

        LocalTime startTimeLT = getLocalTime(startTime);
        LocalTime endTimeLT = getLocalTime(endTime);


        if (startTimeLT != null && endTimeLT != null) {
            Double startRatio = getTimeRatio(startTimeLT.getHour(), startTimeLT.getMinute(), startTimeLT.getSecond());

            Double endRatio = getTimeRatio(endTimeLT.getHour(), endTimeLT.getMinute(), endTimeLT.getSecond());

            if (endTimeLT.equals(startTimeLT)) {
                endRatio = getTimeRatio(endTimeLT.getHour(), endTimeLT.getMinute() + 1, endTimeLT.getSecond());
            }

            ret = DataUtil.addDouble(endRatio, -1 * startRatio, 5);

        }
        return ret;
    }


    public static LocalTime getLocalTime(String time) {
        LocalTime ret = null;
        String pattern = DateStyle.HH_MM.getValue();
        if (time.length() > 5) {
            pattern = DateStyle.HH_MM_SS.getValue();
        }
        ret = LocalDateUtil.getLocalTime(time, pattern);
        return ret;

    }

    /**
     * 时间（流量）消耗速度-累计
     *
     * @param hour
     * @return
     */
    public static Double getTimeRatio(int hour, int minute) {
        return getTimeRatio(hour, minute + 0.0);
    }

    /**
     * 时间（流量）消耗速度-累计
     *
     * @param hour
     * @return
     */
    public static Double getTimeRatio(int hour, int minute, int second) {
        return getTimeRatio(hour, minute + (second + 0.0) / 60);
    }

    /**
     * 时间（流量）消耗速度-累计
     *
     * @param hour
     * @return
     */
    public static Double getTimeRatio(int hour, double minute) {
        Double ret = null;

        double hourWeight = 0.0;
        double minuteWeight = 0.0;
        for (int i = 0; i < hour; i++) {
            hourWeight += reqDist[i];
        }
        if (hour < 24) {
            minuteWeight = reqDist[hour] * (minute + 0.0) / 60;
        }
        ret = DataUtil.division(hourWeight + minuteWeight, retDistWeightSum, 5);
        return ret;
    }


    /**
     * @param updateTime
     * @return 时间速度
     */
    public static boolean isTimeValid(String updateTime, Double timeRatio, Long timeType) {
        boolean ret = true;
        LocalTime updateTimeLocal = getLocalTime(updateTime);
        LocalTime currentTimeLocal = LocalTime.now();


        /**
         * 合法逻辑
         * a、值均有效
         *
         * a、当前时间在投放区间内
         *
         * b、时间（流量）消耗在90%内（时段），95%内（日）
         *
         * c、当前时间与更新时间差10分钟内
         */

        // a
        if (AssertUtil.isAnyEmpty(timeType, timeRatio)) {
            return false;
        }

        if (timeType.equals(3L) && timeRatio > 0.95) {

            return false;
        }
        if (timeType.equals(2L) && timeRatio > 0.9) {

            return false;
        }

        if (timeType.equals(1L) && timeRatio > 0.9) {

            return false;
        }


        Long secondDiff = LocalDateUtil.getBetweenSeconds(updateTimeLocal, currentTimeLocal);
        if (secondDiff != null && secondDiff > DELAY_VALID_SECOND) {
            return false;
        }

        return ret;
    }




    /**
     * 平滑因子更新
     *
     * @param budgetSmoothDo
     * @return
     */
    public static void updateSmoothFactor(BudgetSmoothDo budgetSmoothDo) {
        Double ret = 1.0;

        Double totalLearnRatio = 0.4;
        Double currentLearnRatio = 0.3;

        Double smoothLowerLimit = 0.025;
        Double smoothUpperLimit = 1.0;

        if (budgetSmoothDo == null) {
            return;
        }

        Double smoothFactor = budgetSmoothDo.getSmoothFactor();
        if (smoothFactor == null) {
            smoothFactor = 1.0;
        }

        if (budgetSmoothDo.getNeedSmooth() && budgetSmoothDo.getRatio() != null && budgetSmoothDo.getRatio() > 1.0 && budgetSmoothDo.getTimeType() != null) {


            // 学效率调整
            if (budgetSmoothDo.getTimes() <= 3) {
                totalLearnRatio = 1.0 - budgetSmoothDo.getTimes() * 0.1;
                currentLearnRatio = 1.0 - budgetSmoothDo.getTimes() * 0.1;
            }

            // 调节阈值自适应
            if (smoothFactor <= 0.0252) {
                smoothLowerLimit = Math.max(smoothLowerLimit / budgetSmoothDo.getRatio(), 0.01);
            }


            Double totalFactor = (1 - totalLearnRatio) + totalLearnRatio * (1 / (MathBase.noiseSmoother(budgetSmoothDo.getRatio(), 0.5, 10.0)));

            Double currentFactor = 1.0;
            if (budgetSmoothDo.getCurrentValid() && budgetSmoothDo.getCurrentRatio() != null) {
                currentFactor = (1 - currentLearnRatio) + currentLearnRatio * (1 / (MathBase.noiseSmoother(budgetSmoothDo.getCurrentRatio(), 0.4, 10.0)));

            }


            ret = smoothFactor * currentFactor * Math.pow(totalFactor, 1.05);

            // 计数
            budgetSmoothDo.setTimes(budgetSmoothDo.getTimes() + 1);
        } else {
            budgetSmoothDo.setTimes(0);
        }


        ret = MathBase.noiseSmoother(ret, smoothLowerLimit, smoothUpperLimit);

        ret = DataUtil.formatDouble(ret, 3);


        budgetSmoothDo.setSmoothFactor(ret);

    }




    /**
     * 平滑因子更新
     *
     * @param budgetSmoothDo
     * @return
     */
    public static SmoothResultDo getSmooth(BudgetSmoothDo budgetSmoothDo) {
        SmoothResultDo ret = new SmoothResultDo();
        ret.setGiveUp(false);

        if (AssertUtil.isNotEmpty(budgetSmoothDo)) {

            Double smoothFactor = budgetSmoothDo.getSmoothFactor();
            if (smoothFactor != null && smoothFactor < 1.0 && budgetSmoothDo.getNeedSmooth() != null && budgetSmoothDo.getNeedSmooth()) {

                if (Math.random() > smoothFactor) {
                    ret.setGiveUp(true);
                }
            }

            if (budgetSmoothDo.getBudgetDo() != null) {

                ret.setAdvertId(budgetSmoothDo.getBudgetDo().getAdvertId());
                ret.setPlanId(budgetSmoothDo.getBudgetDo().getPlanId());
            }
            ret.setNeedSmooth(budgetSmoothDo.getNeedSmooth());
            ret.setSmoothFactor(smoothFactor);
            ret.setBudgetType(budgetSmoothDo.getBudgetType());
            ret.setTimeType(budgetSmoothDo.getTimeType());
            ret.setRatio(budgetSmoothDo.getRatio());
            ret.setBudgetRatio(budgetSmoothDo.getBudgetRatio());
            ret.setTimeRatio(budgetSmoothDo.getTimeRatio());
            ret.setValid(budgetSmoothDo.getValid());

        }

        return ret;

    }


    public static void main(String[] args) {




        String adStr ="{\"advertId\":4210,\"budget\":1000000,\"budgetType\":5,\"consumeTotal\":990000,\"endTime\":\"15:59\",\"nowTime\":\"10:51:19\",\"periodId\":253250,\"planId\":88955,\"startTime\":\"10:00\",\"time\":\"10:51\",\"timeType\":2}";
        BudgetSmoothDo lastBudgetSmoothDo = null;

//        for (int i = 0; i < 2; i++) {
//            BudgetDo ad = JSON.parseObject(adStr, BudgetDo.class);
////
////            ad.setStartTime("09:00");
////            ad.setEndTime("11:59");
////            ad.setNowTime(adTimeList[i]);
////            ad.setConsumeTotal(ctList[i]);
//            BudgetSmoothDo budgetSmoothDo = BudgetSmoothAlg.getBudgetRatio(ad, lastBudgetSmoothDo);
//            lastBudgetSmoothDo = budgetSmoothDo;
//            System.out.println(i + "=" + JSON.toJSONString(budgetSmoothDo));
//
//        }

        // todo 测试完删除
        String nowTime = DateUtils.calendar2TimeString(Calendar.getInstance());
        String  text = "{\"advertId\":4210,\"budget\":1000000,\"budgetType\":5,\"consumeTotal\":990000,\"endTime\":\"15:59\",\"nowTime\":\""+nowTime+":19\"," +
                "\"periodId\":253250,\"planId\":88955,\"startTime\":\"10:00\",\"time\":\""+nowTime+"\",\"timeType\":2}";
        BudgetDo budgetDo = JSONObject.parseObject(text ,BudgetDo.class);

        BudgetSmoothDo newBudgetSmoothDo = BudgetSmoothAlg.getBudgetRatio(budgetDo, null);
        System.out.println(JSON.toJSONString(newBudgetSmoothDo));


        BudgetDo ad = JSON.parseObject(text, BudgetDo.class);
//
//            ad.setStartTime("09:00");
//            ad.setEndTime("11:59");
//            ad.setNowTime(adTimeList[i]);
//            ad.setConsumeTotal(ctList[i]);
        BudgetSmoothDo budgetSmoothDo = BudgetSmoothAlg.getBudgetRatio(ad, lastBudgetSmoothDo);
        lastBudgetSmoothDo = budgetSmoothDo;
        System.out.println("=" + JSON.toJSONString(ad));
    }
}
