package cn.com.duiba.nezha.alg.alg.adx;

import java.util.Map;
import java.util.HashMap;
import com.alibaba.fastjson.JSON;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;



public class AdxRoiFactor {


    //流量分桶Key
    public static String[] adxPricelevel = {"1", "2", "3", "4", "5"};



    /**
     * ROI调节因子(根据缓存数据，调用频率：1min调用1次)
     *
     * @param minRoi 最低ROI(人工设置,小数，如1.50)
     * @param adxRoiControlDoInfo 人工设置和统计数据
     * @param lastAdxRoiFactor 上次更新的ROI调节因子
     * @return  ROI调节因子（小数，如{"1":1.10,"2":1.10,"3":1.10,"4":1.10,"5":1.10})
     */

    public static Map<String,Double> getAdxRoiFactor(Double minRoi,
                                                     AdxRoiControlDo adxRoiControlDoInfo,
                                                     Map<String,Double> lastAdxRoiFactor) {


        //设置默认值
        Double defaultMinRoi = 1.00; //默认最低ROI
        Double defaultRoiFactor = 1.00; //默认ROI调节因子
        Double roiFactorLowerLimit = 0.80; //ROI调节因子下限
        Double roiFactorUpperLimit = 1.30; //ROI调节因子上限
        Double compareRate = 0.05; //默认流量分组比例


        //lastAdxRoiFactor默认值
        if (lastAdxRoiFactor == null) {
            lastAdxRoiFactor = new HashMap<>();
            for (int i = 0; i < adxPricelevel.length; i++) {
                lastAdxRoiFactor.put(adxPricelevel[i], defaultRoiFactor);
            }

        } else{
            for (int i = 0; i < adxPricelevel.length; i++){
                if (lastAdxRoiFactor.get(adxPricelevel[i]) == null
                        || lastAdxRoiFactor.get(adxPricelevel[i]) < roiFactorLowerLimit
                        || lastAdxRoiFactor.get(adxPricelevel[i]) > roiFactorUpperLimit ) {

                    lastAdxRoiFactor.put(adxPricelevel[i], defaultRoiFactor);
                }
            }
        }

        //minRoi默认值
        if (minRoi == null || minRoi < 1.00) {
            minRoi = defaultMinRoi;
        }

        //adxRoiFactor默认值
        Map<String, Double> adxRoiFactor = lastAdxRoiFactor;



        if (AssertUtil.isNotEmpty(adxRoiControlDoInfo)) {

            //设置消耗默认值
            Long defaultFee = 0L;

            //全局统计当天累计--adx消耗，广告消耗
            Long expStatAllDayAdxFee = nullToDefaultValue(adxRoiControlDoInfo.getExpStatAllDayAdxFee(), defaultFee); //实验组-全局统计当天累计-adx消耗（分）
            Long expStatAllDayAdvertFee = nullToDefaultValue(adxRoiControlDoInfo.getExpStatAllDayAdvertFee(), defaultFee); //实验组-全局统计当天累计-广告消耗（分）
            Long comStatAllDayAdxFee = nullToDefaultValue(adxRoiControlDoInfo.getComStatAllDayAdxFee(), defaultFee); //对照组-全局统计当天累计-adx消耗（分）
            Long comStatAllDayAdvertFee = nullToDefaultValue(adxRoiControlDoInfo.getComStatAllDayAdvertFee(), defaultFee); //对照组-全局统计当天累计-广告消耗（分）

            //分桶统计当天累计--adx消耗，广告消耗
            Map<String, Long> expStatBucketDayAdxFee = nullToDefaultValue(adxRoiControlDoInfo.getExpStatBucketDayAdxFee(), defaultFee); //实验组-分桶统计当天累计-adx消耗（分）
            Map<String, Long> expStatBucketDayAdvertFee = nullToDefaultValue(adxRoiControlDoInfo.getExpStatBucketDayAdvertFee(), defaultFee); //实验组-分桶统计当天累计-广告消耗（分）
            Map<String, Long> comStatBucketDayAdxFee = nullToDefaultValue(adxRoiControlDoInfo.getComStatBucketDayAdxFee(), defaultFee); //对照组-分桶统计当天累计-adx消耗（分）
            Map<String, Long> comStatBucketDayAdvertFee = nullToDefaultValue(adxRoiControlDoInfo.getComStatBucketDayAdvertFee(), defaultFee); //对照组-分桶统计当天累计-广告消耗（分）

            //分桶统计历史30min--adx消耗，广告消耗
            Map<String, Long> expStatBucketAdxFee = nullToDefaultValue(adxRoiControlDoInfo.getExpStatBucketAdxFee(), defaultFee); //实验组-分桶统计历史30min-adx消耗（分）
            Map<String, Long> expStatBucketAdvertFee = nullToDefaultValue(adxRoiControlDoInfo.getExpStatBucketAdvertFee(), defaultFee); //实验组-分桶统计历史30min-广告消耗（分）
            Map<String, Long> comStatBucketAdxFee = nullToDefaultValue(adxRoiControlDoInfo.getComStatBucketAdxFee(), defaultFee); //对照组-分桶统计历史30min-adx消耗（分）
            Map<String, Long> comStatBucketAdvertFee = nullToDefaultValue(adxRoiControlDoInfo.getComStatBucketAdvertFee(), defaultFee); //对照组-分桶统计历史30min-广告消耗（分）



            //实际ROI：全局-当天累计
            Double expAllDayRoi = DataUtil.division(expStatAllDayAdvertFee, expStatAllDayAdxFee,2); //全局-当天累计-实验组ROI
            Double comAllDayRoi = DataUtil.division(comStatAllDayAdvertFee, comStatAllDayAdxFee,2); //全局-当天累计-对照组ROI
            //实际ROI：分桶-历史30min
            Map<String, Double> expStatBucketRoi = calculateMap(expStatBucketAdxFee, expStatBucketAdvertFee); //分桶-历史30min-实验组ROI
            Map<String, Double> comStatBucketRoi = calculateMap(comStatBucketAdxFee, comStatBucketAdvertFee); //分桶-历史30min-对照组ROI

            System.out.println("expAllDayRoi:" + JSON.toJSONString(expAllDayRoi));
            System.out.println("comAllDayRoi:" + JSON.toJSONString(comAllDayRoi));
            System.out.println("expStatBucketRoi:" + JSON.toJSONString(expStatBucketRoi));
            System.out.println("comStatBucketRoi:" + JSON.toJSONString(comStatBucketRoi));


            Double alpha = 0.80; //调节率
            Double step = 0.05; //步长

            //更新adxRoiFactor
            for (Map.Entry<String,Double> entry : lastAdxRoiFactor.entrySet()){
                String adxPriceLevel = entry.getKey();
                Double lastRoiFactor = entry.getValue();

                Double roiFactor = lastRoiFactor;
                if(roiFactor == null){
                    roiFactor = defaultRoiFactor;

                }else{

                    if(adxPriceLevel.equals("1")){

                        if(expAllDayRoi > minRoi * 0.90
                                || expAllDayRoi > comAllDayRoi * 1.10
                                || expStatBucketRoi.get(adxPriceLevel) > minRoi * 0.85
                                || expStatBucketRoi.get(adxPriceLevel) > comStatBucketRoi.get(adxPriceLevel) * 1.05) {

                            if (expStatAllDayAdxFee < comStatAllDayAdxFee * (1/compareRate-1) * 0.90
                                    || expStatBucketDayAdxFee.get(adxPriceLevel) < comStatBucketDayAdxFee.get(adxPriceLevel) * (1/compareRate-1) * 0.85) {

                                roiFactor += -alpha * step;
                            }
                        }
                    }

                    if(adxPriceLevel.equals("2")){

                        if(expAllDayRoi > minRoi * 0.95
                                || expAllDayRoi > comAllDayRoi * 1.10
                                || expStatBucketRoi.get(adxPriceLevel) > minRoi * 0.90
                                || expStatBucketRoi.get(adxPriceLevel) > comStatBucketRoi.get(adxPriceLevel) * 1.05) {

                            if (expStatAllDayAdxFee < comStatAllDayAdxFee * (1/compareRate-1) * 0.95
                                    || expStatBucketDayAdxFee.get(adxPriceLevel) < comStatBucketDayAdxFee.get(adxPriceLevel) * (1/compareRate-1) * 0.90) {

                                roiFactor += -alpha * step;
                            }
                        }
                    }

                    if(adxPriceLevel.equals("3")){

                        if(expAllDayRoi < minRoi * 0.85
                                || expAllDayRoi < comAllDayRoi * 1.05
                                || expStatBucketRoi.get(adxPriceLevel) < minRoi * 0.85
                                || expStatBucketRoi.get(adxPriceLevel) < comStatBucketRoi.get(adxPriceLevel) * 1.07) {

                            roiFactor += alpha * step;
                        }
                    }

                    if(adxPriceLevel.equals("4")){

                        if(expAllDayRoi < minRoi * 0.90
                                || expAllDayRoi < comAllDayRoi * 1.07
                                || expStatBucketRoi.get(adxPriceLevel) < minRoi * 0.90
                                || expStatBucketRoi.get(adxPriceLevel) < comStatBucketRoi.get(adxPriceLevel) * 1.10) {

                            roiFactor += alpha * step;
                        }
                    }

                    if(adxPriceLevel.equals("5")){

                        if(expAllDayRoi < minRoi * 0.95
                                || expAllDayRoi < comAllDayRoi * 1.10
                                || expStatBucketRoi.get(adxPriceLevel) < minRoi * 0.95
                                || expStatBucketRoi.get(adxPriceLevel) < comStatBucketRoi.get(adxPriceLevel) * 1.13) {

                            roiFactor += alpha * step;
                        }
                    }

                }

                adxRoiFactor.put(adxPriceLevel, roiFactor);
            }

        }


        return adxRoiFactor;
    }





    /**
     * 分桶计算ROI
     *
     * @param adxFeeMap
     * @param advertFeeMap
     * @return 分桶ROI（小数，如1.10)
     */
    public static Map<String, Double> calculateMap(Map<String,Long> adxFeeMap,
                                                   Map<String,Long> advertFeeMap) {

        Map<String, Double> retMap = new HashMap<>();

        for (Map.Entry<String,Long> entry : adxFeeMap.entrySet()){
            String key = entry.getKey();
            Long adx = entry.getValue();
            Long advert = advertFeeMap.get(key);

            Double roi = DataUtil.division(advert, adx,2);
            retMap.put(key, roi);
        }

        return retMap;
    }



    /**
     * 缺失情况，默认重置为defaultValue
     *
     * @param value
     * @param defaultValue
     * @return 默认值
     */
    public static Long nullToDefaultValue(Long value, Long defaultValue) {

        Long ret = value;
        if (value == null || value < 0.00) {
            ret = defaultValue;
        }
        return ret;
    }



    /**
     * 缺失情况，默认重置为defaultValue
     *
     * @param valueMap
     * @param defaultValue
     * @return 默认值
     */
    public static Map<String,Long> nullToDefaultValue(Map<String,Long> valueMap, Long defaultValue) {

        Map<String, Long> retMap = new HashMap<>();

        for (int i = 0; i < adxPricelevel.length; i++) {

            if (AssertUtil.isEmpty(valueMap) || valueMap.get(adxPricelevel[i]) == null || valueMap.get(adxPricelevel[i]) < 0.00) {
                retMap.put(adxPricelevel[i], defaultValue);
            } else {
                retMap.put(adxPricelevel[i], valueMap.get(adxPricelevel[i]));
            }

        }

        return retMap;
    }




    //单元测试
    public static void main(String[] args){

        try {

            //Map<Long, Double> lastAdxRoiFactor1 = null;
            //Map<Long, Double> lastAdxRoiFactor1 = new HashMap<>();
            //lastAdxRoiFactor1.put(2L,1.21);
            //lastAdxRoiFactor1.put(5L,0.21);
            //System.out.println("lastAdxRoiFactor :" + lastAdxRoiFactor1);

            Map<String,Double> ret1 = new HashMap<>();
            ret1.put("1",0.80);
            System.out.println("ret1:" + JSON.toJSONString(ret1));
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setExpStatAllDayAdvertFee(106L);
            adxRoiControlDoInfo1.setExpStatAllDayAdxFee(100L);
            adxRoiControlDoInfo1.setComStatAllDayAdvertFee(100L);
            adxRoiControlDoInfo1.setComStatAllDayAdxFee(100L);

            Map<String,Double> ret2 = AdxRoiFactor.getAdxRoiFactor(1.15, adxRoiControlDoInfo1, null);
            System.out.println("ret2:" + JSON.toJSONString(ret2));


        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
