/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxAlgoBidding;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxPriceExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceExploration {
    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static AdxPriceExplorationDo getExplorePrice(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxPriceExplorationDo ret = new AdxPriceExplorationDo();
        try {
            Double defaultPrice = 10.0;
            Double defaultMinRoi = 1.0;
            Double[] stepList = new Double[]{0.95, 1.0, 1.05};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3};
            Double baseValue = defaultPrice;
            Double[] baseFlowRate = new Double[]{0.2, 0.6, 0.2};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0};
            Double[] lastRealSucRate = new Double[]{0.0, 0.0, 0.0};
            HashMap<String, Long> priceMap = new HashMap<String, Long>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastSucRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            Long tryLabel = 0L;
            Long upLimitBidFee = null;
            Long lastTryLabel = 0L;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Object uppSuc;
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategySecMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategySecDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategySecMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategySecMs, minRoi);
                Map<String, Double> roiLevelMs = StrategyBid.getRoiPriceRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);
                roiMs = StrategyBid.getRoi(strategySecMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategySecMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategySecDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategySecDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                defaultPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(), 10L));
                Double minPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinPrice(), 1L));
                Double maxPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMaxPrice(), DataUtil.double2Long((Double)defaultPrice) + 1L));
                Double basePrice = adxRoiControlDoInfo.getBasePrice();
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                if (sucRateMs < 0.05 && sucRateMs < resoSucRateMs * 0.2 && adxConsumeMs < 200.0) {
                    tryLabel = 1L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05 && sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < resoSucRateMs * 0.2 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 2000000000L && roiLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < minRoi * 0.95) {
                    tryLabel = 1L;
                }
                baseValue = defaultPrice;
                Double lowValue = baseValue * 0.95;
                Double uppValue = baseValue * 1.05;
                Double diff = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || bidCntDay == 0L) {
                    baseValue = defaultPrice;
                } else {
                    Double incre1 = 1.0;
                    AdxPriceExplorationDo lastPriceDoInfo = adxRoiControlDoInfo.getLastPriceExplorationDo();
                    if (AssertUtil.isNotEmpty((Object)lastPriceDoInfo)) {
                        Map<String, Long> lastPriceMap = lastPriceDoInfo.getPriceExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        lastTryLabel = lastPriceDoInfo.getTryLabel();
                        if (AssertUtil.isNotEmpty(lastPriceMap)) {
                            if (lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                baseValue = DataUtil.toDouble((Long)lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()));
                                lowValue = DataUtil.toDouble((Long)lastPriceMap.get(AdxLevel.ADX_LEVEL_ONE.getCode()));
                                uppValue = DataUtil.toDouble((Long)lastPriceMap.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                            }
                            upLimitBidFee = StrategyBid.selectUpLimitFee(lastPriceMap, sucRateLevelMs, lastPriceDoInfo.getUpLimitBidFee());
                            if (lastPriceMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division((Long)lastPriceMap.get(bestLevel), (Double)baseValue, (int)3);
                            }
                        }
                    }
                    if (bidCntMs == 0L) {
                        Double baseDiff = DataUtil.division((Double)baseValue, (Double)defaultPrice) - 1.0;
                        baseValue = baseValue - defaultPrice * baseDiff * 0.2;
                    } else {
                        Double weight1 = 1.0;
                        weight1 = sucRateMs < 0.05 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0)));
                        Double incre2 = 1.0;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((Double)roiMs, (Double)(minRoi * 0.98), (int)3);
                        }
                        Double weight2 = 1.0;
                        weight2 = sucRateMs < 0.05 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                        Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                        incre1 = StrategyBid.getNormalValue(incre1, 1.0, 0.9, 1.1);
                        incre2 = StrategyBid.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
                        Double incre = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
                        if (weight1 == 0.0) {
                            incre = 1.0 + (incre2 - 1.0) * weight2;
                        }
                        Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);
                        if (tryLabel != 1L) {
                            Double MojiRoiLimit = StrategyBid.getMojiRoiLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                            baseValue = upLimitBidFee != null && feeType != null && feeType == 1 ? (StrategyBid.getBaseLevelConfident(resoSucRateMs, sucRateLevelMs, adxConsumeLevelMs) == 1L && roiMs >= minRoi * MojiRoiLimit && roiMs <= minRoi ? Double.valueOf(Math.max(DataUtil.toDouble((Long)upLimitBidFee), baseValue)) : StrategyBid.getNormalValue(baseValue * incre, defaultPrice, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff))) : StrategyBid.getNormalValue(baseValue * incre, defaultPrice, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff));
                        }
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {
                            if (lastTryLabel == 1L) {
                                baseValue = uppValue;
                            }
                            baseValue = Math.min(DataUtil.toDouble((Long)upLimitBidFee), baseValue);
                        }
                    }
                }
                if (tryLabel == 1L) {
                    stepList[0] = DataUtil.division((Double)lowValue, (Double)baseValue);
                    uppSuc = DataUtil.division((Double)sucRateLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)resoSucRateMs, (int)3);
                    Double stepSuc = (Double)uppSuc < 0.4 ? 0.1 : ((Double)uppSuc < 0.5 ? 0.05 : ((Double)uppSuc < 0.6 ? -0.05 : -0.1));
                    Double uppDiff = DataUtil.division((Double)roiLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)minRoi, (int)3);
                    Double stepRoi = uppDiff < 0.8 ? -0.08 : (uppDiff < 0.95 ? -0.06 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? 0.06 : 0.08)));
                    if (adxConsumeMs == 0.0) {
                        stepSuc = 0.1;
                        stepRoi = 0.1;
                    }
                    stepList[2] = DataUtil.division((Double)uppValue, (Double)baseValue) + 0.5 * stepSuc + 0.5 * stepRoi;
                } else {
                    uppSuc = stepList;
                    Double.valueOf(uppSuc[2] + (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
                    uppSuc = stepList;
                    Double.valueOf((Double)uppSuc[0] - (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
                }
                if (upLimitBidFee != null) {
                    stepList[2] = Math.min(stepList[2], DataUtil.division((Long)upLimitBidFee, (Double)baseValue));
                }
                if (basePrice != null && basePrice > 0.0) {
                    stepList[2] = Math.max(stepList[2], DataUtil.division((Double)basePrice, (Double)baseValue));
                }
                if (tryLabel == 1L) {
                    baseFlowRate[2] = 0.2;
                    baseFlowRate[0] = 0.2;
                    if (upLimitBidFee != null && feeType != null && feeType == 1) {
                        baseFlowRate[0] = 0.0;
                    }
                } else {
                    if (diff < 0.9) {
                        baseFlowRate[2] = 0.1;
                        baseFlowRate[0] = diff < 0.8 ? 0.3 : 0.2;
                    } else if (diff > 1.1) {
                        baseFlowRate[2] = diff < 1.2 ? 0.2 : 0.3;
                        baseFlowRate[0] = 0.1;
                    } else if (diff > 0.95 && diff < 1.05) {
                        baseFlowRate[2] = 0.1;
                        baseFlowRate[0] = 0.1;
                    } else {
                        baseFlowRate[2] = 0.15;
                        baseFlowRate[0] = 0.15;
                    }
                    if (upLimitBidFee != null && feeType != null && feeType == 1) {
                        baseFlowRate[2] = 0.1;
                        baseFlowRate[0] = 0.05;
                    }
                }
                baseFlowRate[1] = DataUtil.formatDouble((Double)(1.0 - baseFlowRate[0] - baseFlowRate[2]), (int)3);
                for (int i = 1; i < AdxLevel.values().length; ++i) {
                    lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                    lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String((Integer)i));
                }
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double price = baseValue * stepList[i - 1];
                Double flowRate = baseFlowRate[i - 1];
                Double lastRoi = lastRealRoi[i - 1];
                Double lastSucRate = lastRealSucRate[i - 1];
                priceMap.put(key, DataUtil.double2Long((Double)price));
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
                lastSucRateMap.put(key, lastSucRate);
            }
            ret.setPriceExploreMap(priceMap);
            ret.setPriceFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setUpLimitBidFee(upLimitBidFee);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("PriceExploration.getExplorePrice error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setDefaultPrice(1400L);
            adxRoiControlDoInfo1.setMinPrice(1000L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setStrategy("1");
            adxRoiControlDoInfo1.setLastMinRoi(1.2);
            adxRoiControlDoInfo1.setMinRoi(1.2);
            HashMap<String, Long> ideaIndexMap1 = new HashMap<String, Long>();
            ideaIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            ideaIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            ideaIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            ideaIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            ideaIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800000000L);
            ideaIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);
            HashMap<String, Long> resourceIndexMap1 = new HashMap<String, Long>();
            resourceIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            resourceIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            resourceIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            resourceIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            resourceIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800000000L);
            resourceIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);
            adxRoiControlDoInfo1.setIdeaIndexMap(ideaIndexMap1);
            adxRoiControlDoInfo1.setResourceIndexMap(resourceIndexMap1);
            String str = "{\"adxRoiFactorDo\":{\"advertConsumeDay\":3601.0,\"advertConsumeMs\":80.0,\"adxConsumeDay\":2740.82,\"adxConsumeMs\":0.49,\"adxRoiFactor\":0.70664,\"bidCntDay\":18584,\"bidCntMs\":2822,\"lastRealRoi\":2.971416,\"roiDay\":1.313844,\"roiMs\":2.971416,\"sucBidCntDay\":2896,\"sucBidCntMs\":0,\"sucDay\":0.155833,\"sucMs\":0.0},\"basePrice\":1200.0,\"defaultPrice\":1800,\"factorExplorationDo\":{\"advertConsumeDay\":787.0,\"advertConsumeMs\":164.0,\"adxConsumeDay\":507.79,\"adxConsumeMs\":106.04,\"bidCntDay\":15257,\"bidCntMs\":2924,\"factorExploreMap\":{\"1\":0.785403,\"2\":0.950402,\"3\":0.970402},\"factorFlowRateMap\":{\"1\":0.2,\"2\":0.601,\"3\":0.2},\"lastRealRoiMap\":{\"1\":0.623951,\"2\":5.055842,\"3\":1.380182},\"lastSucRateMap\":{\"1\":0.219967,\"2\":0.002294,\"3\":0.003396},\"roiDay\":1.549863,\"roiMs\":1.546616,\"sucBidCntDay\":583,\"sucBidCntMs\":136,\"sucDay\":0.038212,\"sucMs\":0.046512,\"tryLabel\":1},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":991,\"advertConsume\":531,\"adxConsume\":7206210000,\"bid\":8635,\"exp\":942,\"click\":163},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":3601.0,\"advertConsumeMs\":80.0,\"adxConsumeDay\":2740.82,\"adxConsumeMs\":0.49,\"adxRoiFactor\":0.70664,\"bidCntDay\":18584,\"bidCntMs\":2822,\"lastRealRoi\":2.971416,\"roiDay\":1.313844,\"roiMs\":2.971416,\"sucBidCntDay\":2896,\"sucBidCntMs\":0,\"sucDay\":0.155833,\"sucMs\":0.0},\"lastFactorExplorationDo\":{\"advertConsumeDay\":787.0,\"advertConsumeMs\":164.0,\"adxConsumeDay\":507.79,\"adxConsumeMs\":106.04,\"bidCntDay\":15257,\"bidCntMs\":2924,\"factorExploreMap\":{\"1\":0.785403,\"2\":0.950402,\"3\":0.970402},\"factorFlowRateMap\":{\"1\":0.2,\"2\":0.601,\"3\":0.2},\"lastRealRoiMap\":{\"1\":0.623951,\"2\":5.055842,\"3\":1.380182},\"lastSucRateMap\":{\"1\":0.219967,\"2\":0.002294,\"3\":0.003396},\"roiDay\":1.549863,\"roiMs\":1.546616,\"sucBidCntDay\":583,\"sucBidCntMs\":136,\"sucDay\":0.038212,\"sucMs\":0.046512,\"tryLabel\":1},\"lastMinRoi\":1.4,\"lastPriceExplorationDo\":{\"advertConsumeDay\":9256.0,\"advertConsumeMs\":1190.0,\"adxConsumeDay\":8186.55,\"adxConsumeMs\":1066.9,\"bidCntDay\":15095,\"bidCntMs\":2912,\"lastRealRoiMap\":{\"1\":1.418191,\"2\":1.376076,\"3\":1.349036},\"lastSucRateMap\":{\"1\":0.484849,\"2\":0.467099,\"3\":0.542977},\"priceExploreMap\":{\"1\":1187,\"2\":1290,\"3\":1316},\"priceFlowRateMap\":{\"1\":0.3,\"2\":0.6,\"3\":0.1},\"roiDay\":1.130636,\"roiMs\":1.115392,\"sucBidCntDay\":8654,\"sucBidCntMs\":1404,\"sucDay\":0.573303,\"sucMs\":0.482143,\"tryLabel\":0},\"maxPrice\":4500,\"minPrice\":100,\"minRoi\":1.4,\"priceExplorationDo\":{\"advertConsumeDay\":9256.0,\"advertConsumeMs\":1190.0,\"adxConsumeDay\":8186.55,\"adxConsumeMs\":1066.9,\"bidCntDay\":15095,\"bidCntMs\":2912,\"lastRealRoiMap\":{\"1\":1.418191,\"2\":1.376076,\"3\":1.349036},\"lastSucRateMap\":{\"1\":0.484849,\"2\":0.467099,\"3\":0.542977},\"priceExploreMap\":{\"1\":1187,\"2\":1290,\"3\":1316},\"priceFlowRateMap\":{\"1\":0.3,\"2\":0.6,\"3\":0.1},\"roiDay\":1.130636,\"roiMs\":1.115392,\"sucBidCntDay\":8654,\"sucBidCntMs\":1404,\"sucDay\":0.573303,\"sucMs\":0.482143,\"tryLabel\":0},\"resourceIndexMap\":{\"bidSuc\":40132,\"advertConsume\":39897,\"adxConsume\":408470480000,\"bid\":93925,\"exp\":37565,\"click\":7862},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":2896,\"advertConsume\":3601,\"adxConsume\":27408150000,\"bid\":18712,\"exp\":2711,\"click\":521}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":1761,\"advertConsume\":2304,\"adxConsume\":15853380000,\"bid\":3966,\"exp\":1662,\"click\":308}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":6763,\"advertConsume\":6252,\"adxConsume\":62875290000,\"bid\":12082,\"exp\":6333,\"click\":1229}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":1120,\"advertConsume\":1231,\"adxConsume\":10318360000,\"bid\":1969,\"exp\":1054,\"click\":203}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":403,\"advertConsume\":500,\"adxConsume\":3229700000,\"bid\":3229,\"exp\":381,\"click\":65}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":178,\"advertConsume\":287,\"adxConsume\":1863030000,\"bid\":11523,\"exp\":165,\"click\":32}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":2,\"advertConsume\":0,\"adxConsume\":3590000,\"bid\":3407,\"exp\":2,\"click\":0}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":80,\"adxConsume\":4810000,\"bid\":2810,\"exp\":1,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":4,\"advertConsume\":30,\"adxConsume\":24390000,\"bid\":811,\"exp\":4,\"click\":1}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":829,\"advertConsume\":400,\"adxConsume\":6003870000,\"bid\":1778,\"exp\":786,\"click\":131}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":168,\"advertConsume\":131,\"adxConsume\":1249670000,\"bid\":333,\"exp\":159,\"click\":30}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":25,\"adxConsume\":13520000,\"bid\":581,\"exp\":1,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":59,\"adxConsume\":4930000,\"bid\":1701,\"exp\":1,\"click\":1}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":1430000,\"bid\":568,\"exp\":1,\"click\":0}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastPriceExplorationDo()));
            AdxPriceExplorationDo ret2 = PriceExploration.getExplorePrice(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

