/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxPriceExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceExploration {
    private static final Logger logger = LoggerFactory.getLogger(PriceExploration.class);

    public static AdxPriceExplorationDo getExplorePrice(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxPriceExplorationDo ret = new AdxPriceExplorationDo();
        try {
            Double defaultPrice = 10.0;
            Double defaultMinRoi = 1.0;
            Double[] stepList = new Double[]{0.95, 1.0, 1.05};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3};
            Double baseValue = defaultPrice;
            Double[] baseFlowRate = new Double[]{0.2, 0.6, 0.2};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0};
            Double[] lastRealSucRate = new Double[]{0.0, 0.0, 0.0};
            HashMap<String, Double> priceMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastSucRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            Long tryLabel = 0L;
            Double upLimitBidFee = null;
            Long lastTryLabel = 0L;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategySecMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategySecDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategySecMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategySecMs, minRoi);
                Map<String, Double> roiLevelMs = StrategyBid.getRoiPriceRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);
                roiMs = StrategyBid.getRoi(strategySecMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategySecMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategySecDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategySecDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                defaultPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(), 10L));
                Double minPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinPrice(), 1L));
                Double maxPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMaxPrice(), DataUtil.double2Long((Double)defaultPrice) + 1L));
                Double basePrice = adxRoiControlDoInfo.getBasePrice();
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                if (bidCntMs == 0L) {
                    tryLabel = 2L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < 2000000000L) {
                    tryLabel = 1L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 2000000000L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < minRoi * 0.95) {
                    tryLabel = 1L;
                }
                baseValue = defaultPrice;
                Double lowValue = baseValue * 0.95;
                Double uppValue = baseValue * 1.05;
                Double diff = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || bidCntDay == 0L) {
                    baseValue = defaultPrice;
                } else {
                    Object uppSuc;
                    Double incre1 = 1.0;
                    AdxPriceExplorationDo lastPriceDoInfo = adxRoiControlDoInfo.getLastPriceExplorationDo();
                    if (AssertUtil.isNotEmpty((Object)lastPriceDoInfo)) {
                        Map<String, Double> lastPriceMap = lastPriceDoInfo.getPriceExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        lastTryLabel = lastPriceDoInfo.getTryLabel();
                        if (AssertUtil.isNotEmpty(lastPriceMap)) {
                            if (lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                baseValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                lowValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                                uppValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                            }
                            upLimitBidFee = StrategyBid.selectUpLimitFee(lastPriceMap, sucRateLevelMs, lastPriceDoInfo.getUpLimitBidFee());
                            if (lastPriceMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division((Double)lastPriceMap.get(bestLevel), (Double)baseValue, (int)3);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double baseDiff = DataUtil.division((Double)baseValue, (Double)defaultPrice) - 1.0;
                        baseValue = baseValue - defaultPrice * baseDiff * 0.2;
                    } else {
                        Double weight1 = 1.0;
                        weight1 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0)));
                        Double incre2 = 1.0;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((Double)roiMs, (Double)(minRoi * 0.98), (int)3);
                            if (upLimitBidFee != null && feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.98);
                                incre2 = DataUtil.division((Double)roiStable, (Double)(minRoi * 0.98), (int)3);
                            }
                            Double weight2 = 1.0;
                            weight2 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                            Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                            incre1 = StrategyBid.getNormalValue(incre1, 1.0, 0.9, 1.1);
                            incre2 = StrategyBid.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
                            Double incre = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
                            if (weight1 == 0.0 || diff > 1.3) {
                                incre = 1.0 + (incre2 - 1.0) * weight2;
                            }
                            Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);
                            if (tryLabel == 0L) {
                                Double MojiRoiLimit = StrategyBid.getMojiRoiLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                                baseValue = upLimitBidFee != null && feeType != null && feeType == 1 ? (StrategyBid.getBaseLevelConfident(resoSucRateMs, sucRateLevelMs, adxConsumeLevelMs) == 1L && roiMs >= minRoi * MojiRoiLimit && roiMs <= minRoi ? Double.valueOf(Math.max(upLimitBidFee, baseValue)) : StrategyBid.getNormalValue(baseValue * incre, defaultPrice, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff))) : StrategyBid.getNormalValue(baseValue * incre, defaultPrice, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff));
                            }
                            if (lastTryLabel == 1L && tryLabel == 0L) {
                                baseValue = uppValue;
                            }
                            if (basePrice != null && basePrice > 0.0 && diff > 1.3) {
                                baseValue = Math.max(basePrice, baseValue);
                            }
                            if (upLimitBidFee != null && feeType != null && feeType == 1) {
                                if (lastTryLabel == 1L && tryLabel == 1L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) > minRoi * 0.95) {
                                    baseValue = uppValue;
                                }
                                baseValue = Math.min(upLimitBidFee, baseValue);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double uppDiff = DataUtil.division((Double)uppValue, (Double)defaultPrice) - 1.0;
                        stepList[2] = DataUtil.division((Double)(uppValue - defaultPrice * uppDiff * 0.2), (Double)baseValue);
                        Double lowDiff = DataUtil.division((Double)lowValue, (Double)defaultPrice) - 1.0;
                        stepList[0] = DataUtil.division((Double)(lowValue - defaultPrice * lowDiff * 0.2), (Double)baseValue);
                    } else if (tryLabel == 1L) {
                        stepList[0] = DataUtil.division((Double)lowValue, (Double)baseValue);
                        uppSuc = DataUtil.division((Double)sucRateLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)Math.max(resoSucRateMs, 0.1), (int)3);
                        Double stepSuc = (Double)uppSuc < 0.1 ? 0.1 : ((Double)uppSuc < 0.3 ? 0.08 : ((Double)uppSuc < 0.5 ? 0.05 : ((Double)uppSuc < 0.7 ? -0.05 : ((Double)uppSuc < 0.9 ? -0.08 : -0.1))));
                        Double uppDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)minRoi, (int)3);
                        Double stepRoi = uppDiff < 0.8 ? -0.08 : (uppDiff < 0.95 ? -0.06 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? 0.06 : 0.08)));
                        if (adxConsumeMs == 0.0) {
                            stepSuc = 0.1;
                            stepRoi = 0.1;
                        }
                        stepList[2] = Math.max(DataUtil.division((Double)uppValue, (Double)baseValue) + 0.5 * stepSuc + 0.5 * stepRoi, 1.0);
                    } else {
                        uppSuc = stepList;
                        Double.valueOf(uppSuc[2] + (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
                        uppSuc = stepList;
                        Double.valueOf((Double)uppSuc[0] - (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
                    }
                    if (upLimitBidFee != null) {
                        stepList[2] = Math.min(stepList[2], DataUtil.division((Double)upLimitBidFee, (Double)baseValue));
                    }
                    if (basePrice != null && basePrice > 0.0) {
                        stepList[2] = Math.max(stepList[2], DataUtil.division((Double)basePrice, (Double)baseValue));
                    }
                    if (tryLabel == 2L) {
                        baseFlowRate[2] = 0.2;
                        baseFlowRate[0] = 0.2;
                    } else if (tryLabel == 1L) {
                        Double tryDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)minRoi, (int)3);
                        baseFlowRate[2] = StrategyBid.getTryFlowRate(tryDiff, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                        baseFlowRate[0] = 0.2;
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {
                            baseFlowRate[2] = StrategyBid.getMojiTryFlowRate(roiDay, roiMs, minRoi, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                            baseFlowRate[0] = 0.0;
                        }
                    } else {
                        if (diff < 0.9) {
                            baseFlowRate[2] = 0.1;
                            baseFlowRate[0] = diff < 0.8 ? 0.3 : 0.2;
                        } else if (diff > 1.1) {
                            baseFlowRate[2] = diff < 1.2 ? 0.2 : 0.3;
                            baseFlowRate[0] = 0.1;
                        } else if (diff > 0.95 && diff < 1.05) {
                            baseFlowRate[2] = 0.1;
                            baseFlowRate[0] = 0.1;
                        } else {
                            baseFlowRate[2] = 0.15;
                            baseFlowRate[0] = 0.15;
                        }
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {
                            baseFlowRate[2] = StrategyBid.getMojiNormalFlowRate(roiDay, roiMs, minRoi, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                            baseFlowRate[0] = 0.0;
                        }
                    }
                    baseFlowRate[1] = DataUtil.formatDouble((Double)(1.0 - baseFlowRate[0] - baseFlowRate[2]), (int)3);
                    for (int i = 1; i < AdxLevel.values().length; ++i) {
                        lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                        lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String((Integer)i));
                        if (tryLabel != 1L) continue;
                        lastRealRoi[i - 1] = roiRealLevelMs.get(DataUtil.Integer2String((Integer)i));
                    }
                }
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double price = DataUtil.formatDouble((Double)(baseValue * stepList[i - 1]), (int)3);
                Double flowRate = DataUtil.formatDouble((Double)baseFlowRate[i - 1], (int)3);
                Double lastRoi = lastRealRoi[i - 1];
                Double lastSucRate = lastRealSucRate[i - 1];
                priceMap.put(key, price);
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
                lastSucRateMap.put(key, lastSucRate);
            }
            ret.setPriceExploreMap(priceMap);
            ret.setPriceFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setUpLimitBidFee(upLimitBidFee);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("PriceExploration.getExplorePrice error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setDefaultPrice(1400L);
            adxRoiControlDoInfo1.setMinPrice(1000L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setStrategy("1");
            adxRoiControlDoInfo1.setLastMinRoi(1.2);
            adxRoiControlDoInfo1.setMinRoi(1.2);
            HashMap<String, Long> ideaIndexMap1 = new HashMap<String, Long>();
            ideaIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            ideaIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            ideaIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            ideaIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            ideaIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800000000L);
            ideaIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);
            HashMap<String, Long> resourceIndexMap1 = new HashMap<String, Long>();
            resourceIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            resourceIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            resourceIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            resourceIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            resourceIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800000000L);
            resourceIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);
            adxRoiControlDoInfo1.setIdeaIndexMap(ideaIndexMap1);
            adxRoiControlDoInfo1.setResourceIndexMap(resourceIndexMap1);
            String str = "{\"adxFlowRateDo\":{\"firFlowRate\":0.243,\"roiDiffDayList\":[0.539,0.637,0.506],\"roiDiffMsList\":[1.0,1.26,0.368],\"scoreList\":[-0.073,-0.016,-0.139],\"secFlowRate\":0.335,\"sucRateDayList\":[0.266,0.536,0.303],\"sucRateMsList\":[0.002,0.947,0.295],\"thiFlowRate\":0.423},\"adxRoiFactorDo\":{\"advertConsumeDay\":466.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":623.0,\"adxConsumeMs\":5.0,\"adxRoiFactor\":0.720026,\"bidCntDay\":10652,\"bidCntMs\":722,\"lastRealRoi\":1.272728,\"roiDay\":0.747994,\"roiMs\":1.272728,\"sucBidCntDay\":2642,\"sucBidCntMs\":19,\"sucDay\":0.248029,\"sucMs\":0.026316},\"basePrice\":1000.0,\"defaultPrice\":1000,\"factorExplorationDo\":{\"advertConsumeDay\":640.0,\"advertConsumeMs\":51.0,\"adxConsumeDay\":904.0,\"adxConsumeMs\":87.0,\"bidCntDay\":12546,\"bidCntMs\":1505,\"factorExploreMap\":{\"1\":0.88277,\"2\":0.90277,\"3\":1.00277},\"factorFlowRateMap\":{\"1\":0.101,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.707589,\"2\":0.728572,\"3\":0.749556},\"lastSucRateMap\":{\"1\":0.301283,\"2\":0.27764,\"3\":0.226028},\"roiDay\":0.707965,\"roiMs\":0.586208,\"sucBidCntDay\":3790,\"sucBidCntMs\":414,\"sucDay\":0.302089,\"sucMs\":0.275084,\"tryLabel\":0},\"feeType\":1,\"ideaIndexMap\":{\"bidSuc\":1122,\"advertConsume\":130,\"adxConsume\":3240000000,\"bid\":3178,\"exp\":324,\"click\":12},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":466.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":623.0,\"adxConsumeMs\":5.0,\"adxRoiFactor\":0.720026,\"bidCntDay\":10652,\"bidCntMs\":722,\"lastRealRoi\":1.272728,\"roiDay\":0.747994,\"roiMs\":1.272728,\"sucBidCntDay\":2642,\"sucBidCntMs\":19,\"sucDay\":0.248029,\"sucMs\":0.026316},\"lastFactorExplorationDo\":{\"advertConsumeDay\":640.0,\"advertConsumeMs\":51.0,\"adxConsumeDay\":904.0,\"adxConsumeMs\":87.0,\"bidCntDay\":12546,\"bidCntMs\":1505,\"factorExploreMap\":{\"1\":0.88277,\"2\":0.90277,\"3\":1.00277},\"factorFlowRateMap\":{\"1\":0.101,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.707589,\"2\":0.728572,\"3\":0.749556},\"lastSucRateMap\":{\"1\":0.301283,\"2\":0.27764,\"3\":0.226028},\"roiDay\":0.707965,\"roiMs\":0.586208,\"sucBidCntDay\":3790,\"sucBidCntMs\":414,\"sucDay\":0.302089,\"sucMs\":0.275084,\"tryLabel\":0},\"lastMinRoi\":1.4,\"lastPriceExplorationDo\":{\"advertConsumeDay\":1123.0,\"advertConsumeMs\":312.0,\"adxConsumeDay\":1260.46,\"adxConsumeMs\":170.0,\"bidCntDay\":9179,\"bidCntMs\":706,\"lastRealRoiMap\":{\"1\":2.290415,\"2\":2.244606,\"3\":2.244606},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.946181,\"3\":0.961539},\"priceExploreMap\":{\"1\":980.0,\"2\":1000.0,\"3\":1000.0},\"priceFlowRateMap\":{\"1\":0.0,\"2\":0.797,\"3\":0.205},\"roiDay\":0.890952,\"roiMs\":1.835295,\"sucBidCntDay\":4917,\"sucBidCntMs\":670,\"sucDay\":0.53568,\"sucMs\":0.949009,\"tryLabel\":0,\"upLimitBidFee\":1000.0},\"maxPrice\":1100,\"minPrice\":200,\"minRoi\":1.4,\"priceExplorationDo\":{\"advertConsumeDay\":1123.0,\"advertConsumeMs\":312.0,\"adxConsumeDay\":1260.46,\"adxConsumeMs\":170.0,\"bidCntDay\":9179,\"bidCntMs\":706,\"lastRealRoiMap\":{\"1\":2.290415,\"2\":2.244606,\"3\":2.244606},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.946181,\"3\":0.961539},\"priceExploreMap\":{\"1\":980.0,\"2\":1000.0,\"3\":1000.0},\"priceFlowRateMap\":{\"1\":0.0,\"2\":0.797,\"3\":0.205},\"roiDay\":0.890952,\"roiMs\":1.835295,\"sucBidCntDay\":4917,\"sucBidCntMs\":670,\"sucDay\":0.53568,\"sucMs\":0.949009,\"tryLabel\":0,\"upLimitBidFee\":1000.0},\"resourceIndexMap\":{\"bidSuc\":5950,\"advertConsume\":1517,\"adxConsume\":15010000000,\"bid\":8609,\"exp\":1501,\"click\":56},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":2642,\"advertConsume\":466,\"adxConsume\":6230000000,\"bid\":10652,\"exp\":623,\"click\":20}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":3845,\"advertConsume\":727,\"adxConsume\":9960000000,\"bid\":8076,\"exp\":996,\"click\":26}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":2129,\"advertConsume\":526,\"adxConsume\":5504500000,\"bid\":2225,\"exp\":549,\"click\":19}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":1206,\"advertConsume\":204,\"adxConsume\":3050000000,\"bid\":4311,\"exp\":305,\"click\":10}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":2544,\"advertConsume\":332,\"adxConsume\":6240000000,\"bid\":7080,\"exp\":624,\"click\":16}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":194,\"advertConsume\":104,\"adxConsume\":450000000,\"bid\":2627,\"exp\":45,\"click\":2}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":15,\"advertConsume\":0,\"adxConsume\":50000000,\"bid\":721,\"exp\":5,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":780,\"advertConsume\":90,\"adxConsume\":2110000000,\"bid\":829,\"exp\":211,\"click\":8}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":200,\"advertConsume\":40,\"adxConsume\":520000000,\"bid\":208,\"exp\":52,\"click\":4}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":20,\"advertConsume\":0,\"adxConsume\":80000000,\"bid\":136,\"exp\":8,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":58,\"advertConsume\":0,\"adxConsume\":400000000,\"bid\":819,\"exp\":40,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":15,\"advertConsume\":0,\"adxConsume\":70000000,\"bid\":396,\"exp\":7,\"click\":0}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastPriceExplorationDo()));
            AdxPriceExplorationDo ret2 = PriceExploration.getExplorePrice(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

