/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.cpcautobidding;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBiddingInfo;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBiddingParams;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBiddingResult;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpcAutoBidding {
    private static final Logger logger = LoggerFactory.getLogger(CpcAutoBidding.class);

    public static CpcAutoBiddingResult cpcAutoBidding(CpcAutoBiddingInfo cpcAutoBiddingInfo, CpcAutoBiddingResult lastCpcAutoBiddingResult, CpcAutoBiddingParams cpcAutoBiddingParams) {
        CpcAutoBiddingResult ret = new CpcAutoBiddingResult();
        if (AssertUtil.isEmpty((Object)cpcAutoBiddingInfo)) {
            return ret;
        }
        if (Math.random() < 0.001) {
            logger.info("params cpcAutoBiddingParams:{}", (Object)cpcAutoBiddingParams);
        }
        try {
            ret = CpcAutoBidding.getRankScroreRatio(cpcAutoBiddingInfo);
        }
        catch (Exception e) {
            logger.warn("getRankScroreRatio happend error,cpcAutoBiddingInfo={}", (Object)JSON.toJSONString((Object)cpcAutoBiddingInfo), (Object)e);
        }
        if (lastCpcAutoBiddingResult != null) {
            ret.setCpcAutoBiddingFactor(lastCpcAutoBiddingResult.cpcAutoBiddingFactor);
        }
        if (cpcAutoBiddingInfo.autoBiddingType == 1) {
            CpcAutoBidding.updateFactor1(ret, cpcAutoBiddingParams);
        }
        if (cpcAutoBiddingInfo.autoBiddingType == 2) {
            CpcAutoBidding.updateFactor2(ret, cpcAutoBiddingParams);
        }
        if (Math.random() < 0.001) {
            logger.info("cpcAutoBidding cpcAutoBiddingFactor:{}", (Object)ret.cpcAutoBiddingFactor);
        }
        return ret;
    }

    public static CpcAutoBiddingResult getRankScroreRatio(CpcAutoBiddingInfo cpcAutoBiddingInfo) {
        CpcAutoBiddingResult ret = new CpcAutoBiddingResult();
        Double rankScroreRatio = 1.0;
        Double costConvert = 1.0;
        Double orientCostConvertToday = cpcAutoBiddingInfo.orientConvertToday != 0L ? (double)cpcAutoBiddingInfo.orientCostToday.longValue() / (double)cpcAutoBiddingInfo.orientConvertToday.longValue() : (double)cpcAutoBiddingInfo.orientCostToday.longValue();
        Double orientCostConvertBias = cpcAutoBiddingInfo.target != 0L ? orientCostConvertToday / (double)cpcAutoBiddingInfo.target.longValue() : 1.0;
        Double orientCostConvertHour = cpcAutoBiddingInfo.orientConvertHour != 0L ? (double)cpcAutoBiddingInfo.orientCostHour.longValue() / (double)cpcAutoBiddingInfo.orientConvertHour.longValue() : (double)cpcAutoBiddingInfo.orientCostHour.longValue();
        Double orientCostConvertHourBias = cpcAutoBiddingInfo.target != 0L ? orientCostConvertToday / (double)cpcAutoBiddingInfo.target.longValue() : 1.0;
        Double orientAppCostConvertToday = cpcAutoBiddingInfo.orientAppConvertToday != 0L ? (double)cpcAutoBiddingInfo.orientAppCostToday.longValue() / (double)cpcAutoBiddingInfo.orientAppConvertToday.longValue() : (double)cpcAutoBiddingInfo.orientAppCostToday.longValue();
        Double orientAppCostConvertBias = cpcAutoBiddingInfo.target != 0L ? orientCostConvertToday / (double)cpcAutoBiddingInfo.target.longValue() : 1.0;
        Double orientAppCostConvertHour = cpcAutoBiddingInfo.orientAppConvertHour != 0L ? (double)cpcAutoBiddingInfo.orientAppCostHour.longValue() / (double)cpcAutoBiddingInfo.orientAppConvertHour.longValue() : (double)cpcAutoBiddingInfo.orientAppCostHour.longValue();
        Double orientAppCostConvertHourBias = cpcAutoBiddingInfo.target != 0L ? orientCostConvertToday / (double)cpcAutoBiddingInfo.target.longValue() : 1.0;
        Double orientRankScoreRatio = cpcAutoBiddingInfo.orientRankScore10 != 0.0 ? cpcAutoBiddingInfo.orientRankScore9 / cpcAutoBiddingInfo.orientRankScore10 : 1.0;
        Double orientHourRankScoreRatio = cpcAutoBiddingInfo.orientHourRankScore10 != 0.0 ? cpcAutoBiddingInfo.orientHourRankScore9 / cpcAutoBiddingInfo.orientHourRankScore10 : 1.0;
        Double orientAppRankScoreRatio = cpcAutoBiddingInfo.orientAppRankScore10 != 0.0 ? cpcAutoBiddingInfo.orientAppRankScore9 / cpcAutoBiddingInfo.orientAppRankScore10 : 1.0;
        Double orientAppHourRankScoreRatio = cpcAutoBiddingInfo.orientAppHourRankScore10 != 0.0 ? cpcAutoBiddingInfo.orientAppHourRankScore9 / cpcAutoBiddingInfo.orientAppHourRankScore10 : 1.0;
        rankScroreRatio = cpcAutoBiddingInfo.orientAppBiddingCntHour > 1000L ? orientAppHourRankScoreRatio : (cpcAutoBiddingInfo.orientAppBiddingCntToday > 1000L && cpcAutoBiddingInfo.orientAppBiddingCntHour < 1000L ? orientAppRankScoreRatio : orientHourRankScoreRatio);
        ret.setRankScroreRatio(rankScroreRatio);
        ret.setCostConvert(costConvert);
        return ret;
    }

    public static void updateFactor1(CpcAutoBiddingResult cpcAutoBiddingResult, CpcAutoBiddingParams cpcAutoBiddingParams) {
        Double rankScroreRatio;
        Double ret = 1.0;
        Double totalLearnRate = cpcAutoBiddingParams.totalLearnRate1;
        Double fatorLowerLimit = cpcAutoBiddingParams.fatorLowerLimit1;
        Double fatorUpperLimit = cpcAutoBiddingParams.fatorUpperLimit1;
        Double rankScroreRatioLimit = cpcAutoBiddingParams.rankScroreRatioLimit;
        if (cpcAutoBiddingResult == null) {
            return;
        }
        Double CpcAutoBiddingFactor = cpcAutoBiddingResult.getCpcAutoBiddingFactor();
        if (CpcAutoBiddingFactor == null) {
            ret = 1.0;
        }
        if ((rankScroreRatio = cpcAutoBiddingResult.rankScroreRatio) >= rankScroreRatioLimit) {
            Double totalFactor1 = MathBase.noiseSmoother(rankScroreRatio, 0.2, 1.0);
            Double totalFactor = totalLearnRate + totalFactor1;
            ret = CpcAutoBiddingFactor * totalFactor;
            ret = MathBase.noiseSmoother(ret, 0.5, fatorUpperLimit);
        }
        ret = DataUtil.formatDouble((Double)ret, (int)4);
        cpcAutoBiddingResult.setCpcAutoBiddingFactor(ret);
    }

    public static void updateFactor2(CpcAutoBiddingResult cpcAutoBiddingResult, CpcAutoBiddingParams cpcAutoBiddingParams) {
        Double ret = 1.0;
        Double totalLearnRate = cpcAutoBiddingParams.totalLearnRate2;
        Double fatorLowerLimit = cpcAutoBiddingParams.fatorLowerLimit2;
        Double fatorUpperLimit = cpcAutoBiddingParams.fatorUpperLimit2;
        Double rankScroreRatioLimit = cpcAutoBiddingParams.rankScroreRatioLimit;
        Double costConvertLimit = cpcAutoBiddingParams.costConvertLimit;
        if (cpcAutoBiddingResult == null) {
            return;
        }
        Double CpcAutoBiddingFactor = cpcAutoBiddingResult.getCpcAutoBiddingFactor();
        if (CpcAutoBiddingFactor == null) {
            ret = 1.0;
        }
        Double rankScroreRatio = cpcAutoBiddingResult.rankScroreRatio;
        Double costConvert = cpcAutoBiddingResult.costConvert;
        if (rankScroreRatio >= rankScroreRatioLimit && costConvert < costConvertLimit) {
            Double totalFactor1 = MathBase.noiseSmoother(rankScroreRatio * costConvert, 0.2, 1.0);
            Double totalFactor = totalLearnRate + totalFactor1;
            ret = CpcAutoBiddingFactor * totalFactor;
            ret = MathBase.noiseSmoother(ret, 0.5, fatorUpperLimit);
        }
        ret = DataUtil.formatDouble((Double)ret, (int)4);
        cpcAutoBiddingResult.setCpcAutoBiddingFactor(ret);
    }
}

