package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.params.AdxIdeaRcmdParam;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxResourceRcmdDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdxIdeaDQNRcmder {

    private static final Logger logger = LoggerFactory.getLogger(AdxIdeaDQNRcmder.class);

    private static int MAP_DF_SIZE = 8;

    /**
     * 创意推荐2.0
     *
     * @param adxIdeaRcmdParam
     * @return
     * @throws Exception
     */
    public static AdxIdeaFeatureDo ideaRcmd(AdxIdeaRcmdParam adxIdeaRcmdParam) throws Exception {

        AdxIdeaFeatureDo ret = null;


        /**
         * 校验基础信息是否非法
         */
        if (valid(adxIdeaRcmdParam)) {


            /**
             * 参数
             */
            List<AdxIdeaFeatureDo> ideaFeatureDoList = adxIdeaRcmdParam.getIdeaFeatureList();
            AdxFeatureDo adxFeatureDo = adxIdeaRcmdParam.getAdxFeatureDo();
            AdxResourceRcmdDo adxResourceRcmdDo = adxIdeaRcmdParam.getAdxResourceRcmdDo();
            CODER coderModel = adxIdeaRcmdParam.getCoderModel();
            LocalTFModel ltfModel = adxIdeaRcmdParam.getLtfModel();


            /**
             * 校验预估模型是否非法
             */
            if (!validModel(adxIdeaRcmdParam)) {


                /**
                 * 创意推荐1 降级 统计模型
                 */

                logger.warn("AdxIdeaDQNRcmder.rcmd() input invalid,降级 统计模型");

                List<Long> ideaList = new ArrayList<>();

                for (AdxIdeaFeatureDo ideaDo : ideaFeatureDoList) {
                    Long ideaId = ideaDo.getIdeaId();
                    ideaList.add(ideaId);
                }

                Long ideaId = AdxIdeaRcmder.ideaRcmd(ideaList, adxResourceRcmdDo);

                ret = new AdxIdeaFeatureDo();

                ret.setIdeaId(ideaId);

                Double sRpm = null;

                if (adxResourceRcmdDo != null && adxResourceRcmdDo.getIdeaParamsMap() != null) {

                    AdxIdeaParamsDo adxIdeaParamsDo = adxResourceRcmdDo.getIdeaParamsMap().get(ideaId);

                    if (adxIdeaParamsDo != null) {
                        sRpm = adxIdeaParamsDo.getRpm();

                    }

                }

                ret.setSRpm(sRpm);

            } else {

                /**
                 * 创意推荐2
                 */


                //1 非创意特征解析
                Map<Long, Map<String, String>> featureMap = new HashMap<>();
                Map<String, String> staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo);
//                System.out.println("staticFeatureMap="+JSON.toJSONString(staticFeatureMap));

                //2 封装1 统计ROI、RPM

                for (AdxIdeaFeatureDo ideaDo : ideaFeatureDoList) {
                    Long ideaId = ideaDo.getIdeaId();
                    // 解析动态特征
                    AdxFeatureDo dynamicDo = new AdxFeatureDo();
                    dynamicDo.setIdeaId(ideaId);
                    dynamicDo.setButtonText(ideaDo.getButtonText()); // 按钮文字 f3010020
                    dynamicDo.setIconH(ideaDo.getIconH()); // 创意图标高 f3010030
                    dynamicDo.setIconW(ideaDo.getIconW()); // 创意图标宽 f3010040
                    dynamicDo.setMjPicType(ideaDo.getMjPicType()); // 规格类型 f3010050
                    dynamicDo.setIdeaPicH1(ideaDo.getIdeaPicH1()); // 创意图片高1 f3010060
                    dynamicDo.setIdeaPicW1(ideaDo.getIdeaPicW1()); // 创意图片宽1 f3010070
                    dynamicDo.setIdeaPicH2(ideaDo.getIdeaPicH2()); // 创意图片高2 f3010080
                    dynamicDo.setIdeaPicW2(ideaDo.getIdeaPicW2()); // 创意图片宽2 f3010090
                    dynamicDo.setIdeaPicH3(ideaDo.getIdeaPicH3()); // 创意图片高3 f3010100
                    dynamicDo.setIdeaPicW3(ideaDo.getIdeaPicW3()); // 创意图片宽3 f3010110
                    dynamicDo.setIdeaPicNum(ideaDo.getIdeaPicNum()); // 创意图片个数 f3010120
                    dynamicDo.setStyleStandard(ideaDo.getStyleStandard()); // 广告样式规格 f3010130

                    Map<String, String> dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic(dynamicDo, adxFeatureDo);
                    dynamicFeatureMap.putAll(staticFeatureMap);
                    // 封装特征
                    featureMap.put(ideaId, dynamicFeatureMap);
//                    System.out.println("feature="+JSON.toJSONString(featureMap));

                }

                //3 模型预估RPM
                Map<Long, Double> pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);


                //4 封装2 RPM 预估、统计、融合

                for (AdxIdeaFeatureDo ideaDo : ideaFeatureDoList) {
                    Long ideaId = ideaDo.getIdeaId();

                    // 预估RPM
                    Double pRpm = pRpmMap.get(ideaId);

                    // 统计RPM
                    Double sRpm = null;
                    AdxIdeaParamsDo adxIdeaParamsDo = null;
                    if (adxResourceRcmdDo!=null && adxResourceRcmdDo.getIdeaParamsMap() != null) {
                        adxIdeaParamsDo = adxResourceRcmdDo.getIdeaParamsMap().get(ideaId);
                        if (adxIdeaParamsDo != null) {
                            sRpm = adxIdeaParamsDo.getRpm();
                        }
                    }

                    // 融合RPM
                    Double mergeRpm = getMergeRpm(pRpm, sRpm);


                    //封装参数
                    ideaDo.setPRpm(pRpm);
                    ideaDo.setSRpm(sRpm);
                    ideaDo.setMergeRpm(mergeRpm);

                    ideaDo.setAdxIdeaParamsDo(adxIdeaParamsDo);


                }

                //5 推荐

                ret = rcmd(ideaFeatureDoList);

                if(ret!=null){
                    logger.info("pRpm="+ret.getPRpm()+",featureMap="+JSON.toJSONString(featureMap.get(ret.getIdeaId())));
                    System.out.println("featureMap="+JSON.toJSONString(featureMap.get(ret.getIdeaId())));
                }

            }
        }

        return ret;

    }

    /**
     * 推荐
     * @param ideaList
     * @return
     */
    public static AdxIdeaFeatureDo rcmd(List<AdxIdeaFeatureDo> ideaList) {


        AdxIdeaFeatureDo ret = null;

        long size = ideaList.size();

        //1 最优rpm 融合
        Double bestRpm = null;

        for (int i = 0; i < size; i++) {

            AdxIdeaFeatureDo ideaDo = ideaList.get(i);

            Double mergeRpm = ideaDo.getMergeRpm();
            if (mergeRpm != null) {
                if (bestRpm == null || bestRpm < mergeRpm) {
                    bestRpm = mergeRpm;
                }
            }
        }


        //2 概率分配
        Map<AdxIdeaFeatureDo, Double> weighMap = new HashMap<>(MAP_DF_SIZE);
        for (int i = 0; i < size; i++) {


            AdxIdeaFeatureDo adxIdeaFeatureDo = ideaList.get(i);

            AdxIdeaParamsDo adxIdeaParamsDo = adxIdeaFeatureDo.getAdxIdeaParamsDo();

            /**
             * 统计权重
             */
            Double sWeight = 1.0;

            if (adxIdeaParamsDo == null || adxIdeaParamsDo.getWeight() == null) {
                // 0 默认权重
                sWeight = 1.0;

            } else {
                // 1 统计权重
                sWeight = adxIdeaParamsDo.getWeight();

                // 2 未熔断  概率放弃
                if (adxIdeaParamsDo.isFused() == null || !adxIdeaParamsDo.isFused()) {

                    if (adxIdeaParamsDo.getGiveUpRatio() != null &&
                            adxIdeaParamsDo.getGiveUpRatio() >= 0 &&
                            Math.random() < adxIdeaParamsDo.getGiveUpRatio()) {
                        sWeight = null;
                    }
                }
                // 3 熔断 概率放弃
                if (adxIdeaParamsDo.isFused() != null && adxIdeaParamsDo.isFused()) {
                    if (Math.random() > 0.1) {
                        sWeight = null;
                    }
                }

            }

            /**
             * 预估融合权重
             */
            Double mergePpm = adxIdeaFeatureDo.getMergeRpm();
            Double mergeWeight = AdxIdeaBaseRcmder.getRpmWeight(mergePpm, bestRpm);

            if (mergeWeight == null) {
                mergeWeight = 1.0;
            }

            /**
             * 过滤熔断创意
             */
            if (sWeight != null) {
                weighMap.put(adxIdeaFeatureDo, mergeWeight);
            }
        }

//        System.out.println("weightMap=" + JSON.toJSONString(weighMap));

        //3 挑选
        ret = Roulette.doubleMap(weighMap);

        //4 返回
        return ret;
    }


    /**
     * 校验基础信息是否非法
     *
     * @param adxIdeaRcmdParam
     * @return
     */
    private static Boolean valid(AdxIdeaRcmdParam adxIdeaRcmdParam) {

        Boolean ret = true;

        if (adxIdeaRcmdParam == null) {
            logger.error("AdxIdeaDQNRcmder.rcmd() input params valid ,params adxIdeaRcmdParam is null");
            return false;
        }

        if (AssertUtil.isEmpty(adxIdeaRcmdParam.getIdeaFeatureList())) {
            logger.error("AdxIdeaDQNRcmder.rcmd() input params valid ,params ideaFeatureList is empty");
            return false;
        }

        if (adxIdeaRcmdParam.getAdxResourceRcmdDo() == null) {
            logger.warn("AdxIdeaDQNRcmder.rcmd() input params valid ,params adxResourceRcmdDo is null");
        }

        return ret;
    }


    /**
     * 校验预估模型是否非法
     *
     * @param adxIdeaRcmdParam
     * @return
     */
    private static Boolean validModel(AdxIdeaRcmdParam adxIdeaRcmdParam) {
        Boolean ret = true;

        if (adxIdeaRcmdParam == null) {
            logger.error("AdxIdeaDQNRcmder.rcmd() input params valid ,params adxIdeaRcmdParam is null");
            return false;
        }

        if (adxIdeaRcmdParam.getAdxFeatureDo() == null) {
            logger.error("AdxIdeaDQNRcmder.rcmd() input params valid ,params adxFeatureDo is null");
            return false;
        }

        if (adxIdeaRcmdParam.getCoderModel() == null) {
            logger.warn("AdxIdeaDQNRcmder.rcmd() input params valid ,params coderModel is null");

            return false;
        }

        if (adxIdeaRcmdParam.getLtfModel() == null) {
            logger.warn("AdxIdeaDQNRcmder.rcmd() input params valid ,params ltfModel is null");
            return false;
        }
        return ret;
    }


    /**
     * 权重融合
     *
     * @return
     */
    public static Double getMergeRpm(Double predRpm, Double statRpm) {
        Double ret = predRpm;


        if (predRpm != null && statRpm != null) {

            // 平滑限制预估与统计偏差范围[0.1～4]
            Double limitPredRpm = predRpm;
            if (statRpm >= 0) {
                limitPredRpm = MathBase.noiseSmoother(predRpm, 0.5 * statRpm, 2 * statRpm);
            } else {
                limitPredRpm = MathBase.noiseSmoother(predRpm, 2 * statRpm, 0.5 * statRpm);
            }

            ret = 0.05 * limitPredRpm + 0.95 * statRpm;
        }else{
            ret = statRpm;
        }
        return ret;
    }

}
