package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;




public class AdxAlgoBidding {



    /**
     * 算法最终出价
     *
     * @param adxDoInfo
     * @param adxRoiControlDoInfo
     * @return isCompareGroup, level, adxAlgoPrice（分/千次曝光)
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static Map<String, String> getAdxAlgoPrice(AdxDo adxDoInfo, AdxRoiControlDo adxRoiControlDoInfo) {

        Map<String, String> retMap = new HashMap<>();


        /**
         *
         * 步骤：
         * 步骤1、设置默认值
         * 步骤2、当前对象是否合法
         * 步骤3、当前数据是否合法
         * 步骤4、计算累计消耗，实时消耗
         * 步骤5、冷启动：走默认出价
         * 步骤6、根据strategy走策略1,2,3
         * 步骤7、最优出价约束
         *
         */


        try {

            //1、设置默认值
            Double defaultMinRoi = 1.00;              // 默认ROI
            Double defaultRoiFactor = 1.00;           // 默认ROI调节因子
            Double defaultPreCtr = 0.07;              // 默认ctr
            Double defaultStatClickValue = 0.05*100;  // 默认点击价值
            Long advertConsumeDayLimit = 5*100L;      // 创意当天广告消耗阈值（分）

            String isCompareGroup = "1";
            String level = AdxLevel.ADX_LEVEL_ZER.getCode();
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            Long adxAlgoPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000/(defaultMinRoi * defaultRoiFactor)));
            String adxControlInfo = "";


            //2、当前对象是否合法
            if (AssertUtil.isAllNotEmpty(adxDoInfo, adxRoiControlDoInfo)) {


                //3、当前数据是否合法

                //默认出价(分/cpm)
                Long defaultPrice = StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(),10L);
                //出价下限(分/cpm)(1分)
                Long minPrice = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinPrice(), 1L);
                //出价上限(分/cpm)(1分)
                Long maxPrice = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMaxPrice(), (DataUtil.toDouble(defaultPrice)+1));
                //底价(分/cpm)(可能为null/0)
                Double basePrice = adxRoiControlDoInfo.getBasePrice();
                //扣费方式：1:一价扣费，2:二价扣费
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                //策略-流量配比
                AdxFlowRateDo flowRate = adxRoiControlDoInfo.getAdxFlowRateDo();

                //全天累计-不同策略：分level-分指标-值
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyFirDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                List<AdxLevelDo> strategySecDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                List<AdxLevelDo> strategyThiDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());


                //4、计算广告消耗
                Long defaultConsume = 0L;
                Long ideaBidCntMs = 0L;
                Long ideaAdvertConsumeMs = 0L;
                Long resoAdvertConsumeMs = 0L;
                Map<String, Long> advertConsumeInfo = new HashMap<>();
                Map<String, Long> ideaMapInfo = adxRoiControlDoInfo.getIdeaIndexMap();
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();

                Long ideaAdvertConsumeDay =
                          StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume)
                        + StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume)
                        + StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);

                if (AssertUtil.isAllNotEmpty(ideaMapInfo, resoMapInfo)) {
                    ideaBidCntMs = StrategyBid.nullToDefault(ideaMapInfo.get(AdxIndex.BID.getCode()),0L);
                    ideaAdvertConsumeMs = StrategyBid.nullToDefault(ideaMapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()),defaultConsume);
                    resoAdvertConsumeMs = StrategyBid.nullToDefault(resoMapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()),defaultConsume);
                }

                advertConsumeInfo.put("ideaDay",ideaAdvertConsumeDay);     //创意维度-全天累计-广告消耗
                advertConsumeInfo.put("ideaMs", ideaAdvertConsumeMs);      //创意维度-实时-广告消耗
                advertConsumeInfo.put("resourceMs", resoAdvertConsumeMs);  //资源位维度-实时-广告消耗


                //5、冷启动：走默认出价
                //String strategy = adxRoiControlDoInfo.getStrategy();
                strategy = getStrategyLabel(flowRate);

                if (ideaBidCntMs == 0L) {

                    isCompareGroup = "1";
                    level = AdxLevel.ADX_LEVEL_ZER.getCode();
                    adxAlgoPrice = defaultPrice;

                    if (AdxStrategy.ADX_STRATEGY_SEC.getCode().equals(strategy)
                            || AdxStrategy.ADX_STRATEGY_THI.getCode().equals(strategy)){

                        level = AdxLevel.ADX_LEVEL_TWO.getCode();
                    }

                } else{


                    //步骤6、根据strategy走策略1,2,3
                    AdxRoiFactorDo adxRoiFactor = adxRoiControlDoInfo.getAdxRoiFactorDo();
                    AdxPriceExplorationDo priceExploration = adxRoiControlDoInfo.getPriceExplorationDo();
                    AdxFactorExplorationDo factorExploration = adxRoiControlDoInfo.getFactorExplorationDo();

                    //策略1
                    Map<String, String> result = StrategyBid.getStrategyFirBid(adxDoInfo, adxRoiFactor, advertConsumeInfo);
                    if (AssertUtil.isNotEmpty(adxRoiFactor)) { adxControlInfo = JSONObject.toJSONString(adxRoiFactor); }

                    //策略2,3
                    if (AdxStrategy.ADX_STRATEGY_SEC.getCode().equals(strategy)){

                        result = StrategyBid.getStrategySecBid(priceExploration, defaultPrice, minPrice);
                        if (AssertUtil.isNotEmpty(priceExploration)) { adxControlInfo = JSONObject.toJSONString(priceExploration); }

                    } else if (AdxStrategy.ADX_STRATEGY_THI.getCode().equals(strategy)){

                        result = StrategyBid.getStrategyThiBid(adxDoInfo, factorExploration, advertConsumeInfo, minPrice);
                        if (AssertUtil.isNotEmpty(factorExploration)) { adxControlInfo = JSONObject.toJSONString(factorExploration); }
                    }


                    isCompareGroup = "0";
                    level = result.get("level");
                    adxAlgoPrice = DataUtil.string2Long(result.get("price"));


                    //步骤7、最优出价约束
                    if (feeType != null && feeType == 1 && (!AdxStrategy.ADX_STRATEGY_SEC.getCode().equals(strategy))) {

                        if (AssertUtil.isNotEmpty(priceExploration)
                                && priceExploration.getUpLimitBidFee() != null) {

                            Long upLimitPrice = DataUtil.double2Long(priceExploration.getUpLimitBidFee());
                            adxAlgoPrice = Math.min(adxAlgoPrice, upLimitPrice);
                        }
                    }


                }


                //AdxAlgoBidding异常日志记录
                if ((StringUtils.equals(strategy, "1") && !StringUtils.equals(level, "0"))
                        || (StringUtils.equals(strategy, "2") && StringUtils.equals(level, "0"))
                        || (StringUtils.equals(strategy, "3") && StringUtils.equals(level, "0"))
                ) {
                    logger.info(String.format("AdxAlgoBidding Exception Logging, " +
                                    "Result: [level: %s; isCompareGroup: %s; adxAlgoPrice: %s; strategy: %s]; " +
                                    "Parameter[strategy]: %s；Parameter[adxDo]: %s; Parameter[controlDo]: %s",
                            level, isCompareGroup, adxAlgoPrice, JSONObject.toJSONString(strategy),
                            JSONObject.toJSONString(adxRoiControlDoInfo.getStrategy()),
                            JSONObject.toJSONString(adxDoInfo),
                            JSONObject.toJSONString(adxRoiControlDoInfo)));
                }

                //测试预发券耗时问题-创意id=2979
                //if (adxDoInfo.getIdeaId() != null && adxDoInfo.getIdeaId() == 2979L) {
                //    Thread.sleep(20);   // 休眠20ms
                //}

            }

            retMap.put("level", level);
            retMap.put("isCompareGroup", isCompareGroup);
            retMap.put("adxAlgoPrice", DataUtil.Long2String(adxAlgoPrice));
            retMap.put("strategy", strategy);
            retMap.put("adxControlInfo", adxControlInfo);


        } catch (Exception e) {
            logger.error("AdxAlgoBidding.getAdxAlgoPrice error:" + e);
        }

        return retMap;
    }





    /**
     * 按配比随机切分，获取策略
     *
     * @param flowRateInfo   策略-流量配比
     * @return 策略
     */
    public static String getStrategyLabel(AdxFlowRateDo flowRateInfo) {

        String ret = AdxStrategy.ADX_STRATEGY_FIR.getCode();

        if (AssertUtil.isNotEmpty(flowRateInfo)) {

            Double secFlowRate = StrategyBid.nullToDefault(flowRateInfo.getSecFlowRate(),0.0);
            Double thiFlowRate = StrategyBid.nullToDefault(flowRateInfo.getThiFlowRate(),0.0);

            double random = Math.random();

            if (random <= secFlowRate) {
                ret = AdxStrategy.ADX_STRATEGY_SEC.getCode();

            } else if (random <= secFlowRate + thiFlowRate) {
                ret = AdxStrategy.ADX_STRATEGY_THI.getCode();

            }

        }

        return ret;
    }





    //单元测试
    public static void main(String[] args){

        try {

            AdxDo adxDoInfo1 = new AdxDo();
            adxDoInfo1.setMinRoi(1.29);
            adxDoInfo1.setStatCtr(0.187418);
            adxDoInfo1.setCurrentPreValue(0.17632);
            adxDoInfo1.setStatClickValue(10.034965);
            adxDoInfo1.setStatCtrResource(0.211918);
            adxDoInfo1.setStatClickValueResource(7.880267);
            adxDoInfo1.setPredClickValue(null);

            AdxFlowRateDo flowRateInfo1 = new AdxFlowRateDo();
            flowRateInfo1.setFirFlowRate(0.48);
            flowRateInfo1.setSecFlowRate(0.18);
            flowRateInfo1.setThiFlowRate(0.34);
            String strategyLabel1 = AdxAlgoBidding.getStrategyLabel(flowRateInfo1);
            System.out.println("strategyLabel1:" + JSON.toJSONString(strategyLabel1));

            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();


            String str =
                    "{\"adxRoiFactorDo\":{\"advertConsumeDay\":22780.0,\"advertConsumeMs\":40.0,\"adxConsumeDay\":19091.78,\"adxConsumeMs\":62.24,\"adxRoiFactor\":0.720041,\"bidCntDay\":40567,\"bidCntMs\":1223,\"lastRealRoi\":0.642675,\"roiDay\":1.193185,\"roiMs\":0.642675,\"sucBidCntDay\":11867,\"sucBidCntMs\":45,\"sucDay\":0.292529,\"sucMs\":0.036795},\"basePrice\":1400.0,\"defaultPrice\":1401,\"factorExplorationDo\":{\"advertConsumeDay\":5132.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":5072.55,\"adxConsumeMs\":3.01,\"bidCntDay\":39264,\"bidCntMs\":220,\"factorExploreMap\":{\"1\":0.760001,\"2\":1.0,\"3\":1.050001},\"factorFlowRateMap\":{\"1\":0.2,\"2\":0.601,\"3\":0.2},\"lastRealRoiMap\":{\"1\":1.151498,\"2\":1.290001,\"3\":1.290001},\"lastSucRateMap\":{\"1\":0.018182,\"2\":0.0,\"3\":0.0},\"roiDay\":1.011722,\"roiMs\":1.216822,\"sucBidCntDay\":3344,\"sucBidCntMs\":4,\"sucDay\":0.085168,\"sucMs\":0.018182,\"tryLabel\":1},\"feeType\":1,\"ideaIndexMap\":{\"bidSuc\":862,\"advertConsume\":1435,\"adxConsume\":10742209000,\"bid\":3468,\"exp\":763,\"click\":143},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":22780.0,\"advertConsumeMs\":40.0,\"adxConsumeDay\":19091.78,\"adxConsumeMs\":62.24,\"adxRoiFactor\":0.720041,\"bidCntDay\":40567,\"bidCntMs\":1223,\"lastRealRoi\":0.642675,\"roiDay\":1.193185,\"roiMs\":0.642675,\"sucBidCntDay\":11867,\"sucBidCntMs\":45,\"sucDay\":0.292529,\"sucMs\":0.036795},\"lastFactorExplorationDo\":{\"advertConsumeDay\":5132.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":5072.55,\"adxConsumeMs\":3.01,\"bidCntDay\":39264,\"bidCntMs\":220,\"factorExploreMap\":{\"1\":0.760001,\"2\":1.0,\"3\":1.050001},\"factorFlowRateMap\":{\"1\":0.2,\"2\":0.601,\"3\":0.2},\"lastRealRoiMap\":{\"1\":1.151498,\"2\":1.290001,\"3\":1.290001},\"lastSucRateMap\":{\"1\":0.018182,\"2\":0.0,\"3\":0.0},\"roiDay\":1.011722,\"roiMs\":1.216822,\"sucBidCntDay\":3344,\"sucBidCntMs\":4,\"sucDay\":0.085168,\"sucMs\":0.018182,\"tryLabel\":1},\"lastMinRoi\":1.29,\"lastPriceExplorationDo\":{\"advertConsumeDay\":21137.0,\"advertConsumeMs\":1324.0,\"adxConsumeDay\":18815.99,\"adxConsumeMs\":1008.98,\"bidCntDay\":31442,\"bidCntMs\":814,\"lastRealRoiMap\":{\"1\":1.477514,\"2\":1.329762,\"3\":1.323147},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.997089,\"3\":1.0},\"priceExploreMap\":{\"1\":1372,\"2\":1400,\"3\":1407},\"priceFlowRateMap\":{\"1\":0.1,\"2\":0.801,\"3\":0.1},\"roiDay\":1.123354,\"roiMs\":1.312225,\"sucBidCntDay\":14317,\"sucBidCntMs\":812,\"sucDay\":0.455347,\"sucMs\":0.997543,\"tryLabel\":0,\"upLimitBidFee\":1400},\"maxPrice\":1901,\"minPrice\":1321,\"minRoi\":1.29,\"priceExplorationDo\":{\"advertConsumeDay\":21137.0,\"advertConsumeMs\":1324.0,\"adxConsumeDay\":18815.99,\"adxConsumeMs\":1008.98,\"bidCntDay\":31442,\"bidCntMs\":814,\"lastRealRoiMap\":{\"1\":1.477514,\"2\":1.329762,\"3\":1.323147},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.997089,\"3\":1.0},\"priceExploreMap\":{\"1\":1372,\"2\":1400,\"3\":1407},\"priceFlowRateMap\":{\"1\":0.1,\"2\":0.801,\"3\":0.1},\"roiDay\":1.123354,\"roiMs\":1.312225,\"sucBidCntDay\":14317,\"sucBidCntMs\":812,\"sucDay\":0.455347,\"sucMs\":0.997543,\"tryLabel\":0,\"upLimitBidFee\":1400},\"resourceIndexMap\":{\"bidSuc\":51081,\"advertConsume\":75556,\"adxConsume\":634190900000,\"bid\":56634,\"exp\":45244,\"click\":9588},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":11916,\"advertConsume\":22780,\"adxConsume\":191604170000,\"bid\":40614,\"exp\":11310,\"click\":2258}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":7746,\"advertConsume\":10821,\"adxConsume\":100656830000,\"bid\":24863,\"exp\":7189,\"click\":1254}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":6630,\"advertConsume\":10504,\"adxConsume\":88231530000,\"bid\":6638,\"exp\":6221,\"click\":1099}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":1664,\"advertConsume\":1898,\"adxConsume\":25097037000,\"bid\":7460,\"exp\":1583,\"click\":301}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1406,\"advertConsume\":2449,\"adxConsume\":21361369000,\"bid\":24639,\"exp\":1326,\"click\":320}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":285,\"advertConsume\":785,\"adxConsume\":4429634000,\"bid\":7219,\"exp\":265,\"click\":59}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":93,\"advertConsume\":85,\"adxConsume\":1326896000,\"bid\":1211,\"exp\":83,\"click\":11}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":701,\"advertConsume\":1243,\"adxConsume\":8568000000,\"bid\":701,\"exp\":612,\"click\":123}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":125,\"advertConsume\":207,\"adxConsume\":1661600000,\"bid\":125,\"exp\":118,\"click\":23}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":15,\"advertConsume\":0,\"adxConsume\":211088000,\"bid\":219,\"exp\":13,\"click\":4}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":2,\"advertConsume\":0,\"adxConsume\":29430000,\"bid\":665,\"exp\":2,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}]}\n";
            //JSONObject object = JSON.parseObject(str);
            AdxRoiControlDo adxRoiControlDoInfo3 = JSONObject.parseObject(str,AdxRoiControlDo.class);
            adxRoiControlDoInfo3.setAdxFlowRateDo(flowRateInfo1);
            System.out.println("feeType:" + JSON.toJSONString(adxRoiControlDoInfo3.getFeeType()));;

            adxDoInfo1.setIdeaId(2979L);
            Long time1 = LocalDateUtil.getTimeMillis(LocalDateTime.now());
            Map<String, String> ret1 = AdxAlgoBidding.getAdxAlgoPrice(adxDoInfo1,adxRoiControlDoInfo3);
            Long time2 = LocalDateUtil.getTimeMillis(LocalDateTime.now());
            System.out.println("ret:" + JSON.toJSONString(ret1));
            System.out.println("idea:" + JSON.toJSONString(adxDoInfo1.getIdeaId()));
            System.out.println("time:" + JSON.toJSONString(time2 - time1));

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
