/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxFactorExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactorExploration {
    private static final Logger logger = LoggerFactory.getLogger(FactorExploration.class);

    public static AdxFactorExplorationDo getExploreFactor(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxFactorExplorationDo ret = new AdxFactorExplorationDo();
        try {
            Double defaultFactor = 1.0;
            Double defaultMinRoi = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Double[] stepList = new Double[]{-0.05, 0.0, 0.05};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3};
            Double baseValue = defaultFactor;
            Double[] baseFlowRate = new Double[]{0.2, 0.6, 0.2};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0};
            Double[] lastRealSucRate = new Double[]{0.0, 0.0, 0.0};
            HashMap<String, Double> factorMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastSucRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            Long tryLabel = 0L;
            Long lastTryLabel = 0L;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Object stepCon;
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyThiMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyThiDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategyThiMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategyThiMs, minRoi);
                Map<String, Double> roiLevelMs = StrategyBid.getRoiFactorRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);
                roiMs = StrategyBid.getRoi(strategyThiMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategyThiMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategyThiDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategyThiDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                if (bidCntMs == 0L) {
                    tryLabel = 2L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < 2000000000L) {
                    tryLabel = 1L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 2000000000L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()) < minRoi * 0.95) {
                    tryLabel = 1L;
                }
                baseValue = defaultFactor;
                Double lowValue = baseValue + 0.05;
                Double uppValue = baseValue - 0.05;
                Double diff = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || bidCntDay == 0L) {
                    baseValue = defaultFactor;
                } else {
                    Double incre1 = 1.0;
                    AdxFactorExplorationDo lastFactorDoInfo = adxRoiControlDoInfo.getLastFactorExplorationDo();
                    if (AssertUtil.isNotEmpty((Object)lastFactorDoInfo)) {
                        Map<String, Double> lastFactorMap = lastFactorDoInfo.getFactorExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        lastTryLabel = lastFactorDoInfo.getTryLabel();
                        if (AssertUtil.isNotEmpty(lastFactorMap)) {
                            if (lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                baseValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                lowValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                                uppValue = lastFactorMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                            }
                            if (lastFactorMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division((Double)lastFactorMap.get(bestLevel), (Double)baseValue, (int)3);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double baseDiff = baseValue - defaultFactor;
                        baseValue = baseValue - baseDiff * 0.2;
                    } else {
                        Double weight1 = 1.0;
                        weight1 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0)));
                        Double incre2 = 1.0;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((Double)(minRoi * 0.98), (Double)roiMs, (int)3);
                            if (feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.97);
                                incre2 = DataUtil.division((Double)(minRoi * 0.98), (Double)roiStable, (int)3);
                            }
                        }
                        Double weight2 = 1.0;
                        weight2 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                        Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                        incre1 = StrategyBid.getNormalValue(incre1, 1.0, 0.9, 1.1);
                        incre2 = StrategyBid.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
                        Double incre = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
                        if (weight1 == 0.0) {
                            incre = 1.0 + (incre2 - 1.0) * weight2;
                        }
                        Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);
                        if (tryLabel == 0L) {
                            baseValue = StrategyBid.getNormalValue(baseValue * incre, defaultFactor, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff));
                        }
                        if (lastTryLabel == 1L && tryLabel == 0L) {
                            baseValue = uppValue;
                        }
                        baseValue = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(baseValue, defaultFactor, lowerLimit, upperLimit), (int)6);
                    }
                }
                if (tryLabel == 2L) {
                    Double uppDiff = uppValue - defaultFactor;
                    stepList[0] = uppValue - uppDiff * 0.2 - baseValue;
                    Double lowDiff = lowValue - defaultFactor;
                    stepList[2] = lowValue - lowDiff * 0.2 - baseValue;
                } else if (tryLabel == 1L) {
                    stepList[2] = lowValue - baseValue;
                    stepCon = StrategyBid.getTryUppStepCon(adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), 0.1);
                    Double uppDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)minRoi, (int)3);
                    Double stepRoi = uppDiff < 0.8 ? -0.1 : (uppDiff < 0.95 ? -0.07 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? 0.07 : 0.1)));
                    if (adxConsumeMs == 0.0) {
                        stepCon = 0.15;
                        stepRoi = 0.15;
                    }
                    stepList[0] = Math.min(uppValue - baseValue - (0.4 * (Double)stepCon + 0.6 * stepRoi), 0.0);
                } else {
                    stepCon = stepList;
                    Double.valueOf(stepCon[0] - (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
                    stepCon = stepList;
                    Double.valueOf(stepCon[2] + (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
                }
                if (tryLabel == 2L) {
                    baseFlowRate[0] = 0.2;
                    baseFlowRate[2] = 0.2;
                } else if (tryLabel == 1L) {
                    Double tryDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), (Double)minRoi, (int)3);
                    baseFlowRate[0] = StrategyBid.getTryFlowRate(tryDiff, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_ONE.getCode()), adxRoiControlDoInfo);
                    baseFlowRate[2] = baseFlowRate[0] > 0.8 ? 0.0 : 0.2;
                } else if (diff < 0.9) {
                    baseFlowRate[0] = 0.1;
                    baseFlowRate[2] = diff < 0.8 ? 0.3 : 0.2;
                } else if (diff > 1.1) {
                    baseFlowRate[0] = diff < 1.2 ? 0.2 : 0.3;
                    baseFlowRate[2] = 0.1;
                } else if (diff > 0.95 && diff < 1.05) {
                    baseFlowRate[0] = 0.1;
                    baseFlowRate[2] = 0.1;
                } else {
                    baseFlowRate[0] = 0.15;
                    baseFlowRate[2] = 0.15;
                }
                baseFlowRate[1] = DataUtil.formatDouble((Double)(1.0 - baseFlowRate[2] - baseFlowRate[0]), (int)3);
                for (int i = 1; i < AdxLevel.values().length; ++i) {
                    lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                    lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String((Integer)i));
                    if (tryLabel != 1L) continue;
                    lastRealRoi[i - 1] = roiRealLevelMs.get(DataUtil.Integer2String((Integer)i));
                }
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double factor = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(baseValue + stepList[i - 1], defaultFactor, lowerLimit, upperLimit), (int)6);
                Double flowRate = DataUtil.formatDouble((Double)baseFlowRate[i - 1], (int)3);
                Double lastRoi = lastRealRoi[i - 1];
                Double lastSucRate = lastRealSucRate[i - 1];
                factorMap.put(key, factor);
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
                lastSucRateMap.put(key, lastSucRate);
            }
            ret.setFactorExploreMap(factorMap);
            ret.setFactorFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("FactorExploration.getExploreFactor error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setBasePrice(900.0);
            String str = "{\"adxFlowRateDo\":{\"firFlowRate\":0.1,\"roiDiffDayList\":[1.008,0.769,1.031],\"roiDiffMsList\":[0.787,0.578,0.891],\"scoreList\":[16.045,-8.036,17.709],\"secFlowRate\":0.101,\"sucRateDayList\":[0.121,0.064,0.107],\"sucRateMsList\":[0.044,0.071,0.059],\"thiFlowRate\":0.801},\"adxRoiFactorDo\":{\"advertConsumeDay\":171523.0,\"advertConsumeMs\":231.0,\"adxConsumeDay\":122587.15,\"adxConsumeMs\":302.5,\"adxRoiFactor\":0.864422,\"bidCntDay\":1125044,\"bidCntMs\":5100,\"lastRealRoi\":0.763662,\"roiDay\":1.399193,\"roiMs\":0.763662,\"sucBidCntDay\":134832,\"sucBidCntMs\":348,\"sucDay\":0.119846,\"sucMs\":0.068236},\"basePrice\":900.0,\"defaultPrice\":900,\"factorExplorationDo\":{\"advertConsumeDay\":380713.0,\"advertConsumeMs\":2291.0,\"adxConsumeDay\":265789.16,\"adxConsumeMs\":1652.42,\"bidCntDay\":2759952,\"bidCntMs\":32429,\"factorExploreMap\":{\"1\":0.829498,\"2\":0.829498,\"3\":0.8795},\"factorFlowRateMap\":{\"1\":0.061,\"2\":0.74,\"3\":0.201},\"lastRealRoiMap\":{\"1\":1.290854,\"2\":1.611559,\"3\":2.289869},\"lastSucRateMap\":{\"1\":0.073663,\"2\":0.039826,\"3\":0.020296},\"roiDay\":1.432388,\"roiMs\":1.386455,\"sucBidCntDay\":293614,\"sucBidCntMs\":1910,\"sucDay\":0.106384,\"sucMs\":0.058898,\"tryLabel\":1},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":2828,\"advertConsume\":2814,\"adxConsume\":23666550000,\"bid\":67980,\"exp\":2585,\"click\":632},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":171523.0,\"advertConsumeMs\":231.0,\"adxConsumeDay\":122587.15,\"adxConsumeMs\":302.5,\"adxRoiFactor\":0.864422,\"bidCntDay\":1125044,\"bidCntMs\":5100,\"lastRealRoi\":0.763662,\"roiDay\":1.399193,\"roiMs\":0.763662,\"sucBidCntDay\":134832,\"sucBidCntMs\":348,\"sucDay\":0.119846,\"sucMs\":0.068236},\"lastFactorExplorationDo\":{\"advertConsumeDay\":380713.0,\"advertConsumeMs\":2291.0,\"adxConsumeDay\":265789.16,\"adxConsumeMs\":1652.42,\"bidCntDay\":2759952,\"bidCntMs\":32429,\"factorExploreMap\":{\"1\":0.829498,\"2\":0.829498,\"3\":0.8795},\"factorFlowRateMap\":{\"1\":0.061,\"2\":0.74,\"3\":0.201},\"lastRealRoiMap\":{\"1\":1.290854,\"2\":1.611559,\"3\":2.289869},\"lastSucRateMap\":{\"1\":0.073663,\"2\":0.039826,\"3\":0.020296},\"roiDay\":1.432388,\"roiMs\":1.386455,\"sucBidCntDay\":293614,\"sucBidCntMs\":1910,\"sucDay\":0.106384,\"sucMs\":0.058898,\"tryLabel\":1},\"lastMinRoi\":1.39,\"lastPriceExplorationDo\":{\"advertConsumeDay\":27680.0,\"advertConsumeMs\":192.0,\"adxConsumeDay\":25933.17,\"adxConsumeMs\":239.41,\"bidCntDay\":474873,\"bidCntMs\":4116,\"lastRealRoiMap\":{\"1\":1.39,\"2\":1.39,\"3\":0.802006},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.138447},\"priceExploreMap\":{\"1\":567.0,\"2\":630.0,\"3\":900.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.605,\"3\":0.196},\"roiDay\":1.06736,\"roiMs\":0.802006,\"sucBidCntDay\":30232,\"sucBidCntMs\":287,\"sucDay\":0.063664,\"sucMs\":0.069728,\"tryLabel\":1},\"maxPrice\":2500,\"minPrice\":300,\"minRoi\":1.39,\"priceExplorationDo\":{\"advertConsumeDay\":27680.0,\"advertConsumeMs\":192.0,\"adxConsumeDay\":25933.17,\"adxConsumeMs\":239.41,\"bidCntDay\":474873,\"bidCntMs\":4116,\"lastRealRoiMap\":{\"1\":1.39,\"2\":1.39,\"3\":0.802006},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.138447},\"priceExploreMap\":{\"1\":567.0,\"2\":630.0,\"3\":900.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.605,\"3\":0.196},\"roiDay\":1.06736,\"roiMs\":0.802006,\"sucBidCntDay\":30232,\"sucBidCntMs\":287,\"sucDay\":0.063664,\"sucMs\":0.069728,\"tryLabel\":1},\"resourceIndexMap\":{\"bidSuc\":11834,\"advertConsume\":12160,\"adxConsume\":98730970000,\"bid\":310213,\"exp\":10720,\"click\":2588},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":134878,\"advertConsume\":171576,\"adxConsume\":1226307380000,\"bid\":1127696,\"exp\":128268,\"click\":25816}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":27000000,\"bid\":93338,\"exp\":3,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":13011,\"advertConsume\":11989,\"adxConsume\":111303900000,\"bid\":285432,\"exp\":12367,\"click\":2105}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":17404,\"advertConsume\":15879,\"adxConsume\":149503790000,\"bid\":103020,\"exp\":16584,\"click\":2887}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":49419,\"advertConsume\":59010,\"adxConsume\":451280180000,\"bid\":478572,\"exp\":46664,\"click\":9458}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":216998,\"advertConsume\":285743,\"adxConsume\":1961168310000,\"bid\":1977354,\"exp\":204839,\"click\":41735}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":29564,\"advertConsume\":38749,\"adxConsume\":265337310000,\"bid\":361307,\"exp\":27929,\"click\":5830}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":350,\"advertConsume\":266,\"adxConsume\":3078890000,\"bid\":6402,\"exp\":334,\"click\":81}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":1360,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":4011,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":180,\"advertConsume\":155,\"adxConsume\":1494000000,\"bid\":1211,\"exp\":166,\"click\":28}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":156,\"advertConsume\":200,\"adxConsume\":1331320000,\"bid\":3225,\"exp\":145,\"click\":36}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1813,\"advertConsume\":2153,\"adxConsume\":15254170000,\"bid\":38650,\"exp\":1665,\"click\":417}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":278,\"advertConsume\":40,\"adxConsume\":2209790000,\"bid\":10421,\"exp\":242,\"click\":56}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo3 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastFactorExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo3.getLastFactorExplorationDo()));
            AdxFactorExplorationDo ret3 = FactorExploration.getExploreFactor(adxRoiControlDoInfo3);
            System.out.println("ret3:" + JSON.toJSONString((Object)ret3));
            System.out.println("ret3:" + JSON.toJSONString((Object)DataUtil.double2Long((double)35.0, (Long)1L)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

