/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.title;

import cn.com.duiba.nezha.alg.alg.vo.title.FilterActTitleDo;
import cn.com.duiba.nezha.alg.alg.vo.title.PreSelectActTitleDo;
import cn.com.duiba.nezha.alg.alg.vo.title.RecallActTitleDo;
import cn.com.duiba.nezha.alg.alg.vo.title.RecallActTitleInfoDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActTitleRecaller {
    private static final Logger logger = LoggerFactory.getLogger(ActTitleRecaller.class);

    public static RecallActTitleDo recall(List<FilterActTitleDo> filterActTitleDoList, List<PreSelectActTitleDo> preSelectActTitleDoList, boolean hasSubTitle) {
        int i;
        RecallActTitleDo ret = null;
        ArrayList<RecallActTitleInfoDo> recallActTitleInfoDoList = new ArrayList<RecallActTitleInfoDo>();
        HashSet<Long> activityTitleIdSet = new HashSet<Long>();
        HashSet<Long> activitySubTitleIdSet = new HashSet<Long>();
        if (AssertUtil.isEmpty(preSelectActTitleDoList)) {
            preSelectActTitleDoList = new ArrayList<PreSelectActTitleDo>();
        }
        if (AssertUtil.isEmpty(filterActTitleDoList)) {
            logger.error("ActTitleRecaller.recall,input invalid,filterActTitleDoList is null");
            return ret;
        }
        HashMap<String, PreSelectActTitleDo> selectMap = new HashMap<String, PreSelectActTitleDo>();
        for (i = 0; i < preSelectActTitleDoList.size(); ++i) {
            PreSelectActTitleDo preSelectActTitleDo = preSelectActTitleDoList.get(i);
            if (preSelectActTitleDo == null) continue;
            Integer type = preSelectActTitleDo.getType();
            Long activityTitleId = preSelectActTitleDo.getActivityTitleId();
            Long activitySubTitleId = preSelectActTitleDo.getActivitySubTitleId();
            if (!ActTitleRecaller.selectValid(preSelectActTitleDo).booleanValue()) {
                logger.warn("ActTitleRecaller.getTypeKey input invalid," + JSON.toJSONString((Object)preSelectActTitleDo));
                continue;
            }
            String key = ActTitleRecaller.getTypeKey(type, activityTitleId, activitySubTitleId);
            selectMap.put(key, preSelectActTitleDo);
        }
        for (i = 0; i < filterActTitleDoList.size(); ++i) {
            RecallActTitleInfoDo recallActTitleInfoDo = new RecallActTitleInfoDo();
            FilterActTitleDo filterActTitleDo = filterActTitleDoList.get(i);
            if (filterActTitleDo == null) continue;
            recallActTitleInfoDo.setActivityId(filterActTitleDo.getActivityId());
            recallActTitleInfoDo.setActivityPage(filterActTitleDo.getActivityPage());
            recallActTitleInfoDo.setActivityTitleId(filterActTitleDo.getActivityTitleId());
            recallActTitleInfoDo.setActivityTitleTagId(filterActTitleDo.getActivityTitleTagId());
            recallActTitleInfoDo.setActivityTitleName(filterActTitleDo.getActivityTitleName());
            recallActTitleInfoDo.setActivitySubTitleId(filterActTitleDo.getActivitySubTitleId());
            recallActTitleInfoDo.setActivitySubTitleTagId(filterActTitleDo.getActivitySubTitleTagId());
            recallActTitleInfoDo.setActivitySubTitleName(filterActTitleDo.getActivitySubTitleName());
            recallActTitleInfoDo.setIsNew(filterActTitleDo.getIsNew());
            recallActTitleInfoDo.setSubIsNew(filterActTitleDo.getSubIsNew());
            String key1 = ActTitleRecaller.getTypeKey(1, filterActTitleDo.getActivityTitleId(), filterActTitleDo.getActivitySubTitleId());
            String key2 = ActTitleRecaller.getTypeKey(2, filterActTitleDo.getActivityTitleId(), filterActTitleDo.getActivitySubTitleId());
            String key3 = ActTitleRecaller.getTypeKey(3, filterActTitleDo.getActivityTitleId(), filterActTitleDo.getActivitySubTitleId());
            if (selectMap.containsKey(key1)) {
                recallActTitleInfoDo.setScore1(((PreSelectActTitleDo)selectMap.get(key1)).getScore());
                recallActTitleInfoDo.setRank1(((PreSelectActTitleDo)selectMap.get(key1)).getRank());
                recallActTitleInfoDo.setHasType(true);
            }
            if (selectMap.containsKey(key2)) {
                recallActTitleInfoDo.setScore2(((PreSelectActTitleDo)selectMap.get(key2)).getScore());
                recallActTitleInfoDo.setRank2(((PreSelectActTitleDo)selectMap.get(key2)).getRank());
                recallActTitleInfoDo.setHasType(true);
            }
            if (selectMap.containsKey(key3)) {
                recallActTitleInfoDo.setScore3(((PreSelectActTitleDo)selectMap.get(key3)).getScore());
                recallActTitleInfoDo.setRank3(((PreSelectActTitleDo)selectMap.get(key3)).getRank());
                recallActTitleInfoDo.setHasType(true);
            }
            boolean isRecall = false;
            if (recallActTitleInfoDo.getHasType() != null && recallActTitleInfoDo.getHasType().booleanValue()) {
                isRecall = true;
            } else {
                if (recallActTitleInfoDo.getIsNew() != null && recallActTitleInfoDo.getIsNew().equals(1)) {
                    isRecall = true;
                }
                if (recallActTitleInfoDo.getSubIsNew() != null && recallActTitleInfoDo.getSubIsNew().equals(1)) {
                    isRecall = true;
                }
            }
            if (!isRecall) continue;
            recallActTitleInfoDoList.add(recallActTitleInfoDo);
            if (recallActTitleInfoDo.getActivityTitleId() != null) {
                activityTitleIdSet.add(recallActTitleInfoDo.getActivityTitleId());
            }
            if (recallActTitleInfoDo.getActivitySubTitleId() == null) continue;
            activitySubTitleIdSet.add(recallActTitleInfoDo.getActivitySubTitleId());
        }
        ret = new RecallActTitleDo();
        ArrayList<Long> activityTitleIdList = new ArrayList<Long>(activityTitleIdSet);
        ArrayList<Long> activitySubTitleIdList = new ArrayList<Long>(activitySubTitleIdSet);
        ret.setRecallActTitleInfoDo(recallActTitleInfoDoList);
        ret.setActivityTitleIdList(activityTitleIdList);
        ret.setActivitySubTitleIdList(activitySubTitleIdList);
        return ret;
    }

    private static String getTypeKey(Integer type, Long activityTitleId, Long activitySubTitleId) {
        String ret = null;
        if (type.equals(1)) {
            ret = "k1-" + activityTitleId + "-" + activitySubTitleId;
        }
        if (type.equals(1)) {
            ret = "k2-" + activityTitleId + "-" + activitySubTitleId;
        }
        if (type.equals(1)) {
            ret = "k3-" + activityTitleId + "-" + activitySubTitleId;
        }
        return ret;
    }

    private static Boolean selectValid(PreSelectActTitleDo preSelectActTitleDo) {
        Boolean ret = true;
        if (preSelectActTitleDo == null) {
            ret = false;
            return ret;
        }
        if (preSelectActTitleDo.getType() == null || preSelectActTitleDo.getType() < 1 || preSelectActTitleDo.getType() > 3) {
            ret = false;
            return ret;
        }
        if (preSelectActTitleDo.getScore() == null || preSelectActTitleDo.getRank() == null) {
            ret = false;
            return ret;
        }
        return ret;
    }
}

