/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.ExampleTest;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;

public class RatioShunt {
    public static final Random RANDOM = new Random();
    private static final int DEF_FULL_RATIO = 100;

    public static <T> Optional<T> randomRatioShunt(int fullRatio, TreeMap<Integer, T> ratioShuntTree) {
        fullRatio = RatioShunt.switchFullRatio(fullRatio);
        return RatioShunt.ratioShunt(RANDOM.nextInt(fullRatio), fullRatio, ratioShuntTree);
    }

    public static <T> Optional<T> ratioShunt(int shuntVal, int fullRatio, TreeMap<Integer, T> ratioShuntTree) {
        if (RatioShunt.isEmpty(ratioShuntTree)) {
            return Optional.empty();
        }
        int shuntNum = (shuntVal = Math.abs(shuntVal)) % (fullRatio = RatioShunt.switchFullRatio(fullRatio));
        Map.Entry<Integer, T> entry = ratioShuntTree.ceilingEntry(shuntNum);
        return Objects.isNull(entry) ? Optional.empty() : Optional.ofNullable(entry.getValue());
    }

    private static int switchFullRatio(int fullRatio) {
        return fullRatio <= 0 ? 100 : fullRatio;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <U, T> TreeMap<Integer, T> createRatioShuntTree(Collection<U> shuntEntrys, Function<U, Integer> getRatioFuc, Function<U, T> getValueFuc) {
        if (CollectionUtils.isEmpty(shuntEntrys)) {
            return new TreeMap();
        }
        int currentKey = -1;
        TreeMap<Integer, T> ratioTree = new TreeMap<Integer, T>();
        for (U entry : shuntEntrys) {
            Integer ratio = getRatioFuc.apply(entry);
            if (!Objects.nonNull(ratio) || ratio <= 0) continue;
            ratioTree.put(currentKey += ratio.intValue(), getValueFuc.apply(entry));
        }
        return ratioTree;
    }

    public static <T> TreeMap<Integer, T> createRatioShuntTree(Collection<T> shuntEntrys, Function<T, Integer> getRatioFuc) {
        return RatioShunt.createRatioShuntTree(shuntEntrys, getRatioFuc, entry -> entry);
    }
}

