/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowFilterDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowFiltering {
    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFiltering.class);

    public static AdxFlowFilterDo getFlowFiltering(AdxFlowInfoDo flowInfo, AdxFilterInfoDo filterInfo) {
        AdxFlowFilterDo ret = new AdxFlowFilterDo();
        try {
            Integer flowFilterLabel = 0;
            Integer preInterval = null;
            Integer filterIndex = 1;
            Double filterRate = 0.0;
            Long testRate = 0L;
            boolean isConfident = false;
            if (AssertUtil.isNotEmpty((Object)flowInfo)) {
                Map<Integer, Double> filterMap;
                testRate = AdxStatData.getNormalValue(flowInfo.getTestRate(), 0L, 0L, 100L);
                Double preValue = flowInfo.getCurrentPreValue();
                preInterval = AdxStatData.getPreInterval(preValue);
                if (AssertUtil.isNotEmpty((Object)filterInfo) && AssertUtil.isAllNotEmpty((Object[])new Object[]{preInterval, filterMap = filterInfo.getFilterMap()})) {
                    filterRate = AdxStatData.nullToDefault(filterMap.get(preInterval), 0.0);
                }
                AdxIndexStatDo ideaDayStats = flowInfo.getIdeaDayStats();
                AdxIndexStatsDo ideaDayComputes = AdxStatData.adxIndexCompute(ideaDayStats);
                isConfident = ideaDayComputes.getConfident();
                double random = Math.random();
                if (random < DataUtil.division((Long)testRate, (Long)100L)) {
                    double random2;
                    filterIndex = 2;
                    if (isConfident && (random2 = Math.random()) < filterRate) {
                        flowFilterLabel = 1;
                    }
                }
            }
            ret.setFlowFilterLabel(flowFilterLabel);
            ret.setPreInterval(preInterval);
            ret.setFilterIndex(filterIndex);
        }
        catch (Exception e) {
            logger.error("AdxFlowFiltering.getFlowFiltering error:" + e);
        }
        return ret;
    }
}

