/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxPriceExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceExploration {
    private static final Logger logger = LoggerFactory.getLogger(PriceExploration.class);

    public static AdxPriceExplorationDo getExplorePrice(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxPriceExplorationDo ret = new AdxPriceExplorationDo();
        try {
            Double defaultPrice = 10.0;
            Double defaultMinRoi = 1.0;
            Double minPrice = null;
            Double maxPrice = null;
            Double[] stepList = new Double[]{0.95, 1.0, 1.05};
            Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1, 0.15, 0.2, 0.3};
            Double baseValue = defaultPrice;
            Double[] baseFlowRate = new Double[]{0.2, 0.6, 0.2};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0};
            Double[] lastRealSucRate = new Double[]{0.0, 0.0, 0.0};
            HashMap<String, Double> priceMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastSucRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            Long tryLabel = 0L;
            Double upLimitBidFee = null;
            Long lastTryLabel = 0L;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategySecMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategySecDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategySecMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategySecMs, minRoi);
                Map<String, Double> roiLevelMs = StrategyBid.getRoiPriceRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);
                roiMs = StrategyBid.getRoi(strategySecMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategySecMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategySecDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategySecDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                defaultPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(), 10L));
                minPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinPrice(), 1L));
                maxPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMaxPrice(), DataUtil.double2Long((Double)defaultPrice) + 1L));
                Double basePrice = adxRoiControlDoInfo.getBasePrice();
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                if (bidCntMs == 0L) {
                    tryLabel = 2L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < 2000000000L) {
                    tryLabel = 1L;
                } else if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05 && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 2000000000L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < minRoi * 0.95) {
                    tryLabel = 1L;
                }
                baseValue = defaultPrice;
                Double lowValue = baseValue * 0.95;
                Double uppValue = baseValue * 1.05;
                Double diff = DataUtil.division((Double)roiMs, (Double)minRoi, (int)3);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || bidCntDay == 0L) {
                    baseValue = defaultPrice;
                } else {
                    Object stepCon;
                    Double incre1 = 1.0;
                    AdxPriceExplorationDo lastPriceDoInfo = adxRoiControlDoInfo.getLastPriceExplorationDo();
                    if (AssertUtil.isNotEmpty((Object)lastPriceDoInfo)) {
                        Map<String, Double> lastPriceMap = lastPriceDoInfo.getPriceExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        lastTryLabel = lastPriceDoInfo.getTryLabel();
                        if (AssertUtil.isNotEmpty(lastPriceMap)) {
                            if (lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                baseValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                lowValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                                uppValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_THR.getCode());
                            }
                            upLimitBidFee = StrategyBid.selectUpLimitFee(lastPriceMap, sucRateLevelMs, lastPriceDoInfo.getUpLimitBidFee());
                            if (lastPriceMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division((Double)lastPriceMap.get(bestLevel), (Double)baseValue, (int)3);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double baseDiff = DataUtil.division((Double)baseValue, (Double)defaultPrice) - 1.0;
                        baseValue = baseValue - defaultPrice * baseDiff * 0.2;
                    } else {
                        Double weight1 = 1.0;
                        weight1 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0)));
                        Double incre2 = 1.0;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division((Double)roiMs, (Double)(minRoi * 0.98), (int)3);
                            if (upLimitBidFee != null && feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.98);
                                incre2 = DataUtil.division((Double)roiStable, (Double)(minRoi * 0.98), (int)3);
                            }
                            Double weight2 = 1.0;
                            weight2 = sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                            Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                            incre1 = StrategyBid.getNormalValue(incre1, 1.0, 0.9, 1.1);
                            incre2 = StrategyBid.getNormalValue(incre2, 1.0, 1.0 - remainStableLimit, 1.0 + remainStableLimit);
                            Double incre = 1.0 + (incre1 - 1.0) * weight1 * 0.5 + (incre2 - 1.0) * weight2 * 0.5;
                            if (weight1 == 0.0 || diff > 1.3) {
                                incre = 1.0 + (incre2 - 1.0) * weight2;
                            }
                            Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);
                            if (tryLabel == 0L) {
                                Double MojiRoiLimit = StrategyBid.getMojiRoiLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);
                                baseValue = upLimitBidFee != null && feeType != null && feeType == 1 ? (StrategyBid.getBaseLevelConfident(resoSucRateMs, sucRateLevelMs, adxConsumeLevelMs) == 1L && roiMs >= minRoi * MojiRoiLimit && roiMs <= minRoi ? Double.valueOf(Math.max(upLimitBidFee, baseValue)) : StrategyBid.getNormalValue(baseValue * incre, defaultPrice, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff))) : StrategyBid.getNormalValue(baseValue * incre, defaultPrice, baseValue * (1.0 - coeff), baseValue * (1.0 + coeff));
                            }
                            if (lastTryLabel == 1L && tryLabel == 0L) {
                                baseValue = uppValue;
                            }
                            if (basePrice != null && basePrice > 0.0 && diff > 1.3) {
                                baseValue = Math.max(basePrice, baseValue);
                            }
                            if (upLimitBidFee != null && feeType != null && feeType == 1) {
                                if (lastTryLabel == 1L && tryLabel == 1L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) > minRoi * 0.95) {
                                    baseValue = uppValue;
                                }
                                baseValue = Math.min(upLimitBidFee, baseValue);
                            }
                        }
                    }
                    if (tryLabel == 2L) {
                        Double uppDiff = DataUtil.division((Double)uppValue, (Double)defaultPrice) - 1.0;
                        stepList[2] = DataUtil.division((Double)(uppValue - defaultPrice * uppDiff * 0.2), (Double)baseValue);
                        Double lowDiff = DataUtil.division((Double)lowValue, (Double)defaultPrice) - 1.0;
                        stepList[0] = DataUtil.division((Double)(lowValue - defaultPrice * lowDiff * 0.2), (Double)baseValue);
                    } else if (tryLabel == 1L) {
                        stepList[0] = DataUtil.division((Double)lowValue, (Double)baseValue);
                        stepCon = StrategyBid.getTryUppStepCon(adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), 0.08);
                        Double uppDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)minRoi, (int)3);
                        Double stepRoi = uppDiff < 0.8 ? -0.08 : (uppDiff < 0.95 ? -0.06 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.2 ? 0.06 : 0.08)));
                        if (adxConsumeMs == 0.0) {
                            stepCon = 0.1;
                            stepRoi = 0.1;
                        }
                        stepList[2] = Math.max(DataUtil.division((Double)uppValue, (Double)baseValue) + 0.4 * (Double)stepCon + 0.6 * stepRoi, 1.0);
                    } else {
                        stepCon = stepList;
                        Double.valueOf(stepCon[2] + (diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.0 : (diff < 1.3 ? 0.03 : 0.05)))));
                        stepCon = stepList;
                        Double.valueOf(stepCon[0] - (diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.0 : (diff < 0.95 ? -0.02 : -0.03)))));
                    }
                    if (upLimitBidFee != null) {
                        stepList[2] = Math.min(stepList[2], DataUtil.division((Double)upLimitBidFee, (Double)baseValue));
                    }
                    if (basePrice != null && basePrice > 0.0) {
                        stepList[2] = Math.max(stepList[2], DataUtil.division((Double)basePrice, (Double)baseValue));
                    }
                    if (tryLabel == 2L) {
                        baseFlowRate[2] = 0.2;
                        baseFlowRate[0] = 0.2;
                    } else if (tryLabel == 1L) {
                        Double tryDiff = DataUtil.division((Double)roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), (Double)minRoi, (int)3);
                        baseFlowRate[2] = StrategyBid.getTryFlowRate(tryDiff, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), 0.8);
                        baseFlowRate[0] = 0.2;
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {
                            baseFlowRate[2] = StrategyBid.getMojiTryFlowRate(roiDay, roiMs, minRoi, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                            baseFlowRate[0] = 0.0;
                        }
                    } else {
                        if (diff < 0.9) {
                            baseFlowRate[2] = 0.1;
                            baseFlowRate[0] = diff < 0.8 ? 0.3 : 0.2;
                        } else if (diff > 1.1) {
                            baseFlowRate[2] = diff < 1.2 ? 0.2 : 0.3;
                            baseFlowRate[0] = 0.1;
                        } else if (diff > 0.95 && diff < 1.05) {
                            baseFlowRate[2] = 0.1;
                            baseFlowRate[0] = 0.1;
                        } else {
                            baseFlowRate[2] = 0.15;
                            baseFlowRate[0] = 0.15;
                        }
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {
                            baseFlowRate[2] = StrategyBid.getMojiNormalFlowRate(roiDay, roiMs, minRoi, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                            baseFlowRate[0] = 0.0;
                        }
                    }
                    baseFlowRate[1] = DataUtil.formatDouble((Double)(1.0 - baseFlowRate[0] - baseFlowRate[2]), (int)3);
                    for (int i = 1; i < AdxLevel.values().length; ++i) {
                        lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                        lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String((Integer)i));
                        if (tryLabel != 1L) continue;
                        lastRealRoi[i - 1] = roiRealLevelMs.get(DataUtil.Integer2String((Integer)i));
                    }
                }
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double price = DataUtil.formatDouble((Double)(baseValue * stepList[i - 1]), (int)3);
                Double flowRate = DataUtil.formatDouble((Double)baseFlowRate[i - 1], (int)3);
                Double lastRoi = lastRealRoi[i - 1];
                Double lastSucRate = lastRealSucRate[i - 1];
                if (AssertUtil.isAllNotEmpty((Object[])new Object[]{minPrice, maxPrice})) {
                    price = StrategyBid.getNormalValue(price, defaultPrice, minPrice, maxPrice);
                }
                priceMap.put(key, price);
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
                lastSucRateMap.put(key, lastSucRate);
            }
            ret.setPriceExploreMap(priceMap);
            ret.setPriceFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setUpLimitBidFee(upLimitBidFee);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("PriceExploration.getExplorePrice error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setDefaultPrice(1400L);
            adxRoiControlDoInfo1.setMinPrice(1000L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setStrategy("1");
            adxRoiControlDoInfo1.setLastMinRoi(1.2);
            adxRoiControlDoInfo1.setMinRoi(1.2);
            HashMap<String, Long> ideaIndexMap1 = new HashMap<String, Long>();
            ideaIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            ideaIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            ideaIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            ideaIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            ideaIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800000000L);
            ideaIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);
            HashMap<String, Long> resourceIndexMap1 = new HashMap<String, Long>();
            resourceIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            resourceIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            resourceIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            resourceIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            resourceIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800000000L);
            resourceIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);
            adxRoiControlDoInfo1.setIdeaIndexMap(ideaIndexMap1);
            adxRoiControlDoInfo1.setResourceIndexMap(resourceIndexMap1);
            String str = "{\"adxFlowRateDo\":{\"firFlowRate\":0.167,\"roiDiffDayList\":[0.514,0.315,0.502],\"roiDiffMsList\":[0.566,0.314,0.551],\"scoreList\":[-3.219,-14.511,-1.441],\"secFlowRate\":0.101,\"sucRateDayList\":[0.084,0.23,0.037],\"sucRateMsList\":[0.078,0.231,0.033],\"thiFlowRate\":0.734},\"adxRoiFactorDo\":{\"advertConsumeDay\":6696.0,\"advertConsumeMs\":2677.0,\"adxConsumeDay\":8846.43,\"adxConsumeMs\":3001.4,\"adxConsumeTs\":7287.457395,\"adxRoiFactor\":0.740637,\"bidCntDay\":1113927,\"bidCntMs\":487651,\"lastRealRoi\":0.89192,\"roiDay\":0.756917,\"roiMs\":0.89192,\"sucBidCntDay\":85495,\"sucBidCntMs\":29217,\"sucDay\":0.076751,\"sucMs\":0.059914},\"basePrice\":100.0,\"defaultPrice\":650,\"factorExplorationDo\":{\"advertConsumeDay\":6111.0,\"advertConsumeMs\":5715.0,\"adxConsumeDay\":9025.47,\"adxConsumeMs\":7692.88,\"bidCntDay\":2392605,\"bidCntMs\":2309357,\"factorExploreMap\":{\"1\":0.556417,\"2\":0.576417,\"3\":0.676417},\"factorFlowRateMap\":{\"1\":0.101,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.727451,\"2\":0.699371,\"3\":0.958663},\"lastSucRateMap\":{\"1\":0.065313,\"2\":0.019669,\"3\":0.017326},\"roiDay\":0.677085,\"roiMs\":0.742897,\"sucBidCntDay\":87839,\"sucBidCntMs\":75069,\"sucDay\":0.036713,\"sucMs\":0.032507,\"tryLabel\":0},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":147423,\"advertConsume\":12517,\"adxConsume\":151230220000,\"bid\":2119314,\"exp\":147223,\"click\":511},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":6696.0,\"advertConsumeMs\":2677.0,\"adxConsumeDay\":8846.43,\"adxConsumeMs\":3001.4,\"adxConsumeTs\":7287.457395,\"adxRoiFactor\":0.740637,\"bidCntDay\":1113927,\"bidCntMs\":487651,\"lastRealRoi\":0.89192,\"roiDay\":0.756917,\"roiMs\":0.89192,\"sucBidCntDay\":85495,\"sucBidCntMs\":29217,\"sucDay\":0.076751,\"sucMs\":0.059914},\"lastFactorExplorationDo\":{\"advertConsumeDay\":6111.0,\"advertConsumeMs\":5715.0,\"adxConsumeDay\":9025.47,\"adxConsumeMs\":7692.88,\"bidCntDay\":2392605,\"bidCntMs\":2309357,\"factorExploreMap\":{\"1\":0.556417,\"2\":0.576417,\"3\":0.676417},\"factorFlowRateMap\":{\"1\":0.101,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.727451,\"2\":0.699371,\"3\":0.958663},\"lastSucRateMap\":{\"1\":0.065313,\"2\":0.019669,\"3\":0.017326},\"roiDay\":0.677085,\"roiMs\":0.742897,\"sucBidCntDay\":87839,\"sucBidCntMs\":75069,\"sucDay\":0.036713,\"sucMs\":0.032507,\"tryLabel\":0},\"lastMinRoi\":1.35,\"lastPriceExplorationDo\":{\"advertConsumeDay\":2922.0,\"advertConsumeMs\":2804.0,\"adxConsumeDay\":6889.2,\"adxConsumeMs\":6634.11,\"bidCntDay\":299951,\"bidCntMs\":288548,\"lastRealRoiMap\":{\"1\":1.350002,\"2\":1.350002,\"3\":0.422666},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.230908},\"priceExploreMap\":{\"1\":80.0,\"2\":84.895,\"3\":100.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.782,\"3\":0.021},\"roiDay\":0.424144,\"roiMs\":0.422666,\"sucBidCntDay\":68891,\"sucBidCntMs\":66628,\"sucDay\":0.229675,\"sucMs\":0.230908,\"tryLabel\":1},\"maxPrice\":2000,\"minPrice\":80,\"minRoi\":1.35,\"priceExplorationDo\":{\"advertConsumeDay\":2922.0,\"advertConsumeMs\":2804.0,\"adxConsumeDay\":6889.2,\"adxConsumeMs\":6634.11,\"bidCntDay\":299951,\"bidCntMs\":288548,\"lastRealRoiMap\":{\"1\":1.350002,\"2\":1.350002,\"3\":0.422666},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.230908},\"priceExploreMap\":{\"1\":80.0,\"2\":84.895,\"3\":100.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.782,\"3\":0.021},\"roiDay\":0.424144,\"roiMs\":0.422666,\"sucBidCntDay\":68891,\"sucBidCntMs\":66628,\"sucDay\":0.229675,\"sucMs\":0.230908,\"tryLabel\":1},\"resourceIndexMap\":{\"bidSuc\":1708170,\"advertConsume\":391754,\"adxConsume\":1988433360000,\"bid\":9425156,\"exp\":1699271,\"click\":12719},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":87473,\"advertConsume\":6866,\"adxConsume\":90487970000,\"bid\":1143808,\"exp\":87474,\"click\":281}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":73767,\"advertConsume\":4466,\"adxConsume\":73767000000,\"bid\":305987,\"exp\":73767,\"click\":184}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":71752,\"advertConsume\":5504,\"adxConsume\":74040630000,\"bid\":890432,\"exp\":71752,\"click\":201}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":106336,\"advertConsume\":6780,\"adxConsume\":109084700000,\"bid\":2184507,\"exp\":106336,\"click\":326}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":34919,\"advertConsume\":2616,\"adxConsume\":35797050000,\"bid\":963348,\"exp\":34920,\"click\":106}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":21624,\"advertConsume\":2211,\"adxConsume\":22189880000,\"bid\":350218,\"exp\":21624,\"click\":78}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":3920,\"advertConsume\":1318,\"adxConsume\":3920000000,\"bid\":3564,\"exp\":3920,\"click\":38}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":16332,\"advertConsume\":1827,\"adxConsume\":16718780000,\"bid\":158292,\"exp\":16332,\"click\":52}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":79733,\"advertConsume\":5098,\"adxConsume\":82009600000,\"bid\":938662,\"exp\":79733,\"click\":256}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":25333,\"advertConsume\":1757,\"adxConsume\":26050940000,\"bid\":467641,\"exp\":25334,\"click\":79}}],\"strategy\":\"3\"}]}";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastPriceExplorationDo()));
            AdxPriceExplorationDo ret2 = PriceExploration.getExplorePrice(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

