/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDircetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxDirectlyBidding {
    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyBidding.class);

    public static AdxDircetlyPriceDo getAlgoPrice(AdxDirectlyIdeaDo directlyIdeaInfo, AdxDirectlyFactorDo directlyFactorInfo) {
        AdxDircetlyPriceDo ret = new AdxDircetlyPriceDo();
        try {
            Double roiFactor = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Long algoPrice = 0L;
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_TWO.getCode();
            Long ideaBidCntMs = 0L;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{directlyIdeaInfo})) {
                AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(directlyIdeaInfo.getIdeaIndexMap());
                ideaBidCntMs = AdxStatData.nullToMinDefault(interIndexStatMs.getBidCnt(), 0L);
            }
            if (AssertUtil.isNotEmpty((Object)directlyFactorInfo) && ideaBidCntMs != 0L) {
                Map<String, Double> factorMap = directlyFactorInfo.getFactorExploreMap();
                Map<String, Double> FlowRateMap = directlyFactorInfo.getFactorFlowRateMap();
                Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, factorMap, 1.0);
                level = result.get("level");
                roiFactor = AdxStatData.getNormalValue(DataUtil.string2Double((String)result.get("factor")), 1.0, lowerLimit, upperLimit);
            }
            if (AssertUtil.isNotEmpty((Object)directlyIdeaInfo)) {
                Double minRoi = AdxStatData.nullToMinDefault(directlyIdeaInfo.getMinRoi(), 1.0);
                Double cpcPrice = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyCpcPrice(), 0.0);
                Double preCtr = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyPreCtr(), 0.0);
                algoPrice = Math.round(Math.floor(DataUtil.division((Double)(cpcPrice * preCtr * 1000.0), (Double)(minRoi * roiFactor))));
            }
            ret.setAdxAlgoPrice(algoPrice);
            ret.setStrategy(strategy);
            ret.setLevel(level);
        }
        catch (Exception e) {
            logger.error("AdxDirectlyBidding.getAlgoPrice error:" + e);
        }
        return ret;
    }
}

