package cn.com.duiba.nezha.alg.alg.adx.rtbbid;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.CpcControlDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.Optional;

public class AdxCpcAlgoBid {

    private static final Logger logger = LoggerFactory.getLogger(AdxCpcAlgoBid.class);

    /**
     *  RTB互动-按cpc算法出价
     *  逻辑：出价(分/cpm)= ctr*目标cpc(分/单次点击)*cpc维稳因子*1000
     *
     * @param bidRequestDo
     * @return
     */
    public static AdxRtbBidResultDo getAdxAlgoPrice(AdxRtbBidRequestDo bidRequestDo) {

        AdxRtbBidResultDo ret = new AdxRtbBidResultDo();

        /**
         *
         * 步骤：
         * 步骤1、获取融合ctr
         * 步骤2、获取目标cpc
         * 步骤3、获取cpc维稳因子
         * 步骤4、计算出价
         * 步骤4、数据异常告警
         *
         */

        try {

            Double defaultCtr = 0.01;             //ctr预估默认值
            Double preCtrWeight = 0.8;            //ctr模型预估权重
            Double flowerLimit = 0.0;             //ctr统计值*比例下限
            Double fUpperLimit = 4.0;             //ctr统计值*比例上限

            Double defaultFactor = 1.0;           //cpc维稳因子默认值
            Double lowerFactor = 0.3;             //cpc维稳因子下限
            Double upperFactor = 1.7;             //cpc维稳因子上限

            Double defaultCpc = 1.0;              //目标cpc默认值(分/单次点击)
            Integer warnLabel = 0;                //数据是否异常告警

            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_TWO.getCode();
            Long adxAlgoPrice = Math.round(Math.floor(defaultCtr * defaultCpc * defaultFactor * 1000));
            String adxControlInfo = "";

            if (AssertUtil.isNotEmpty(bidRequestDo)) {

                //1.获取融合ctr
                AdxDo adxInfo = Optional.ofNullable(bidRequestDo.getAdxDoInfo()).orElse(new AdxDo());
                Double preCtr = adxInfo.getPreCtr();
                Double statCtr = adxInfo.getStatCtr();
                Double resoStatCtr = adxInfo.getStatCtrResource();

                Long ideaAdxCostDay = 0L, ideaAdConsumeDay = 0L;
                Double statCtrDay = null;
                AdxStatsDo ideaStats = adxInfo.getIdeaStats();
                if (AssertUtil.isNotEmpty(ideaStats)) {
                    AdxIndexStatDo last1DayStat = ideaStats.getLast1DayStat();
                    AdxIndexStatDo last20MinStat = ideaStats.getLast20MinStat();
                    AdxIndexStatsDo ideaStatsDay = AdxStatData.adxIndexCompute(last1DayStat);
                    AdxIndexStatsDo ideaStatsMin = AdxStatData.adxIndexCompute(last20MinStat);
                    ideaAdxCostDay = ideaStatsDay.getAdxConsume();
                    ideaAdConsumeDay = ideaStatsDay.getAdvertConsume();
                    statCtr = AdxStatData.nullToDefault(statCtr, ideaStatsMin.getCtr());
                    statCtrDay = ideaStatsDay.getCtr();
                }

                // 计算融合ctr
                Double statConCtr = AdxStatData.nullToDefault(resoStatCtr, statCtrDay);
                statConCtr = AdxStatData.nullToDefault(statCtr, statConCtr);
                Double conCtr = AdxStatData.getConCtr(preCtr, statConCtr, preCtrWeight, flowerLimit, fUpperLimit, defaultCtr);


                //2.获取目标cpc
                Double targetCpc = AdxStatData.nullToDefault(adxInfo.getTargetCpc(), defaultCpc);


                //3.获取cpc维稳因子
                CpcControlDo cpcControlInfo = Optional.ofNullable(bidRequestDo.getCpcControlInfo()).orElse(new CpcControlDo());
                Map<String, Double> factorMap = cpcControlInfo.getFactorMap();
                Map<String, Double> FlowRateMap = cpcControlInfo.getFlowRateMap();
                Map<String, String> flowSplitResult = StrategyBid.flowSplit(FlowRateMap, factorMap, defaultFactor);
                level = flowSplitResult.get("level");
                Double cpcFactor = AdxStatData.getNormalValue(DataUtil.string2Double(flowSplitResult.get("factor")), defaultFactor, lowerFactor, upperFactor);
                adxControlInfo = JSONObject.toJSONString(cpcFactor);


                //4.计算出价
                adxAlgoPrice = Math.round(Math.floor(conCtr * targetCpc * cpcFactor * 1000));


                //5.数据异常告警（adx消耗<=0 && 广告消耗>500分）
                if (ideaAdxCostDay <= 0L && ideaAdConsumeDay > 500L) {

                    warnLabel = 1;
                    logger.warn(String.format("AdxCpcAlgoBid AdxConsume Exception Logging, " +
                                    "GroupId: %s; ResourceId: %s; IdeaId: %s]; " +
                                    "IdeaAdxConsumeDay: %s; IdeaAdvertConsumeDay: %s;",
                            JSONObject.toJSONString(adxInfo.getGroupId()),
                            JSONObject.toJSONString(adxInfo.getResourceId()),
                            JSONObject.toJSONString(adxInfo.getIdeaId()),
                            JSONObject.toJSONString(ideaAdxCostDay),
                            JSONObject.toJSONString(ideaAdConsumeDay)));
                }

            }

            ret.setLevel(level);
            ret.setStrategy(strategy);
            ret.setAdxAlgoPrice(adxAlgoPrice);
            ret.setAdxControlInfo(adxControlInfo);


        } catch (Exception e) {
            logger.error("AdxCpcAlgoBid.getAdxAlgoPrice error", e);

        }
        return ret;
    }

}