package cn.com.duiba.nezha.alg.alg.basepricecontrol;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;


public class BasePriceControl {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(BasePriceControl.class);

    /**
     *
     * @param basePriceInfo
     * @param lastBasePriceResult
     * @param basePriceParams
     * @return
     */
    public static BasePriceResult basePriceControl (BasePriceInfo basePriceInfo,
                                                    BasePriceResult lastBasePriceResult,
                                                    BasePriceParams basePriceParams) {
        BasePriceResult ret = new BasePriceResult();

        if (AssertUtil.isEmpty(basePriceInfo)) {
            return ret;
        }

        if (Math.random()<0.001) {
            logger.info("params basePriceParams:{}", basePriceParams);
        }


        //  计算底价发券占比

        try {
            ret = getBasePriceRatio(basePriceInfo);

        } catch (Exception e) {
            logger.warn("getBasePriceRatio happend error,lastBasePriceInfo={}", JSON.toJSONString(basePriceInfo), e);
        }


        //  放弃的概率更新
        if (lastBasePriceResult != null) {
            ret.setGiveUpProb5(lastBasePriceResult.getGiveUpProb5());
            ret.setGiveUpProb10(lastBasePriceResult.getGiveUpProb10());
        }

        if (basePriceInfo.manageType == 2) {
            updateProb2(ret,basePriceParams);}
        if (basePriceInfo.manageType == 3) {
            updateProb3(ret,basePriceParams);}

        if (Math.random()<0.001) {
            logger.info("basePriceControl GiveUpProb5:{} GiveUpProb10:{}", ret.getGiveUpProb5(),ret.getGiveUpProb10());
        }


        return ret;
    }



    /**
     * 更新放弃概率-托管配置
     * @param basePriceResult
     * @param basePriceParams
     */
    public static void updateProb2(BasePriceResult basePriceResult,BasePriceParams basePriceParams) {
        Double ret5 = 0.2;
        Double ret10 = 0.2;

        Double totalLearnRate5 = basePriceParams.totalLearnRate2;//0.7
        Double totalLearnRate10 = basePriceParams.totalLearnRate2_2;//0.5

        Double giveUpLowerLimit = basePriceParams.giveUpLowerLimit2;//0.2;
        Double giveUpUpperLimit = basePriceParams.giveUpUpperLimit2;//0.9;

        Double level5RatioLimit = basePriceParams.level5RatioLimit2;//0.02;
        Double level10RatioLimit = basePriceParams.level10RatioLimit2;//0.05;

        if (basePriceResult == null) {
            return;
        }

        Double giveUpProb5 = basePriceResult.getGiveUpProb5();
        if (giveUpProb5 == null) {
            giveUpProb5 = 0.5;
        }
        Double giveUpProb10 = basePriceResult.getGiveUpProb10();
        if (giveUpProb10 == null) {
            giveUpProb10 = 0.4;
        }

        Double level5Ratio = basePriceResult.level5Ratio;
        Double level10Ratio = basePriceResult.level10Ratio;
        Double orientCostConvertBias = basePriceResult.orientCostConvertBias;

        if (level5Ratio >= level5RatioLimit){

            Double totalFactor1 = MathBase.noiseSmoother(10 * level5Ratio, 0.2, 1.0);

            Double totalFactor = totalLearnRate5 + totalFactor1;
            ret5 = giveUpProb5 * totalFactor;
            ret5 = MathBase.noiseSmoother(ret5, 0.5, giveUpUpperLimit);
        }

        if (level10Ratio >= level10RatioLimit){

            Double totalFactor2 = MathBase.noiseSmoother(10 * level10Ratio, 0.5, 1.0);

            Double totalFactor = totalLearnRate10 + totalFactor2;
            ret10 = giveUpProb10 * totalFactor;
            ret10 = MathBase.noiseSmoother(ret10, 0.5, giveUpUpperLimit);
        }

        if (level5Ratio < level5RatioLimit) {
            Double totalFactor1 = MathBase.noiseSmoother(10 * level5Ratio, 0.05, 0.5);

            Double totalFactor = totalLearnRate5 + totalFactor1 ;
            ret5 = giveUpProb5 * totalFactor;
            ret5 = MathBase.noiseSmoother(ret5, giveUpLowerLimit, 0.5);

        }
        if (level10Ratio < level10RatioLimit) {
            Double totalFactor2 = MathBase.noiseSmoother(10 * level10Ratio, 0.1, 0.8);

            Double totalFactor = totalLearnRate10 + totalFactor2;
            ret10 = giveUpProb10 * totalFactor;
            ret10 = MathBase.noiseSmoother(ret10, giveUpLowerLimit, 0.5);

        }


        ret5 = DataUtil.formatDouble(ret5, 3);
        ret10 = DataUtil.formatDouble(ret10, 3);

        basePriceResult.setGiveUpProb5(ret5);
        basePriceResult.setGiveUpProb10(ret10);
    }


    /**
     * 更新放弃概率-普通ocpc配置
     * @param basePriceResult
     * @param basePriceParams
     */
    public static void updateProb3(BasePriceResult basePriceResult,BasePriceParams basePriceParams) {
        Double ret5 = 0.2;
        Double ret10 = 0.2;

        Double totalLearnRate5 = basePriceParams.totalLearnRate3;//0.6;
        Double totalLearnRate10 = basePriceParams.totalLearnRate3_2;//0.6;

        Double giveUpLowerLimit = basePriceParams.giveUpLowerLimit3;//0.1;
        Double giveUpUpperLimit = basePriceParams.giveUpUpperLimit3;//0.8;

        Double level5RatioLimit = basePriceParams.level5RatioLimit3;//0.04;
        Double level10RatioLimit = basePriceParams.level10RatioLimit3;//0.08;

        if (basePriceResult == null) {
            return;
        }

        Double giveUpProb5 = basePriceResult.getGiveUpProb5();
        if (giveUpProb5 == null) {
            giveUpProb5 = 0.5;
        }
        Double giveUpProb10 = basePriceResult.getGiveUpProb10();
        if (giveUpProb10 == null) {
            giveUpProb10 = 0.4;
        }

        Double level5Ratio = basePriceResult.level5Ratio;
        Double level10Ratio = basePriceResult.level10Ratio;
        Double orientCostConvertBias = basePriceResult.orientCostConvertBias;




        if (level5Ratio >= level5RatioLimit) {

            Double totalFactor1 = MathBase.noiseSmoother(10 * level5Ratio, 0.4, 1.0);

            Double totalFactor = totalLearnRate5 + totalFactor1;
            ret5 = giveUpProb5 * totalFactor;
            ret5 = MathBase.noiseSmoother(ret5, 0.5, giveUpUpperLimit);
        }

        if (level10Ratio >= level10RatioLimit) {

            Double totalFactor2 = MathBase.noiseSmoother(10 * level10Ratio, 0.8, 1.0);

            Double totalFactor = totalLearnRate10 + totalFactor2;
            ret10 = giveUpProb10 * totalFactor;
            ret10 = MathBase.noiseSmoother(ret10, 0.5, giveUpUpperLimit);
        }

        if (level5Ratio < level5RatioLimit) {
            Double totalFactor1 = MathBase.noiseSmoother(10 * level5Ratio, 0.1, 0.5);

            Double totalFactor = totalLearnRate5 + totalFactor1;
            ret5 = giveUpProb5 * totalFactor;
            ret5 = MathBase.noiseSmoother(ret5, giveUpLowerLimit, 0.5);

        }
        if (level10Ratio < level10RatioLimit) {
            Double totalFactor2 = MathBase.noiseSmoother(10 * level10Ratio, 0.2, 0.8);

            Double totalFactor = totalLearnRate10 + totalFactor2;
            ret10 = giveUpProb10 * totalFactor;
            ret10 = MathBase.noiseSmoother(ret10, giveUpLowerLimit, 0.5);

        }


        ret5 = DataUtil.formatDouble(ret5, 3);
        ret10 = DataUtil.formatDouble(ret10, 3);

        basePriceResult.setGiveUpProb5(ret5);
        basePriceResult.setGiveUpProb10(ret10);
    }


    /**
     * 得到底价的占比
     * @param basePriceInfo
     * @return
     */

    public static BasePriceResult getBasePriceRatio(BasePriceInfo basePriceInfo) {

        BasePriceResult ret = new BasePriceResult();
        Double level5Ratio = 0.0;
        Double level10Ratio = 0.0;
        Double level15Ratio = 0.0;

        //底价消耗占比
//        Double orientBasePriceRatio = (double)basePriceInfo.orientBasePriceCostToday / (double)basePriceInfo.orientCostToday;
//        Double slotBasePriceRatio = (double)basePriceInfo.slotBasePriceCostToday / (double)basePriceInfo.slotCostToday;
//        Double orientSlotBasePriceRatio = (double)basePriceInfo.orientSlotBasePriceCostToday / (double)basePriceInfo.orientSlotCostToday;

        Double orientCostConvertToday = (basePriceInfo.orientConvertToday != 0) ? ((double)basePriceInfo.orientCostToday / (double)basePriceInfo.orientConvertToday) : (double)basePriceInfo.orientCostToday;
        Double orientCostConvertBias = (basePriceInfo.afee!= 0) ? orientCostConvertToday / basePriceInfo.afee : 1.0;

        //配置底价发券占比
        Double orientLevel5Ratio = 0.0;
        Double orientLevel10Ratio = 0.0;
        Double orientLevel15Ratio = 0.0;
        if (basePriceInfo.orientLaunchToday > 0) {
            orientLevel5Ratio = (double) basePriceInfo.orientLevel5PriceLaunchToday / (double) basePriceInfo.orientLaunchToday;
            orientLevel10Ratio = (double) basePriceInfo.orientLevel10PriceLaunchToday / (double) basePriceInfo.orientLaunchToday;
            orientLevel15Ratio = (double) basePriceInfo.orientLevel15PriceLaunchToday / (double) basePriceInfo.orientLaunchToday;
        }

        //配置广告位底价发券占比
        Double orientSlotLevel5Ratio = 0.0;
        Double orientSlotLevel10Ratio = 0.0;
        Double orientSlotLevel15Ratio = 0.0;

        if (basePriceInfo.orientSlotLaunchToday > 0) {
            orientSlotLevel5Ratio = (double) basePriceInfo.orientSlotLevel5PriceLaunchToday / (double) basePriceInfo.orientSlotLaunchToday;
            orientSlotLevel10Ratio = (double) basePriceInfo.orientSlotLevel10PriceLaunchToday / (double) basePriceInfo.orientSlotLaunchToday;
            orientSlotLevel15Ratio = (double) basePriceInfo.orientSlotLevel15PriceLaunchToday / (double) basePriceInfo.orientSlotLaunchToday;
        }
        if (basePriceInfo.orientLaunchToday > 200) {
            if (basePriceInfo.orientSlotLaunchToday < 100) {
                level5Ratio = orientLevel5Ratio;
                level10Ratio = orientLevel10Ratio;
                level15Ratio = orientLevel15Ratio;
            } else {
                level5Ratio = 0.7 * orientSlotLevel5Ratio + 0.3 * orientLevel5Ratio;
                level10Ratio = 0.7 * orientSlotLevel10Ratio + 0.3 * orientLevel10Ratio;
                level15Ratio = 0.7 * orientSlotLevel15Ratio + 0.3 * orientLevel15Ratio;
            }
        }

        ret.setLevel5Ratio(level5Ratio);
        ret.setLevel10Ratio(level10Ratio);
        ret.setLevel15Ratio(level15Ratio);
        ret.setOrientCostConvertBias(orientCostConvertBias);



        return ret;
    }

    /**
     *
     * @param basePriceInfoList
     * @param lastBasePriceResultMap
     * @param basePriceParams
     * @return
     */
    public static Map<BasePriceInfo, BasePriceResult> basePriceControl(List<BasePriceInfo> basePriceInfoList,
                                                               Map<BasePriceInfo, BasePriceResult> lastBasePriceResultMap,
                                                               BasePriceParams basePriceParams) {

        Map<BasePriceInfo, BasePriceResult> ret = new HashMap<>();
        if (AssertUtil.isAnyEmpty(basePriceInfoList,basePriceParams)) {
            return ret;
        }

        for (BasePriceInfo basePriceInfo : basePriceInfoList) {

            BasePriceResult lastBasePriceResult = null;
            if (lastBasePriceResultMap != null){
                lastBasePriceResult = lastBasePriceResultMap.get(basePriceInfo);}

            BasePriceResult result = basePriceControl(basePriceInfo,
                    lastBasePriceResult,
                    basePriceParams);

            if (result != null) {
                ret.put(basePriceInfo, result);
            }

        }

        return ret;
    }


    /**
     * nezha每次发券调用，返回是否放弃
     * @param basePriceResultMap
     * @param finalFeeMap
     * @param biddingAdvertNum
     * @param <T>
     * @return
     */

    public static <T> Map<T, Boolean> giveUpControl(Map<T, BasePriceResult> basePriceResultMap,
                                                    Map<T, Long> finalFeeMap,
                                                    Integer biddingAdvertNum) {

        Map<T, Boolean> ret = new HashMap<>();
        if (AssertUtil.isAnyEmpty(basePriceResultMap)){
            return ret;
        }
        for (Map.Entry<T, BasePriceResult> entry : basePriceResultMap.entrySet()) {
            T key = entry.getKey();
            BasePriceResult basePriceResult = entry.getValue();
            Double getGiveUpProb5 = basePriceResult.getGiveUpProb5();
            Double getGiveUpProb10 = basePriceResult.getGiveUpProb10();
            Long finalFee = finalFeeMap.get(key);
            Random r = new Random();
            Double x = r.nextDouble();
            Boolean giveUp = false;
            if (finalFee <= 5 && x <= getGiveUpProb5) {
                giveUp = true;
            }
            if (finalFee > 5 && finalFee <= 10 && x <= getGiveUpProb10) {
                giveUp = true;
            }
            if (giveUp != null) {
                ret.put(key, giveUp);
            }
        }
        return ret;
    }
}

