/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

public class OcpxControlParams {
    private Double mFactor = 1.0;
    private Integer resetType;
    private Double cFactor;
    private Boolean cConf;
    private Long fPriceThre;
    private Double fGiveUpProb;
    private Boolean fConf;
    private Long pPriceThre;
    private Boolean pConf;
    private Long ePriceThre;
    private Double eRate;
    private Boolean eConf;
    private String updateTime;

    public static Double getCostFactor(OcpxControlParams params) {
        Double ret = null;
        if (params != null && params.getCConf() != null && params.getCConf().booleanValue()) {
            ret = params.getCFactor();
            if (params.getCFactor() != null && params.getMFactor() != null) {
                ret = Math.max(params.getCFactor(), params.getMFactor());
            }
        }
        return ret;
    }

    public static Double getCostFactorWithProtect(OcpxControlParams params) {
        Double ret = null;
        if (params != null && params.getCConf() != null && params.getCConf().booleanValue() && params.getCFactor() != null && params.getMFactor() != null && params.getMFactor() > params.getCFactor()) {
            ret = 1.0 - (params.getMFactor() - params.getCFactor());
        }
        return ret;
    }

    public static Integer getResetType(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null) {
            return ocpxControlParams.getResetType();
        }
        return null;
    }

    public static Long getExplorePrice(OcpxControlParams ocpxControlParams, Long fee) {
        Long ePriceThre;
        Double adjustFee = fee.doubleValue();
        if (ocpxControlParams != null && ocpxControlParams.getEConf() != null && ocpxControlParams.eConf.booleanValue() && (ePriceThre = ocpxControlParams.getEPriceThre()) != null && fee < ePriceThre) {
            adjustFee = adjustFee + ((double)ePriceThre.longValue() - adjustFee) * 0.5;
        }
        return adjustFee.longValue();
    }

    public static Double getExploreRate(OcpxControlParams ocpxControlParams) {
        if (ocpxControlParams != null && ocpxControlParams.getEConf() != null && ocpxControlParams.getEConf().booleanValue()) {
            return ocpxControlParams.getERate();
        }
        return null;
    }

    public Double getMFactor() {
        return this.mFactor;
    }

    public Integer getResetType() {
        return this.resetType;
    }

    public Double getCFactor() {
        return this.cFactor;
    }

    public Boolean getCConf() {
        return this.cConf;
    }

    public Long getFPriceThre() {
        return this.fPriceThre;
    }

    public Double getFGiveUpProb() {
        return this.fGiveUpProb;
    }

    public Boolean getFConf() {
        return this.fConf;
    }

    public Long getPPriceThre() {
        return this.pPriceThre;
    }

    public Boolean getPConf() {
        return this.pConf;
    }

    public Long getEPriceThre() {
        return this.ePriceThre;
    }

    public Double getERate() {
        return this.eRate;
    }

    public Boolean getEConf() {
        return this.eConf;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setMFactor(Double mFactor) {
        this.mFactor = mFactor;
    }

    public void setResetType(Integer resetType) {
        this.resetType = resetType;
    }

    public void setCFactor(Double cFactor) {
        this.cFactor = cFactor;
    }

    public void setCConf(Boolean cConf) {
        this.cConf = cConf;
    }

    public void setFPriceThre(Long fPriceThre) {
        this.fPriceThre = fPriceThre;
    }

    public void setFGiveUpProb(Double fGiveUpProb) {
        this.fGiveUpProb = fGiveUpProb;
    }

    public void setFConf(Boolean fConf) {
        this.fConf = fConf;
    }

    public void setPPriceThre(Long pPriceThre) {
        this.pPriceThre = pPriceThre;
    }

    public void setPConf(Boolean pConf) {
        this.pConf = pConf;
    }

    public void setEPriceThre(Long ePriceThre) {
        this.ePriceThre = ePriceThre;
    }

    public void setERate(Double eRate) {
        this.eRate = eRate;
    }

    public void setEConf(Boolean eConf) {
        this.eConf = eConf;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OcpxControlParams)) {
            return false;
        }
        OcpxControlParams other = (OcpxControlParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$mFactor = this.getMFactor();
        Double other$mFactor = other.getMFactor();
        if (this$mFactor == null ? other$mFactor != null : !((Object)this$mFactor).equals(other$mFactor)) {
            return false;
        }
        Integer this$resetType = this.getResetType();
        Integer other$resetType = other.getResetType();
        if (this$resetType == null ? other$resetType != null : !((Object)this$resetType).equals(other$resetType)) {
            return false;
        }
        Double this$cFactor = this.getCFactor();
        Double other$cFactor = other.getCFactor();
        if (this$cFactor == null ? other$cFactor != null : !((Object)this$cFactor).equals(other$cFactor)) {
            return false;
        }
        Boolean this$cConf = this.getCConf();
        Boolean other$cConf = other.getCConf();
        if (this$cConf == null ? other$cConf != null : !((Object)this$cConf).equals(other$cConf)) {
            return false;
        }
        Long this$fPriceThre = this.getFPriceThre();
        Long other$fPriceThre = other.getFPriceThre();
        if (this$fPriceThre == null ? other$fPriceThre != null : !((Object)this$fPriceThre).equals(other$fPriceThre)) {
            return false;
        }
        Double this$fGiveUpProb = this.getFGiveUpProb();
        Double other$fGiveUpProb = other.getFGiveUpProb();
        if (this$fGiveUpProb == null ? other$fGiveUpProb != null : !((Object)this$fGiveUpProb).equals(other$fGiveUpProb)) {
            return false;
        }
        Boolean this$fConf = this.getFConf();
        Boolean other$fConf = other.getFConf();
        if (this$fConf == null ? other$fConf != null : !((Object)this$fConf).equals(other$fConf)) {
            return false;
        }
        Long this$pPriceThre = this.getPPriceThre();
        Long other$pPriceThre = other.getPPriceThre();
        if (this$pPriceThre == null ? other$pPriceThre != null : !((Object)this$pPriceThre).equals(other$pPriceThre)) {
            return false;
        }
        Boolean this$pConf = this.getPConf();
        Boolean other$pConf = other.getPConf();
        if (this$pConf == null ? other$pConf != null : !((Object)this$pConf).equals(other$pConf)) {
            return false;
        }
        Long this$ePriceThre = this.getEPriceThre();
        Long other$ePriceThre = other.getEPriceThre();
        if (this$ePriceThre == null ? other$ePriceThre != null : !((Object)this$ePriceThre).equals(other$ePriceThre)) {
            return false;
        }
        Double this$eRate = this.getERate();
        Double other$eRate = other.getERate();
        if (this$eRate == null ? other$eRate != null : !((Object)this$eRate).equals(other$eRate)) {
            return false;
        }
        Boolean this$eConf = this.getEConf();
        Boolean other$eConf = other.getEConf();
        if (this$eConf == null ? other$eConf != null : !((Object)this$eConf).equals(other$eConf)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OcpxControlParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $mFactor = this.getMFactor();
        result = result * 59 + ($mFactor == null ? 43 : ((Object)$mFactor).hashCode());
        Integer $resetType = this.getResetType();
        result = result * 59 + ($resetType == null ? 43 : ((Object)$resetType).hashCode());
        Double $cFactor = this.getCFactor();
        result = result * 59 + ($cFactor == null ? 43 : ((Object)$cFactor).hashCode());
        Boolean $cConf = this.getCConf();
        result = result * 59 + ($cConf == null ? 43 : ((Object)$cConf).hashCode());
        Long $fPriceThre = this.getFPriceThre();
        result = result * 59 + ($fPriceThre == null ? 43 : ((Object)$fPriceThre).hashCode());
        Double $fGiveUpProb = this.getFGiveUpProb();
        result = result * 59 + ($fGiveUpProb == null ? 43 : ((Object)$fGiveUpProb).hashCode());
        Boolean $fConf = this.getFConf();
        result = result * 59 + ($fConf == null ? 43 : ((Object)$fConf).hashCode());
        Long $pPriceThre = this.getPPriceThre();
        result = result * 59 + ($pPriceThre == null ? 43 : ((Object)$pPriceThre).hashCode());
        Boolean $pConf = this.getPConf();
        result = result * 59 + ($pConf == null ? 43 : ((Object)$pConf).hashCode());
        Long $ePriceThre = this.getEPriceThre();
        result = result * 59 + ($ePriceThre == null ? 43 : ((Object)$ePriceThre).hashCode());
        Double $eRate = this.getERate();
        result = result * 59 + ($eRate == null ? 43 : ((Object)$eRate).hashCode());
        Boolean $eConf = this.getEConf();
        result = result * 59 + ($eConf == null ? 43 : ((Object)$eConf).hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        return result;
    }

    public String toString() {
        return "OcpxControlParams(mFactor=" + this.getMFactor() + ", resetType=" + this.getResetType() + ", cFactor=" + this.getCFactor() + ", cConf=" + this.getCConf() + ", fPriceThre=" + this.getFPriceThre() + ", fGiveUpProb=" + this.getFGiveUpProb() + ", fConf=" + this.getFConf() + ", pPriceThre=" + this.getPPriceThre() + ", pConf=" + this.getPConf() + ", ePriceThre=" + this.getEPriceThre() + ", eRate=" + this.getERate() + ", eConf=" + this.getEConf() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

