/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFilterTask;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFilterTaskPlus;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.AdxFlowFiltering;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.ChargePvFiltering;
import cn.com.duiba.nezha.alg.alg.adx.flowfilter.LaunchPvFiltering;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowFilterAlg {
    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFilterAlg.class);

    public static FlowFilterResultDo adxFlowFiltering(FlowFilterRequestDo flowFilterRequestDo) {
        FlowFilterResultDo ret = new FlowFilterResultDo();
        try {
            if (AdxFlowFilterAlg.valid(flowFilterRequestDo).booleanValue()) {
                ret = AdxFlowFiltering.getFlowFiltering(flowFilterRequestDo);
                Integer flowFilterLabel = ret.getFlowFilterLabel();
                Integer flowGroup = AdxStatData.nullToDefault(flowFilterRequestDo.getFlowGroup(), 1);
                Integer baseFilterFlag = AdxStatData.nullToDefault(flowFilterRequestDo.getBaseFilterFlag(), 0);
                if (AssertUtil.isNotEmpty((Object)flowFilterLabel) && flowFilterLabel.equals(0)) {
                    if (flowGroup.equals(1) && baseFilterFlag.equals(1) || flowGroup.equals(3)) {
                        FlowFilterResultDo launchPvRet = LaunchPvFiltering.getLaunchPvFiltering(flowFilterRequestDo);
                        ret.setFlowFilterLabel(launchPvRet.getFlowFilterLabel());
                        ret.setFilterType(launchPvRet.getFilterType());
                        ret.setPreLaunchPv(launchPvRet.getPreLaunchPv());
                    } else if (flowGroup.equals(4)) {
                        FlowFilterResultDo chargePvRet = ChargePvFiltering.getChargePvFiltering(flowFilterRequestDo);
                        ret.setFlowFilterLabel(chargePvRet.getFlowFilterLabel());
                        ret.setFilterType(chargePvRet.getFilterType());
                        ret.setPreChargePv(chargePvRet.getPreChargePv());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering error:" + e);
        }
        return ret;
    }

    public static AdxFilterInfoDo adxFilterTask(AdxFlowInfoDo flowInfo, AdxFilterInfoDo lastFilterInfo) {
        AdxFilterInfoDo ret = null;
        try {
            ret = AdxFilterTask.getFilterInfo(flowInfo, lastFilterInfo);
        }
        catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTask error " + e);
        }
        return ret;
    }

    public static AdxFilterInfoDo adxFilterTaskPlus(AdxFlowInfoDo flowInfo, AdxFilterInfoDo lastFilterInfo) {
        AdxFilterInfoDo ret = null;
        try {
            ret = AdxFilterTaskPlus.getFilterInfo(flowInfo, lastFilterInfo);
        }
        catch (Exception e) {
            logger.error("AdxFlowFilterAlg.adxFilterTaskPlus error " + e);
        }
        return ret;
    }

    private static Boolean valid(FlowFilterRequestDo flowFilterRequestDo) {
        Boolean ret = true;
        if (flowFilterRequestDo == null) {
            logger.error("AdxFlowFilterAlg.adxFlowFiltering() input params valid , params flowFilterRequestDo is null");
            return false;
        }
        return ret;
    }
}

