/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterCntDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterRequestDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FlowFilterResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargePvFiltering {
    private static final Logger logger = LoggerFactory.getLogger(ChargePvFiltering.class);

    public static FlowFilterResultDo getChargePvFiltering(FlowFilterRequestDo flowFilterRequestDo) {
        FlowFilterResultDo ret = new FlowFilterResultDo();
        try {
            AdxFlowInfoDo flowInfo;
            Integer flowFilterLabel = 0;
            Integer filterType = 0;
            boolean isConfident = false;
            Double preWeight = 0.8;
            Double flowerLimit = 0.0;
            Double fUpperLimit = 4.0;
            Double defaultValue = 0.01;
            Double preChargePv = null;
            if (ChargePvFiltering.valid(flowFilterRequestDo).booleanValue()) {
                AdxFeatureDo adxFeatureDo = flowFilterRequestDo.getAdxFeatureDo();
                Map staticFeatureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
                Map dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic((AdxFeatureDo)adxFeatureDo, (AdxFeatureDo)adxFeatureDo);
                FeatureMapDo featureMapDo = new FeatureMapDo();
                featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
                featureMapDo.setStaticFeatureMap(staticFeatureMap);
                HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
                Long ideaId = flowFilterRequestDo.getFlowInfo().getIdeaId();
                featureMap.put(ideaId, featureMapDo);
                CODER2 chargePvCoderModel = flowFilterRequestDo.getChargePvCoderModel();
                LocalTFModel chargePvLtfModel = flowFilterRequestDo.getChargePvLtfModel();
                Map preValueMap = chargePvCoderModel.predictWithLocalTFNew(featureMap, chargePvLtfModel);
                preChargePv = (Double)preValueMap.get(ideaId);
            }
            if (AssertUtil.isNotEmpty((Object)(flowInfo = flowFilterRequestDo.getFlowInfo()))) {
                AdxIndexStatDo ideaMinStats = flowInfo.getIdeaMinStats();
                AdxIndexStatsDo ideaMinComputes = AdxStatData.adxIndexCompute(ideaMinStats);
                AdxIndexStatDo ideaDayStats = flowInfo.getIdeaDayStats();
                AdxIndexStatsDo ideaDayComputes = AdxStatData.adxIndexCompute(ideaDayStats);
                isConfident = ideaMinComputes.getConfident() != false && ideaDayComputes.getConfident() != false;
                Map<Integer, AdxFilterCntDo> ideafilterDo = flowFilterRequestDo.getIdeafilterCntDo();
                Double minfilterRate = AdxStatData.getFilterRate(ideafilterDo, "20min", 3);
                Double dayfilterRate = AdxStatData.getFilterRate(ideafilterDo, "1day", 3);
                Double filterRate = Math.max(minfilterRate, dayfilterRate);
                Double statChargePv = AdxStatData.nullToDefault(ideaMinComputes.getChargePv(), ideaDayComputes.getChargePv());
                Double conChargePv = AdxStatData.getConValue(preChargePv, statChargePv, preWeight, flowerLimit, fUpperLimit, defaultValue);
                Double ChargePvLimit = AdxStatData.nullToMinDefault(flowFilterRequestDo.getChargePvLimit(), 0.0);
                double random = Math.random();
                if (isConfident) {
                    if (conChargePv < ChargePvLimit * 0.8) {
                        flowFilterLabel = random < 0.99 ? 1 : 0;
                    } else if (conChargePv < ChargePvLimit * 0.9) {
                        flowFilterLabel = random < 0.95 ? 1 : 0;
                    } else if (conChargePv < ChargePvLimit) {
                        flowFilterLabel = random < 0.9 ? 1 : 0;
                    }
                }
                double random2 = Math.random();
                if (flowFilterLabel.equals(1)) {
                    if (filterRate > 0.8) {
                        flowFilterLabel = random < 0.2 ? 1 : 0;
                    } else if (filterRate > 0.5) {
                        flowFilterLabel = random2 < 0.5 ? 1 : 0;
                    }
                }
            }
            filterType = flowFilterLabel == 1 ? 3 : 0;
            ret.setFlowFilterLabel(flowFilterLabel);
            ret.setFilterType(filterType);
            ret.setPreChargePv(preChargePv);
        }
        catch (Exception e) {
            logger.error("ChargePvFiltering.getChargePvFiltering error " + e);
        }
        return ret;
    }

    private static Boolean valid(FlowFilterRequestDo flowFilterRequestDo) {
        Boolean ret = true;
        if (flowFilterRequestDo == null) {
            logger.error("ChargePvFiltering.getChargePvFiltering() input params valid , params flowFilterRequestDo is null");
            return false;
        }
        if (flowFilterRequestDo.getChargePvLtfModel() == null) {
            logger.error("ChargePvFiltering.getChargePvFiltering() input params valid , params chargePvLtfModel is null");
            return false;
        }
        if (flowFilterRequestDo.getChargePvCoderModel() == null) {
            logger.error("ChargePvFiltering.getChargePvFiltering() input params valid , params chargePvCoderModel is null");
            return false;
        }
        if (flowFilterRequestDo.getAdxFeatureDo() == null) {
            logger.error("ChargePvFiltering.getChargePvFiltering() input params valid ,params adxFeatureDo is null");
            return false;
        }
        if (flowFilterRequestDo.getFlowInfo() == null) {
            logger.error("ChargePvFiltering.getChargePvFiltering() input params valid ,params flowInfo is null");
            return false;
        }
        return ret;
    }
}

